/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.setting.initconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.enums.BaseDataRightEnum;
import kd.sys.ricc.common.enums.ConfigControlItems;
import kd.sys.ricc.common.enums.ControlMode;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ObjectConverter;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class InitConfigFormPlugin
extends AbstractBillPlugIn {
    private static final String CLEARDATA = "cleardata";
    private static final String ENV_ROLE = "envrole";
    private static final String BASIC_SET_CHANGE = "basicsetchange";
    private static final String USERF7 = "userf7";
    private static final String USER_ENTRY = "user_entry";
    private static final String PERM_FLEXPANELAP = "perm_flexpanelap";
    private static final String CALLBACKID = "bccenter_restore_factory_setting";
    private static final String SAVE_CONFIRM_ACID = "save_confirm_acid";
    public static final String IMPORT_TEMPLATE_HASID = "importtemplatehasid";
    public static final long PK_ID = 1367275628033736704L;
    public static final String ENV_ENTRY = "enventry";
    public static final String CONFIG_TYPE = "configtype";
    private static final String BUTTONAP = "buttonap";
    private static final String CONTROLLED = "controlled";
    public static final String ENVTYPEINFO = "envtypeinfo";
    public static final String ADD_USER = "adduser";
    private static final String ISOLATE_PACKAGE = "isolatepacketage";
    private static final String ISOLATE_TRANSFERTASK = "isolatetransfer";
    private static final String RICC_BDSYNC_LOG = "ricc_bdsync_log";
    private static final String PACK_DATA_LIMIT = "packdatalimit";
    private static final String PACK_SIZE_LIMIT = "packsizelimit";
    private static final String SYSTOKEN = "syspwd";
    private static final String PACKET_SECRET = "packetsecret";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addUserListener();
        this.addItemClickListeners(new String[]{"toolbarap"});
        Button buttonAp = (Button)this.getControl(BUTTONAP);
        buttonAp.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermissionUtil.preOpenFormIsAdmin((PreOpenFormEventArgs)e);
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (!Objects.isNull(initConfig)) {
            BillShowParameter formShowParameter = (BillShowParameter)e.getFormShowParameter();
            formShowParameter.setPkId((Object)1367275628033736704L);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.controlModeChange(ControlMode.WEAK_CONTROL.getMode());
        this.loadSysParam();
        this.setDataPacketAndTransferTaskValue();
    }

    private void loadSysParam() {
        this.getModel().setValue("jarenable", (Object)CommonUtil.getTenantProperty((String)"jar_deploy_enable"));
        this.getModel().setValue(IMPORT_TEMPLATE_HASID, (Object)SysParaUtil.isOpenImportTemplateId());
    }

    private void setDataPacketAndTransferTaskValue() {
        DynamicObjectCollection permRuleObj = PermissionUtil.querySpecialDataPermData((String)"view", (boolean)true, (String[])new String[]{"ricc_transfertask", "ricc_datapacket"});
        for (DynamicObject permRule : permRuleObj) {
            String entityNumber = permRule.get("entityType").toString();
            boolean objenabled = (Boolean)permRule.get("objenabled");
            if (StringUtils.equals((String)entityNumber, (String)"ricc_datapacket")) {
                this.getModel().setValue(ISOLATE_PACKAGE, (Object)objenabled);
                continue;
            }
            if (!StringUtils.equals((String)entityNumber, (String)"ricc_transfertask")) continue;
            this.getModel().setValue(ISOLATE_TRANSFERTASK, (Object)objenabled);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideOrShowPermFlex();
        this.setControlEntryRowBgColor();
        this.setPwdFormat();
    }

    private void setPwdFormat() {
        String sysPwd;
        String packetSecret = (String)this.getModel().getValue(PACKET_SECRET);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (StringUtils.isNotEmpty((String)packetSecret)) {
            proxy.setFieldProperty(PACKET_SECRET, "v", (Object)"******");
        }
        if (StringUtils.isNotEmpty((String)(sysPwd = (String)this.getModel().getValue(SYSTOKEN)))) {
            proxy.setFieldProperty(SYSTOKEN, "v", (Object)"******");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.loadSysParam();
        this.getPageCache().put(BASIC_SET_CHANGE, ObjectConverter.toString((Object)this.getControlItemVal(ConfigControlItems.CHANGE_PERM_TYPE)));
        this.setDataPacketAndTransferTaskValue();
        this.getModel().setDataChanged(false);
        this.importTemplateFieldDeal();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("save".equals(operationKey)) {
            if ((Long)this.getModel().getValue("id") == 0L) {
                this.getModel().setValue("id", (Object)1367275628033736704L);
            }
            String basicsetchange = ObjectConverter.toString((Object)this.getControlItemVal(ConfigControlItems.CHANGE_PERM_TYPE));
            if (BaseDataRightEnum.NO_NEWANDCHANGE_PERM.getVal().equals(basicsetchange)) {
                this.saveConfirm();
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((String)CLEARDATA, (String)operationKey)) {
            if (!PermissionServiceHelper.isAdminUser((long)UserServiceHelper.getCurrentUserId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u7ba1\u7406\u5458\u529f\u80fd\u3002", (String)"InitConfigFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.restoreFactorySettingConfirm();
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            String oldPacketSecret = SysParaUtil.getPacketSecret();
            String newPacketSecret = (String)this.getModel().getValue(PACKET_SECRET);
            String string = newPacketSecret = StringUtils.isEmpty((String)newPacketSecret) ? "" : newPacketSecret;
            if (!Objects.equals(oldPacketSecret, newPacketSecret)) {
                this.getPageCache().put("packetSecretChange", "1");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean success;
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operationKey)) {
            String packetSecretChange;
            boolean success2 = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if (success2 && "1".equals(packetSecretChange = this.getPageCache().get("packetSecretChange"))) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("saveComplete", (IFormPlugin)this);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u52a0\u5bc6\u5bc6\u94a5\u5df2\u4fee\u6539\uff0c\u4e3a\u4fdd\u8bc1\u4f20\u8f93\u5305\u4e0a\u4f20\u548c\u5728\u7ebf\u4f20\u8f93\u529f\u80fd\u4e0d\u53d7\u5f71\u54cd\uff0c\u8bf7\u786e\u4fdd\u76ee\u6807\u73af\u5883\u4f20\u8f93\u5305\u52a0\u5bc6\u5bc6\u94a5\u548c\u5f53\u524d\u73af\u5883\u4e00\u81f4", (String)"InitConfigFormPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageTypes.Commit, confirmCallBackListener);
                this.getPageCache().remove("packetSecretChange");
            }
        } else if (CLEARDATA.equals(operationKey) && (success = afterDoOperationEventArgs.getOperationResult().isSuccess())) {
            this.getView().invokeOperation("new");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((String)BUTTONAP, (String)source.getKey())) {
            HashMap<String, String> controlled = new HashMap<String, String>(1);
            controlled.put(CONTROLLED, "1");
            ListShowParameter showConfigItems = ShowParameterUtil.listShowParameter((String)"ricc_configitems", (String)"ricc_templatetreelist", (ShowType)ShowType.MainNewTabPage, controlled, null, null, null);
            showConfigItems.setPageId("ricc_configitems" + this.getView().getFormShowParameter().getRootPageId());
            showConfigItems.setParentPageId(ShowParameterUtil.getParentPageId((IFormView)this.getView()));
            this.getView().showForm((FormShowParameter)showConfigItems);
        }
    }

    private void importTemplateFieldDeal() {
        boolean canAddPacket = ObjectConverter.toBoolean((Object)this.getControlItemVal(ConfigControlItems.CAN_ADD_PACKET));
        this.getView().setEnable(Boolean.valueOf(!canAddPacket), new String[]{IMPORT_TEMPLATE_HASID});
        if (canAddPacket) {
            this.getView().getModel().setValue(IMPORT_TEMPLATE_HASID, (Object)Boolean.TRUE);
        }
    }

    private void saveConfirm() {
        String msg = ResManager.loadKDString((String)"\u60a8\u8bbe\u7f6e\u7684\u914d\u7f6e\u7ba1\u63a7\u6a21\u5f0f\u4e0b\u5f53\u524d\u73af\u5883\u7c7b\u578b\u53ea\u6709\u6743\u9650\u7ba1\u63a7\u4f8b\u5916\u7528\u6237\u53ef\u4ee5\u4fee\u6539\u6216\u65b0\u589e\u53d7\u63a7\u914d\u7f6e\u6e05\u5355\u4e2d\u6570\u636e\uff0c\u5176\u4ed6\u7528\u6237\u5c06\u4f1a\u7981\u7528\u76f8\u5173\u914d\u7f6e\u65b0\u589e\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u77e5\u6653\u5e76\u786e\u8ba4\u64cd\u4f5c\uff01\uff01\uff01", (String)"InitConfigFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmTypes confirmTypes = ConfirmTypes.Delete;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(SAVE_CONFIRM_ACID, (IFormPlugin)this);
        this.getView().showConfirm(msg, options, confirmTypes, callBack);
    }

    private void addUserListener() {
        Toolbar mainToolbar = (Toolbar)this.getControl("usertoolbar");
        mainToolbar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (InitConfigFormPlugin.ADD_USER.equals(itemKey)) {
                    InitConfigFormPlugin.this.getModel().setValue(InitConfigFormPlugin.USERF7, null);
                    MulBasedataEdit userF7 = (MulBasedataEdit)InitConfigFormPlugin.this.getView().getControl(InitConfigFormPlugin.USERF7);
                    QFilter userF7Filter = PermissionUtil.getUserQFilter();
                    userF7.setQFilter(userF7Filter);
                    userF7.click();
                }
            }
        });
        MulBasedataEdit userF7 = (MulBasedataEdit)this.getView().getControl(USERF7);
        userF7.addBeforeF7SelectListener(evt -> {
            ArrayList<Long> userList = new ArrayList<Long>(10);
            userList.add(UserServiceHelper.getCurrentUserId());
            int rowCount = this.getModel().getEntryRowCount(USER_ENTRY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(USER_ENTRY);
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject user = ((DynamicObject)entryEntity.get(i)).getDynamicObject("user");
                Long userId = user.getLong("id");
                userList.add(userId);
            }
            evt.getCustomQFilters().add(new QFilter("id", "not in", userList));
        });
    }

    private void fillUserList(Set<Long> userSet) {
        if (!CollectionUtils.isEmpty(userSet)) {
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(new String[]{"user", "seq"});
            Iterator<Long> userIds = userSet.iterator();
            int seq = this.getModel().getEntryEntity(USER_ENTRY).size();
            while (userIds.hasNext()) {
                Long userId = userIds.next();
                vs.addRow(new Object[]{userId, ++seq});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(USER_ENTRY, vs);
            this.getModel().endInit();
            this.getView().updateView(USER_ENTRY);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int newPackSizeLimit;
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue instanceof DynamicObjectCollection && USERF7.equals(fieldKey)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)newValue;
            if (!doc.isEmpty()) {
                HashSet<Long> userSet = new HashSet<Long>(10);
                for (int i = 0; i < doc.size(); ++i) {
                    DynamicObject user = (DynamicObject)doc.get(i);
                    long userId = user.getLong("fbasedataid_id");
                    userSet.add(userId);
                }
                this.fillUserList(userSet);
                this.getModel().setDataChanged(true);
            }
        } else if (StringUtils.equals((String)ENV_ROLE, (String)fieldKey)) {
            this.hideOrShowPermFlex();
            this.importTemplateFieldDeal();
            this.setControlEntryRowBgColor();
        } else if (StringUtils.equals((String)CONFIG_TYPE, (String)fieldKey)) {
            this.controlModeChange((String)newValue);
            this.hideOrShowPermFlex();
            this.importTemplateFieldDeal();
        } else if (StringUtils.equals((String)PACK_DATA_LIMIT, (String)fieldKey)) {
            int newPackDataLimit = (Integer)newValue;
            if (newPackDataLimit > 100000) {
                String msgTpl = ResManager.loadKDString((String)"\u6253\u5305\u6570\u91cf\u9650\u5236%d\u5927\u4e8e\u9ed8\u8ba4\u503c10\u4e07\uff0c\u8bf7\u786e\u8ba4\u73af\u5883\u914d\u7f6e\u540e\u8c28\u614e\u8c03\u6574\u8be5\u53c2\u6570\uff0c\u907f\u514d\u7cfb\u7edf\u5f02\u5e38\u3002", (String)"InitConfigFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msgTpl, newPackDataLimit), Integer.valueOf(7000));
            }
        } else if (StringUtils.equals((String)PACK_SIZE_LIMIT, (String)fieldKey) && (newPackSizeLimit = ((Integer)newValue).intValue()) > 200) {
            String msgTpl = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u5b50\u5305\u603b\u548c\u5927\u5c0f\u9650\u5236%dMB\u5927\u4e8e\u9ed8\u8ba4100MB\uff0c\u8bf7\u786e\u8ba4\u73af\u5883\u914d\u7f6e\u540e\u8c28\u614e\u8c03\u6574\u8be5\u53c2\u6570\uff0c\u907f\u514d\u7cfb\u7edf\u5f02\u5e38\u3002", (String)"InitConfigFormPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msgTpl, newPackSizeLimit), Integer.valueOf(7000));
        }
    }

    private void restoreFactorySettingConfirm() {
        String msg = ResManager.loadKDString((String)"\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u540e\u4f1a\u6e05\u9664\u4ee5\u4e0b\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64cd\u4f5c\uff1f", (String)"InitConfigFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"1.\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\uff1b", (String)"InitConfigFormPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u8fde\u63a5\u6570\u636e\u4e2d\u5fc3\u7ba1\u7406\u4fe1\u606f\uff1b", (String)"InitConfigFormPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u96c6\u6210\u540c\u6b65\u65b9\u6848\u8bbe\u7f6e\u4fe1\u606f\uff1b", (String)"InitConfigFormPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"4.\u4f20\u8f93\u5305\u7ba1\u7406\u6570\u636e\uff1b", (String)"InitConfigFormPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"5.\u65e5\u5fd7\u7ba1\u7406\u6570\u636e\uff1b", (String)"InitConfigFormPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"6.\u975e\u9884\u7f6e\u7684\u6279\u91cf\u6253\u5305\u65b9\u6848\uff1b", (String)"InitConfigFormPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"7.\u6570\u636e\u5bf9\u6bd4\u62a5\u544a\uff1b", (String)"InitConfigFormPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"8.\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\uff1b", (String)"InitConfigFormPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmTypes confirmTypes = ConfirmTypes.Delete;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CALLBACKID, (IFormPlugin)this);
        this.getView().showConfirm(msg, detail, options, confirmTypes, callBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult messageboxResult = evt.getResult();
        String callBackId = evt.getCallBackId();
        if (CALLBACKID.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageboxResult)) {
            this.getView().invokeOperation(CLEARDATA);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5b8c\u6210\u3002", (String)"InitConfigFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if (SAVE_CONFIRM_ACID.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageboxResult)) {
            this.getView().invokeOperation("save");
        }
    }

    private Object getControlItemVal(ConfigControlItems controlConfigItems) {
        String envRole = (String)this.getModel().getValue(ENV_ROLE);
        DynamicObjectCollection envEntryDatas = this.getModel().getEntryEntity(ENV_ENTRY);
        for (DynamicObject envEntryData : envEntryDatas) {
            String envTypeInfo = envEntryData.getString(ENVTYPEINFO);
            if (!envTypeInfo.equals(envRole)) continue;
            return envEntryData.get(controlConfigItems.getValue());
        }
        return null;
    }

    private void hideOrShowPermFlex() {
        if (StringUtils.equals((String)BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal(), (String)ObjectConverter.toString((Object)this.getControlItemVal(ConfigControlItems.CHANGE_PERM_TYPE)))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PERM_FLEXPANELAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PERM_FLEXPANELAP});
        }
    }

    private void controlModeChange(String controlMode) {
        JSONArray controlArr = SysParaUtil.getControlEntryPreData((String)controlMode);
        if (controlArr == null || controlArr.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u9884\u7f6e\u7ba1\u63a7\u6a21\u5f0f\u5206\u5f55\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitConfigFormPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        int controlRowSize = controlArr.size();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENV_ENTRY);
        if (entryEntity.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENV_ENTRY, controlRowSize);
        }
        for (int i = 0; i < controlRowSize; ++i) {
            JSONObject controlItem = controlArr.getJSONObject(i);
            Integer seq = controlItem.getInteger("seq");
            String envTypeInfo = controlItem.getString(ENVTYPEINFO);
            Set controlItemEntries = controlItem.entrySet();
            for (Map.Entry controlItemEntrie : controlItemEntries) {
                if ("seq".equals(controlItemEntrie.getKey())) continue;
                this.getModel().setValue((String)controlItemEntrie.getKey(), controlItemEntrie.getValue(), seq - 1);
            }
            this.getModel().setValue("envtyperemark", (Object)EnvRoleEnum.getEnumExplain((String)envTypeInfo), seq - 1);
        }
    }

    private void setControlEntryRowBgColor() {
        DynamicObjectCollection envEntryData = this.getModel().getEntryEntity(ENV_ENTRY);
        if (envEntryData.isEmpty()) {
            return;
        }
        String envRole = (String)this.getModel().getValue(ENV_ROLE);
        int envRoleSeq = -1;
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] noBgRows = new int[envEntryData.size() - 1];
        int i = 0;
        for (DynamicObject envEntryInfo : envEntryData) {
            String envTypeInfo = envEntryInfo.getString(ENVTYPEINFO);
            int index = envEntryInfo.getInt("seq") - 1;
            if (envTypeInfo.equals(envRole)) {
                envRoleSeq = index;
                continue;
            }
            noBgRows[i] = index;
            ++i;
        }
        ClientActions.createRowStyleBuilder().setRows(noBgRows).setBackColor("#fff").buildStyle().build().invokeControlMethod(proxy, ENV_ENTRY);
        ClientActions.createRowStyleBuilder().setRows(new int[]{envRoleSeq}).setBackColor("#E0EFFF").buildStyle().build().invokeControlMethod(proxy, ENV_ENTRY);
    }
}

