/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.packet;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.upload.DataPackageUploadUtil;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class PacketManageEditPlugin
extends AbstractBasePlugIn {
    private static final String BT_NEW = "bar_new";
    private static final String BT_COPY = "bar_copy";
    private static final String BT_DELETE = "bar_delete";
    private static final String BT_SUBMIT = "bar_submit";
    private static final String BT_SYNC = "tblsync";
    private static final String BT_VIEWLOGS = "barlviewlogs";
    private static final String OP_VIEWLOGS = "viewlogs";
    private static final String OP_INVALID = "invalid";
    private static final String IS_COPY = "iscopy";
    private static final String PACKET_VERSION = "packetversion";
    private static final String ADDNEW = "ADDNEW";
    public static final String INVALID_CONFIRM = "invalidConfirm";

    public void afterBindData(EventObject e) {
        boolean isCopy;
        this.disableBtAndHideTipsByRole();
        if (this.getView().getFormShowParameter().getCustomParam(IS_COPY) != null && (isCopy = ((Boolean)this.getView().getFormShowParameter().getCustomParam(IS_COPY)).booleanValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"packettype"});
        }
        if (this.openFrom("openFromGuide")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BT_SUBMIT});
            this.getView().setEnable(Boolean.FALSE, new String[]{"packettype"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BT_NEW});
        if (this.getView().getFormShowParameter().getStatus().toString().equals(ADDNEW)) {
            long packetVersionId = DataPacketHelper.getLatestPacketVersion();
            this.getModel().setValue(PACKET_VERSION, (Object)packetVersionId);
        }
        if (this.openFrom("openFromMetadata")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BT_SUBMIT, BT_COPY, BT_DELETE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BT_NEW});
            this.getView().setEnable(Boolean.FALSE, new String[]{"packettype"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.openFrom("openFromMetadata")) {
            this.getView().getModel().setValue("packettype", (Object)DataPacketTypeEnum.METADATA.getVal());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BaseModel baseModel = (BaseModel)e.getSource();
        DynamicObject dataEntity = baseModel.getDataEntity();
        DynamicObjectCollection subDataPacket = dataEntity.getDynamicObjectCollection("subdatapacket");
        if (subDataPacket.size() > 0) {
            this.processCopySubDataPacket(subDataPacket);
        }
        this.getModel().setValue("subpacketcount", (Object)subDataPacket.size());
    }

    private void disableBtAndHideTipsByRole() {
        ArrayList<String> cleanTipsKeyList = new ArrayList<String>();
        boolean canCreatePacket = SysParaUtil.canCreatePacket();
        this.getView().setEnable(Boolean.valueOf(canCreatePacket), new String[]{BT_NEW});
        this.getView().setEnable(Boolean.valueOf(canCreatePacket), new String[]{BT_COPY});
        if (canCreatePacket) {
            cleanTipsKeyList.add(BT_NEW);
            cleanTipsKeyList.add(BT_COPY);
        }
        boolean canUploadPacket = SysParaUtil.canUploadPacket();
        this.getView().setEnable(Boolean.valueOf(canUploadPacket), new String[]{BT_SYNC});
        cleanTipsKeyList.add(BT_VIEWLOGS);
        if (canUploadPacket) {
            cleanTipsKeyList.add(BT_SYNC);
        }
        if (!cleanTipsKeyList.isEmpty()) {
            FormViewUtil.cleanButtonTips(cleanTipsKeyList, (IFormView)this.getView());
        }
    }

    private boolean openFrom(String key) {
        String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("dataPacketOpenFrom");
        return !StringUtils.isEmpty((String)openFrom) && key.equals(openFrom);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            String dataSource = (String)this.getModel().getValue("datasource");
            boolean isManualNew = StringUtils.equals((String)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal(), (String)dataSource);
            if (StringUtils.equals((String)OP_VIEWLOGS, (String)opKey)) {
                Object packetId = this.getModel().getValue("id");
                QFilter filter = new QFilter("packet.id", "=", packetId);
                ShowParameterUtil.showLogs((IFormView)this.getView(), (QFilter)filter, (ShowType)ShowType.MainNewTabPage);
            } else if (StringUtils.equals((String)"copy", (String)opKey)) {
                if (!isManualNew) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u624d\u5141\u8bb8\u590d\u5236", (String)"PacketManageEditPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put(IS_COPY, "true");
            } else if (StringUtils.equals((String)"save", (String)opKey)) {
                this.processCopyDatapacket(args);
            } else if (StringUtils.equals((String)OP_INVALID, (String)opKey)) {
                Object pk = this.getModel().getDataEntity().getPkValue();
                if (pk instanceof Long && (Long)pk == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u64cd\u4f5c", (String)"PacketManageEditPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                String status = (String)this.getModel().getValue("status");
                boolean isZc = StringUtils.equals((String)"A", (String)status);
                if (!isZc || !isManualNew) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u624b\u5de5\u65b0\u589e\u4e14\u6682\u5b58\u7684\u4f20\u8f93\u5305\u53ef\u4ee5\u4f5c\u5e9f", (String)"PacketManageEditPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("subdatapacket");
                int[] rowIndexs = entryGrid.getSelectRows();
                int selectedCount = rowIndexs.length;
                if (selectedCount <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u4f5c\u5e9f\u7684\u6570\u636e", (String)"PacketManageEditPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                String msgConfirm = ResManager.loadKDString((String)"\u5b50\u4f20\u8f93\u5305\u5c06\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4", (String)"PacketManageEditPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showConfirm(msgConfirm, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(INVALID_CONFIRM, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (INVALID_CONFIRM.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            Object pk = this.getModel().getDataEntity().getPkValue();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("subdatapacket");
            int[] rowIndexs = entryGrid.getSelectRows();
            this.invalidSubPacket(pk, rowIndexs);
        }
    }

    private void invalidSubPacket(Object pk, int[] rowIndexs) {
        DynamicObject packet = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ricc_datapacket");
        DynamicObjectCollection entrys = packet.getDynamicObjectCollection("subdatapacket");
        Date date = new Date();
        date.setTime(System.currentTimeMillis());
        for (int i = 0; i < rowIndexs.length; ++i) {
            String entryStatus = ((DynamicObject)entrys.get(rowIndexs[i])).getString("entrystatus");
            if (PacketEntryStatusEnum.INVALID.getVal().equals(entryStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u5df2\u7ecf\u662f\u4f5c\u5e9f\u72b6\u6001\u4e86", (String)"PacketManageEditPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), rowIndexs[i] + 1));
                return;
            }
            ((DynamicObject)entrys.get(rowIndexs[i])).set("entrystatus", (Object)PacketEntryStatusEnum.INVALID.getVal());
            ((DynamicObject)entrys.get(rowIndexs[i])).set("entryupdatetime", (Object)date);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ricc_datapacket", (DynamicObject[])new DynamicObject[]{packet}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f", (String)"PacketManageEditPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(result.getAllErrorInfo().toString());
        }
        BillModel model = (BillModel)this.getModel();
        model.load(packet.getPkValue());
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((String)"save", (String)operationKey) && (this.openFrom("openFromGuide") || this.openFrom("openFromMetadata"))) {
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            Map parameter = operate.getParameter();
            parameter.put("afterOperation", "close");
            operate.setParameter(parameter);
        }
        if (StringUtils.equals((String)"audit", (String)operationKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void processCopyDatapacket(BeforeDoOperationEventArgs args) {
        long fid = (Long)this.getModel().getValue("id");
        boolean iscopy = false;
        if (this.getView().getFormShowParameter().getCustomParam(IS_COPY) != null) {
            iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam(IS_COPY);
        }
        if (Boolean.parseBoolean(this.getPageCache().get(IS_COPY))) {
            iscopy = Boolean.parseBoolean(this.getPageCache().get(IS_COPY));
        }
        if (iscopy && fid == 0L) {
            long id = DB.genLongId((String)"ricc_datapacket");
            this.getModel().setValue("id", (Object)id);
            this.getModel().setValue("syncstate", (Object)"");
            this.getModel().setValue("dltrcount", (Object)0);
            DynamicObjectCollection subPackets = this.getModel().getEntryEntity("subdatapacket");
            String billNo = (String)this.getModel().getValue("number");
            if (!subPackets.isEmpty()) {
                try {
                    DataPackageUploadUtil.processCopySubPacket(id, billNo, subPackets);
                    this.getModel().setValue("subdatapacket", (Object)subPackets);
                }
                catch (Exception e) {
                    args.setCancel(true);
                    this.getModel().setValue("id", (Object)"0");
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
        }
    }

    private void processCopySubDataPacket(DynamicObjectCollection subDataPacekts) {
        for (int i = 0; i < subDataPacekts.size(); ++i) {
            DynamicObject subDataPacket = (DynamicObject)subDataPacekts.get(i);
            int status = subDataPacket.getInt("entrystatus");
            if (status != 1) continue;
            subDataPacekts.remove(i);
            --i;
        }
    }
}

