/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.packet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.Hex;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class PacketSynPreViewPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(PacketSynPreViewPlugin.class);
    private static final String CUR_PAGE_CACHE = "curPageCache";
    private static final String TOTAL_PAGE_CACHE = "totalPageCache";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final int DEFAULT_BATCH_COUNT = 1000;
    private static final String CUR_LIST_BOX_KEY_CACHE = "curListBoxKeyCache";
    private static final String PRE = "pre";
    private static final String HOME = "home";
    private static final String NEXT = "next";
    private static final String END = "end";
    private static final String SPLIT = "\\$\\$\\$";
    private static final String PREVIEW_TYPE = "previewType";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String previewType = (String)e.getFormShowParameter().getCustomParam(PREVIEW_TYPE);
        List<Object> selectPackIds = new ArrayList<Object>(10);
        if (StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
            Object guideId = e.getFormShowParameter().getCustomParam("guideId");
            selectPackIds.add(guideId);
        } else {
            String selectIdStr = (String)e.getFormShowParameter().getCustomParam("selectIds");
            selectPackIds = (List)JSON.parseObject((String)selectIdStr, (TypeReference)new TypeReference<List<Object>>(){}, (Feature[])new Feature[0]);
        }
        StringBuilder noPreViewStr = new StringBuilder();
        boolean isPreview = this.checkSupportPreView(selectPackIds, noPreViewStr, previewType);
        e.getFormShowParameter().setCustomParam("noPreViewStr", (Object)noPreViewStr.toString());
        if (!isPreview) {
            e.setCancelMessage(noPreViewStr.toString());
            e.setCancel(true);
        }
    }

    private boolean checkSupportPreView(List<Object> selectPackIds, StringBuilder noPreStr, String previewType) {
        if (StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])new QFilter[]{new QFilter("id", "in", selectPackIds)});
            if (queryData.isEmpty()) {
                return false;
            }
            boolean supportPreView = ((DynamicObject)queryData.get(0)).getBoolean("supportpreview");
            if (!supportPreView) {
                noPreStr.append(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u9884\u89c8\u3002", (String)"PacketSynPreViewPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), ((DynamicObject)queryData.get(0)).getString("name")));
            }
            return supportPreView;
        }
        DynamicObject[] packets = DataPacketHelper.getSelectedPackets(selectPackIds.toArray(new Object[0]));
        List<Object> itemIdList = DataPacketHelper.getItemIdsByPacket(packets, false);
        if (itemIdList.isEmpty()) {
            noPreStr.append(ResManager.loadKDString((String)"\u6240\u9009\u4f20\u8f93\u5305\u5185\u627e\u4e0d\u5230\u6709\u6548\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PacketSynPreViewPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])new QFilter[]{new QFilter("id", "in", itemIdList)});
        List supportPreView = queryData.stream().filter(y -> y.getBoolean("supportpreview")).collect(Collectors.toList());
        if (supportPreView.isEmpty()) {
            noPreStr.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f20\u8f93\u5305\u5185\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u9884\u89c8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PacketSynPreViewPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        queryData.stream().filter(y -> !y.getBoolean("supportpreview")).forEach(obj -> noPreStr.append(obj.getString("name")).append(','));
        if (noPreStr.length() > 0) {
            noPreStr.deleteCharAt(noPreStr.lastIndexOf(","));
        }
        return true;
    }

    public void registerListener(EventObject e) {
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
        this.addClickListeners(new String[]{"btncancel"});
        Button home = (Button)this.getControl(HOME);
        home.addClickListener((ClickListener)this);
        Button pre = (Button)this.getControl(PRE);
        pre.addClickListener((ClickListener)this);
        Button next = (Button)this.getControl(NEXT);
        next.addClickListener((ClickListener)this);
        Button end = (Button)this.getControl(END);
        end.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("filtervalue");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String noPreViewStr = (String)customParams.get("noPreViewStr");
        if (StringUtils.isNotBlank((CharSequence)noPreViewStr)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u9884\u89c8\u3002", (String)"PacketSynPreViewPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), noPreViewStr));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{HOME, PRE, NEXT, END});
        LinkedHashMap<String, DynamicObject> allItemsMapping = new LinkedHashMap<String, DynamicObject>(2);
        String previewType = (String)customParams.get(PREVIEW_TYPE);
        if (StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
            DynamicObject configItem = this.getConfigItemsByCache();
            if (configItem == null) {
                return;
            }
            this.setCurPageValue(configItem.getString("number"), 1, 1, configItem, true);
            allItemsMapping.put(configItem.getString("number"), configItem);
        } else {
            String packNumber = "";
            int rowIndex = 0;
            DynamicObject[] packets = this.prePareData(allItemsMapping);
            DynamicObject subDataPackRow = null;
            block0: for (DynamicObject packet : packets) {
                DynamicObjectCollection subDataPack = packet.getDynamicObjectCollection("subdatapacket");
                packNumber = packet.getString("number");
                int row = 0;
                for (DynamicObject rowData : subDataPack) {
                    DynamicObject configItem = (DynamicObject)allItemsMapping.get(packNumber + "$$$" + row);
                    if (Objects.nonNull(configItem)) {
                        subDataPackRow = rowData;
                        rowIndex = row;
                        break block0;
                    }
                    ++row;
                }
            }
            this.setCurPageValue(packNumber, rowIndex, 1, subDataPackRow, false);
        }
        this.setListBoxValue(allItemsMapping);
        this.getPageCache().put(CUR_PAGE_CACHE, "1");
        this.setTabAndColumnName();
    }

    private DynamicObject getConfigItemsByCache() {
        Object guideId = this.getView().getFormShowParameter().getCustomParam("guideId");
        return this.getConfigItemById(guideId);
    }

    private DynamicObject[] prePareData(Map<String, DynamicObject> allItemsMapping) {
        String selectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("selectIds");
        List selectPackIds = (List)JSON.parseObject((String)selectIdStr, (TypeReference)new TypeReference<List<Object>>(){}, (Feature[])new Feature[0]);
        DynamicObject[] packets = DataPacketHelper.getSelectedPackets(selectPackIds.toArray(new Object[0]));
        List<Object> itemIdList = DataPacketHelper.getItemIdsByPacket(packets, false);
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])new QFilter[]{new QFilter("id", "in", itemIdList)});
        Map allItemsMap = queryData.stream().filter(y -> y.getBoolean("supportpreview")).collect(Collectors.toMap(y -> y.get("id"), Function.identity(), (existing, replacement) -> existing, HashMap::new));
        for (DynamicObject packet : packets) {
            String packNumber = packet.getString("number");
            DynamicObjectCollection subDataPack = packet.getDynamicObjectCollection("subdatapacket");
            int rowIndex = 0;
            for (DynamicObject subDataPackRow : subDataPack) {
                DynamicObject item = subDataPackRow.getDynamicObject("bizobject");
                if (allItemsMap.get(item.getPkValue()) != null) {
                    allItemsMapping.put(packNumber + "$$$" + rowIndex, (DynamicObject)allItemsMap.get(item.getPkValue()));
                }
                ++rowIndex;
            }
        }
        return packets;
    }

    private void setListBoxValue(Map<String, DynamicObject> allItemsMapping) {
        log.info("\u9884\u89c8listbox \u7684 key \u4e3a {}", allItemsMapping.keySet());
        Listbox listBox = (Listbox)this.getView().getControl("listboxap");
        ArrayList<ListboxItem> listBoxList = new ArrayList<ListboxItem>(10);
        for (Map.Entry<String, DynamicObject> itemEntry : allItemsMapping.entrySet()) {
            String key = itemEntry.getKey();
            DynamicObject item = itemEntry.getValue();
            ListboxItem listBoxItem = new ListboxItem(key, item.getString("name"));
            listBoxList.add(listBoxItem);
        }
        listBox.addItems(listBoxList);
    }

    private boolean setCurPageValue(String packNumber, int rowIndex, int curPageIndex, DynamicObject subDataPackRow, boolean isItem) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        String exportPlugin = this.beforeProvide(curPageIndex, param, packNumber, rowIndex, subDataPackRow, isItem);
        log.info("\u4f20\u8f93\u5305 {} \u7b2c {} \u884c\u9884\u89c8\u5fae\u670d\u52a1\u8c03\u7528\u53c2\u6570\u4e3a {}", new Object[]{packNumber, ++rowIndex, param});
        if (StringUtils.isBlank((CharSequence)exportPlugin)) {
            return true;
        }
        Map<String, Object> result = this.executeProvide(param, exportPlugin);
        log.info("\u4f20\u8f93\u5305 {} \u7b2c {} \u884c\u9884\u89c8\u5fae\u670d\u52a1\u8c03\u7528\u7ed3\u679c\u4e3a {}", new Object[]{packNumber, ++rowIndex, result});
        if (result == null || result.isEmpty()) {
            return false;
        }
        this.afterProvide(result);
        this.setCurPageIndexLab(curPageIndex);
        return true;
    }

    private String getCurListBoxKey() {
        return this.getPageCache().get(CUR_LIST_BOX_KEY_CACHE);
    }

    private String beforeProvide(int pageIndex, Map<String, Object> param, String packNumber, int row, DynamicObject bizObject, boolean isItem) {
        String exportPlugin;
        String curListBoxKey = packNumber + "$$$" + row;
        this.getView().getPageCache().put(CUR_LIST_BOX_KEY_CACHE, curListBoxKey);
        DynamicObject curConfigItem = isItem ? bizObject : bizObject.getDynamicObject("bizobject");
        Object pkValue = curConfigItem.get("id");
        DynamicObject configItem = this.getConfigItemById(pkValue);
        String importType = configItem.getString("importtype");
        String filterField = (String)this.getModel().getValue("filterfield");
        String filterValue = this.getView().getPageCache().get("filtervalue");
        param.put("filterfield", filterField);
        String filterValueEx = StringUtils.equals((String)filterField, (String)"exist") && StringUtils.equals((String)filterValue, (String)ResManager.loadKDString((String)"\u65b0\u589e", (String)"PacketSynPreViewPlugin_22", (String)"sys-ricc-platform", (Object[])new Object[0])) ? "1" : (StringUtils.equals((String)filterField, (String)"exist") && StringUtils.equals((String)filterValue, (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PacketSynPreViewPlugin_23", (String)"sys-ricc-platform", (Object[])new Object[0])) ? "0" : filterValue);
        param.put("filtervalue", filterValueEx);
        try {
            Map<String, Object> params;
            exportPlugin = SubDataPacketDispatch.getPluginByImportType(DataPacketTypeEnum.CONFIG.getVal(), configItem);
            if (isItem) {
                String selectRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedData");
                ListSelectedRowCollection selectRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
                params = this.getPreViewParams(configItem, selectRows, exportPlugin, pageIndex);
            } else {
                params = DataPacketHelper.getPreViewParams(bizObject, importType, 1000, pageIndex);
                params.put("serviceconfig", configItem.getString("plugin"));
            }
            param.put("entityNumber", configItem.getString("entityid"));
            param.putAll(params);
        }
        catch (RiccBizException ex) {
            log.error("\u914d\u7f6e\u9879\u7f16\u7801\u4e3a {} \u83b7\u53d6\u9884\u89c8\u53c2\u6570\u65f6\u51fa\u9519", configItem.get("number"), (Object)ex);
            if (isItem) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\uff0c\u914d\u7f6e\u9879\u3010%1$s\u3011\u6570\u636e\u83b7\u53d6\u9884\u89c8\u53c2\u6570\u65f6\u51fa\u9519\uff0c%2$s,\u8bf7\u68c0\u67e5\u3002", (String)"PacketSynPreViewPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), packNumber, ex.getMessage()));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\uff0c\u4f20\u8f93\u5305\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u884c\u7684\u6570\u636e\u83b7\u53d6\u9884\u89c8\u53c2\u6570\u65f6\u51fa\u9519\uff0c%3$s,\u8bf7\u68c0\u67e5\u3002", (String)"PacketSynPreViewPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), packNumber, row + 1, ex.getMessage()));
            }
            return null;
        }
        return exportPlugin;
    }

    private DynamicObject getConfigItemById(Object pkValue) {
        return QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
    }

    private Map<String, Object> getPreViewParams(DynamicObject configItem, ListSelectedRowCollection selectRows, String exportPlugin, int pageIndex) {
        String entityName = configItem.getString("name");
        String entityNumber = configItem.getString("entityid");
        String importType = configItem.getString("importtype");
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("pageSize", 1000);
        param.put("pageIndex", pageIndex);
        switch (importType) {
            case "excel": 
            case "json": {
                HashMap<String, Collection<Object>> customParam = new HashMap<String, Collection<Object>>(2);
                String keyFieldItem = configItem.getString("keyfields");
                String keyFields = ConfigItemHelper.disPoseKeyField(entityNumber, keyFieldItem, entityName);
                HashSet<String> keyFieldSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
                List<Map<String, Object>> previewData = DataPacketHelper.getCustomParam(entityNumber, selectRows.getPrimaryKeyValues(), null, keyFieldSet);
                customParam.put("previewData", previewData);
                customParam.put("keyFields", keyFieldSet);
                param.put("custparam", StringUtils.compressString((String)JSON.toJSONString(customParam)));
                break;
            }
            case "custom": 
            case "microService": {
                ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
                String localPath = FileUtils.generateLocalPath();
                FileUtils.checkAndCreateDir((String)localPath);
                SdpInputParams sdpInputParams = new SdpInputParams();
                sdpInputParams.setLocalPath(localPath);
                sdpInputParams.setSelectRows(selectRows);
                HashMap<String, Object> serviceParam = new HashMap<String, Object>(16);
                serviceParam.put("entitynumber", entityNumber);
                serviceParam.put("guideId", configItem);
                serviceParam.put("entityname", entityName);
                serviceParam.put("pageenterparam", configItem.getString("pageenterparam"));
                serviceParam.put("serviceconfig", configItem.getString("plugin"));
                Map custParam = (Map)this.getView().getFormShowParameter().getCustomParam("custParam");
                serviceParam.put("custparam", custParam);
                sdpInputParams.setParam(serviceParam);
                SdpOutputParams sdpOutputParams = service.exportPacket(sdpInputParams);
                String exportFilePath = sdpOutputParams.getExportFilePath();
                String dataStream = null;
                try (InputStream inputStream = Files.newInputStream(Paths.get(exportFilePath, new String[0]), new OpenOption[0]);){
                    byte[] dataPacketBytes = FileUtils.inputStreamToByte((InputStream)inputStream);
                    dataStream = Hex.encode((byte[])dataPacketBytes);
                }
                catch (Exception ex) {
                    throw new RiccBizException(ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\uff0c\u6587\u4ef6\u8f6c\u5b57\u7b26\u6d41\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PacketSynPreViewPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                param.put("filePathStream ", dataStream);
                break;
            }
        }
        return param;
    }

    private Map<String, Object> executeProvide(Map<String, Object> param, String exportPlugin) {
        Map<String, Object> result = null;
        String tips = "";
        try {
            boolean success;
            result = this.execute(param, exportPlugin);
            if (result != null && !(success = ((Boolean)result.get("success")).booleanValue())) {
                tips = (String)result.get("errMessage");
            }
        }
        catch (Exception ex) {
            log.error("provideData \u5bfc\u51fa\u4f20\u8f93\u5305\u53d1\u751f\u5f02\u5e38{} ,\u63d2\u4ef6\u4e3a {}", (Object)ex, (Object)exportPlugin);
            tips = String.format(ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\uff0c%s", (String)"PacketSynPreViewPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), ex.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)tips)) {
            this.getView().showTipNotification(tips);
            return Collections.emptyMap();
        }
        return result;
    }

    private Map<String, Object> execute(Map<String, Object> param, String exportPlugin) {
        String previewType = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEW_TYPE);
        Map<Object, Object> result = new HashMap(2);
        if (StringUtils.equals((String)previewType, (String)PreviewType.PACK_TO_CUR.value)) {
            ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)exportPlugin);
            result = service.provideData(param);
        } else if (StringUtils.equals((String)previewType, (String)PreviewType.PACK_TO_TAR.value) || StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
            result = this.getApiData(param, exportPlugin);
        }
        return result;
    }

    private Map<String, Object> getApiData(Map<String, Object> param, String exportPlugin) {
        Map result = null;
        String loginParams = (String)this.getView().getFormShowParameter().getCustomParam("loginParams");
        Map loginParamMap = (Map)JSON.parseObject((String)loginParams, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        param.put("preViewPlugin", exportPlugin);
        String preViewStr = ApiUtil.getDestAccountData(param, (Map)loginParamMap, (String)"preview");
        Map apiResult = (Map)JSON.parseObject((String)preViewStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        Boolean success = (Boolean)apiResult.get("status");
        if (!success.equals(Boolean.TRUE)) {
            throw new RiccBizException((String)apiResult.get("message"));
        }
        String apiData = (String)apiResult.get("data");
        result = (Map)JSON.parseObject((String)apiData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        return result;
    }

    private void afterProvide(Map<String, Object> result) {
        Integer dataCount = (Integer)result.get("dataCount");
        Integer modifyCount = (Integer)result.get("modifyCount");
        this.setCountLab(dataCount, dataCount - modifyCount, modifyCount);
        String fieldNameStr = (String)result.get("fieldNames");
        List data = (List)result.get("previewData");
        this.getView().getPageCache().put("fieldNamesCache", fieldNameStr);
        Map fieldNames = (Map)JSON.parseObject((String)fieldNameStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        this.setEntryColumnName(fieldNames);
        Integer pageTotal = (Integer)result.get("pageTotal");
        this.setTotalPageLab(pageTotal);
        this.setEntryValues(data);
    }

    private void setTabAndColumnName() {
        String tarName;
        String curName;
        String preViewType = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEW_TYPE);
        Label dataCenter = (Label)this.getControl("datacenter");
        if (StringUtils.equals((String)preViewType, (String)"packetToCur")) {
            curName = ResManager.loadKDString((String)"\u4f20\u8f93\u5305", (String)"PacketSynPreViewPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
            tarName = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"PacketSynPreViewPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)preViewType, (String)"packetToTar")) {
            curName = ResManager.loadKDString((String)"\u4f20\u8f93\u5305", (String)"PacketSynPreViewPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
            tarName = ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3", (String)"PacketSynPreViewPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else {
            curName = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"PacketSynPreViewPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
            tarName = ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3", (String)"PacketSynPreViewPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        dataCenter.setText(tarName);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.setColumnProperty("curcenter", "header", (Object)new LocaleString(curName));
        grid.setColumnProperty("tarcenter", "header", (Object)new LocaleString(tarName));
    }

    private void setCurPageIndexLab(int pageIndex) {
        this.getView().getPageCache().put(CUR_PAGE_CACHE, String.valueOf(pageIndex));
        Label totalPage = (Label)this.getControl("pageindex");
        totalPage.setText(String.format(ResManager.loadKDString((String)"\u7b2c %s \u9875", (String)"PacketSynPreViewPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]), pageIndex));
    }

    private void setTotalPageLab(int totalPage) {
        this.getView().getPageCache().put(TOTAL_PAGE_CACHE, String.valueOf(totalPage));
        Label totalPageLab = (Label)this.getControl("totalpage");
        totalPageLab.setText(String.format(ResManager.loadKDString((String)"\u5171 %s \u9875", (String)"PacketSynPreViewPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), totalPage));
        this.getView().setEnable(Boolean.valueOf(totalPage > 1), new String[]{NEXT, END});
    }

    private void setCountLab(int total, int newCount, int modifyCount) {
        Label totalLabel = (Label)this.getControl("total");
        Label newCountLabel = (Label)this.getControl("newcount");
        Label modifyCountLabel = (Label)this.getControl("modifcount");
        totalLabel.setText(String.valueOf(total));
        newCountLabel.setText(String.valueOf(newCount));
        modifyCountLabel.setText(String.valueOf(modifyCount));
    }

    private void setEntryColumnName(Map<String, String> fieldNames) {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.setColumnProperty("curid", "header", (Object)new LocaleString(fieldNames.get("first")));
        grid.setColumnProperty("tarid", "header", (Object)new LocaleString(fieldNames.get("first")));
        grid.setColumnProperty("curnumber", "header", (Object)new LocaleString(fieldNames.get("second")));
        grid.setColumnProperty("tarnumber", "header", (Object)new LocaleString(fieldNames.get("second")));
        grid.setColumnProperty("curname", "header", (Object)new LocaleString(fieldNames.get("third")));
        grid.setColumnProperty("tarname", "header", (Object)new LocaleString(fieldNames.get("third")));
        grid.setColumnProperty("curorg", "header", (Object)new LocaleString(fieldNames.get("fourth")));
        grid.setColumnProperty("tarorg", "header", (Object)new LocaleString(fieldNames.get("fourth")));
    }

    private void setEntryValues(List<Map<String, Object>> previewList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (previewList.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, previewList.size());
        boolean existOrg = true;
        for (int i = 0; i < previewList.size(); ++i) {
            Map<String, Object> rowDataStr = previewList.get(i);
            this.getModel().setValue("curid", rowDataStr.get("curfirst"), i);
            this.getModel().setValue("tarid", rowDataStr.get("tarfirst"), i);
            this.getModel().setValue("curnumber", rowDataStr.get("cursecond"), i);
            this.getModel().setValue("tarnumber", rowDataStr.get("tarsecond"), i);
            this.getModel().setValue("curname", rowDataStr.get("curthird"), i);
            this.getModel().setValue("tarname", rowDataStr.get("tarthird"), i);
            String orgValue = (String)rowDataStr.get("curfourth");
            if (StringUtils.isBlank((CharSequence)orgValue)) {
                existOrg = false;
                this.getView().setVisible(Boolean.FALSE, new String[]{"curorg", "tarorg"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"curorg", "tarorg"});
                this.getModel().setValue("curorg", (Object)orgValue);
                this.getModel().setValue("tarorg", rowDataStr.get("tarfourth"), i);
            }
            this.setFilterFieldValue(existOrg);
            this.getModel().setValue("result", rowDataStr.get("exist"), i);
        }
    }

    private void setFilterFieldValue(boolean existOrg) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u6e90\u5185\u7801", (String)"PacketSynPreViewPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]), "curfirst"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u6e90\u7f16\u7801", (String)"PacketSynPreViewPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]), "cursecond"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u6e90\u540d\u79f0", (String)"PacketSynPreViewPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]), "curthird"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u76ee\u6807\u5185\u7801", (String)"PacketSynPreViewPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]), "tarfirst"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u76ee\u6807\u7f16\u7801", (String)"PacketSynPreViewPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]), "tarsecond"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u76ee\u6807\u540d\u79f0", (String)"PacketSynPreViewPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[0]), "tarthird"));
        comboItems.add(this.getComboItem(ResManager.loadKDString((String)"\u5bf9\u6bd4\u7ed3\u679c", (String)"PacketSynPreViewPlugin_18", (String)"sys-ricc-platform", (Object[])new Object[0]), "exist"));
        if (existOrg) {
            comboItems.add(3, this.getComboItem(ResManager.loadKDString((String)"\u6e90\u521b\u5efa\u7ec4\u7ec7", (String)"PacketSynPreViewPlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]), "curfourth"));
            comboItems.add(7, this.getComboItem(ResManager.loadKDString((String)"\u76ee\u6807\u521b\u5efa\u7ec4\u7ec7", (String)"PacketSynPreViewPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]), "tarfourth"));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("filterfield");
        comboEdit.setComboItems(comboItems);
    }

    private ComboItem getComboItem(String caption, String value) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        return comboItem;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((String)key, (String)PRE)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{NEXT, END});
            int prePageIndex = this.pageClick(false);
            if (prePageIndex == 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{PRE, HOME});
            }
        } else if (StringUtils.equals((String)key, (String)NEXT)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{PRE, HOME});
            int nextPageIndex = this.pageClick(true);
            String totalPage = this.getView().getPageCache().get(TOTAL_PAGE_CACHE);
            if (nextPageIndex >= Integer.parseInt(totalPage)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{NEXT, END});
            }
        } else if (StringUtils.equals((String)key, (String)HOME) || StringUtils.equals((String)key, (String)END)) {
            this.setHomeOrEndValue(key);
        }
    }

    private int pageClick(boolean isNext) {
        this.getView().setEnable(Boolean.TRUE, new String[]{PRE, HOME});
        String curPage = this.getView().getPageCache().get(CUR_PAGE_CACHE);
        int curPageIndex = Integer.parseInt(curPage);
        int pageIndex = isNext ? curPageIndex + 1 : curPageIndex - 1;
        return this.setPageValue(pageIndex);
    }

    private Integer setPageValue(int pageIndex) {
        String previewType = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEW_TYPE);
        if (StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
            DynamicObject configItem = this.getConfigItemsByCache();
            if (configItem == null) {
                return 1;
            }
            this.setCurPageValue(configItem.getString("number"), 1, pageIndex, configItem, true);
        } else {
            String curListBoxKey = this.getCurListBoxKey();
            String[] split = curListBoxKey.split(SPLIT);
            String packNumber = split[0];
            int rowIndex = Integer.parseInt(split[1]);
            this.setCurPageValue(packNumber, rowIndex, pageIndex, this.getSubDataPackRow(packNumber, rowIndex), false);
        }
        this.setCurPageIndexLab(pageIndex);
        return pageIndex;
    }

    private void setHomeOrEndValue(String key) {
        if (StringUtils.equals((String)key, (String)END)) {
            String totalPage = this.getView().getPageCache().get(TOTAL_PAGE_CACHE);
            int index = Integer.parseInt(totalPage);
            this.setPageValue(index);
            this.getView().setEnable(Boolean.TRUE, new String[]{PRE, HOME});
            this.getView().setEnable(Boolean.FALSE, new String[]{NEXT, END});
        } else {
            int index = 1;
            this.setPageValue(index);
            this.getView().setEnable(Boolean.TRUE, new String[]{NEXT, END});
            this.getView().setEnable(Boolean.FALSE, new String[]{PRE, HOME});
        }
    }

    public void listboxClick(ListboxEvent event) {
        String itemId = event.getItemId();
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            this.getModel().setValue("filterfield", null);
            this.getView().getPageCache().remove("filtervalue");
            String previewType = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEW_TYPE);
            if (StringUtils.equals((String)previewType, (String)PreviewType.CUR_TO_TAR.value)) {
                return;
            }
            String[] split = itemId.split(SPLIT);
            String packNumber = split[0];
            int rowIndex = Integer.parseInt(split[1]);
            DynamicObject subDataPackRow = this.getSubDataPackRow(packNumber, rowIndex);
            this.getView().getPageCache().put(CUR_PAGE_CACHE, "1");
            this.setCurPageValue(packNumber, rowIndex, 1, subDataPackRow, false);
        }
    }

    private DynamicObject getSubDataPackRow(String packNumber, int rowIndex) {
        List packId = QueryServiceHelper.queryPrimaryKeys((String)"ricc_datapacket", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)packNumber)}, null, (int)-1);
        DynamicObject[] selectedPackets = DataPacketHelper.getSelectedPackets(packId.toArray(new Object[0]));
        DynamicObjectCollection subDataPackets = selectedPackets[0].getDynamicObjectCollection("subdatapacket");
        return (DynamicObject)subDataPackets.get(rowIndex);
    }

    public void search(SearchEnterEvent evt) {
        String value = evt.getText();
        String filterField = (String)this.getModel().getValue("filterfield");
        if (StringUtils.isBlank((CharSequence)filterField)) {
            String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fc7\u6ee4\u5b57\u6bb5\u3002", (String)"PacketSynPreViewPlugin_21", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
        }
        this.getView().getPageCache().put("filtervalue", value);
        String filterFieldCache = this.getView().getPageCache().get("filtervalue");
        boolean filterIsBlank = StringUtils.isBlank((CharSequence)value);
        if (filterIsBlank && filterFieldCache == null) {
            return;
        }
        this.setPageValue(1);
    }

    private static enum PreviewType {
        PACK_TO_CUR("packetToCur"),
        PACK_TO_TAR("packetToTar"),
        CUR_TO_TAR("curToTar");

        private final String value;

        private PreviewType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

