/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.mservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.util.ImplOrderUtil;
import kd.sys.ricc.common.util.StringUtils;

public class ConfigItemServiceImpl {
    private static final Log logger = LogFactory.getLog(ConfigItemServiceImpl.class);
    private static final String PAGE_TYPE = "pagetype";
    private static final String PLUGIN = "plugin";
    private static final String IS_OVERRIDE_ENTRY = "isoverrideentry";
    private static final String IMPORT_TYPE = "importtype";
    private static final String SUPPORT_ADD_TO_PACKET = "supportaddtopacket";
    private static final String CUSTOM_PAGE = "custompage";
    private static final String CAN_EXPORT_ALL = "canexportall";
    private static final String SUCCESS = "success";

    public static JSONObject success() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SUCCESS, (Object)Boolean.TRUE);
        return jsonObject;
    }

    public static JSONObject success(String info) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SUCCESS, (Object)Boolean.TRUE);
        jsonObject.put("msg", (Object)info);
        return jsonObject;
    }

    public static JSONObject fail(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SUCCESS, (Object)Boolean.FALSE);
        jsonObject.put("msg", (Object)msg);
        return jsonObject;
    }

    public Object saveConfigTree(List<Map<String, Object>> paramMapList) {
        StringBuilder errorInfo = new StringBuilder();
        if (paramMapList == null || paramMapList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u5f55\u5165\u914d\u7f6e\u9879\u5de6\u6811\u6240\u9700\u7684\u53c2\u6570", (String)"ConfigItemServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u4fdd\u5b58\u914d\u7f6e\u9879\u5de6\u6811\u6570\u636e{}", paramMapList);
        Object[] ids = paramMapList.stream().filter(p -> p.get("id") != null).map(p -> p.get("id")).toArray();
        Map existMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ricc_configtree"));
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(paramMapList.size());
        ArrayList<DynamicObject> editList = new ArrayList<DynamicObject>(paramMapList.size());
        for (Map<String, Object> paramMap : paramMapList) {
            String orderField;
            long id = (Long)paramMap.getOrDefault("id", 0L);
            boolean isNew = false;
            DynamicObject configTree = (DynamicObject)existMap.get(id);
            if (configTree == null) {
                isNew = true;
                configTree = BusinessDataServiceHelper.newDynamicObject((String)"ricc_configtree");
                configTree.set("id", (Object)id);
                configTree.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                configTree.set("status", (Object)"C");
                newList.add(configTree);
            } else {
                editList.add(configTree);
            }
            long parentId = (Long)paramMap.getOrDefault("parent.id", 0L);
            String parentNumber = (String)paramMap.getOrDefault("parent.number", "");
            DynamicObject newParent = this.getBaseData("ricc_configtree", parentId, parentNumber);
            DynamicObject oldParent = configTree.getDynamicObject("parent");
            long oldParentId = oldParent == null ? 0L : oldParent.getLong("id");
            long newParentId = newParent == null ? 0L : newParent.getLong("id");
            configTree.set("parent_id", (Object)newParentId);
            configTree.set("parent", (Object)newParent);
            if (newParentId == 0L && parentId > 0L) {
                configTree.set("parent_id", (Object)parentId);
            }
            if (StringUtils.isNotEmpty((String)(orderField = (String)paramMap.getOrDefault("orderfield", "")))) {
                configTree.set("orderfield", (Object)orderField);
            } else if (isNew || oldParentId != newParentId) {
                int level = newParent == null ? 0 : newParent.getInt("level");
                String newOder = ImplOrderUtil.getTreeNewOrder((String)"ricc_configtree", (String)"orderfield", (int)level, (long)newParentId);
                configTree.set("orderfield", (Object)newOder);
            }
            String number = (String)paramMap.getOrDefault("number", "");
            String name = (String)paramMap.getOrDefault("name", "");
            try {
                JSONObject nameObject = JSONObject.parseObject((String)name);
                this.setValue(configTree, "number", number);
                this.setValue(configTree, "name", nameObject);
            }
            catch (Exception e) {
                this.setValue(configTree, "number", number);
                this.setValue(configTree, "name", name);
            }
            boolean isPreset = (Boolean)paramMap.getOrDefault("ispreset", configTree.getBoolean("ispreset"));
            configTree.set("ispreset", (Object)isPreset);
            String enable = (String)paramMap.getOrDefault("enable", "1");
            if (!"1".equals(enable) && !"0".equals(enable)) {
                enable = "1";
            }
            configTree.set("enable", (Object)enable);
        }
        if (!newList.isEmpty()) {
            this.saveData("ricc_configtree", newList, errorInfo);
        }
        if (!editList.isEmpty()) {
            this.saveData("ricc_configtree", editList, errorInfo);
        }
        if (errorInfo.length() > 0) {
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        return ConfigItemServiceImpl.success();
    }

    public Object delConfigTrees(List<Long> idList) {
        JSONObject returnInfo;
        StringBuilder errorInfo = new StringBuilder();
        if (idList == null || idList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u9700\u8981\u5220\u9664\u7684\u914d\u7f6e\u9879\u5de6\u6811\u6240\u9700\u7684\u53c2\u6570", (String)"ConfigItemServiceImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u5220\u9664\u914d\u7f6e\u9879\u5de6\u6811\u6570\u636e{}", idList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ricc_configtree", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
        boolean isSuccess = operationResult.isSuccess();
        List successPkIds = operationResult.getSuccessPkIds();
        if (!isSuccess) {
            Map<Object, Object> failPkIdMap = ConfigItemServiceImpl.buildDelFailInfoMap(operationResult, idList, errorInfo);
            returnInfo = ConfigItemServiceImpl.fail(errorInfo.toString());
            returnInfo.put("failPkIdsInfo", failPkIdMap);
        } else {
            returnInfo = ConfigItemServiceImpl.success();
        }
        returnInfo.put("successPkIds", (Object)successPkIds);
        return returnInfo;
    }

    private static Map<Object, Object> buildDelFailInfoMap(OperationResult operationResult, List<Long> idList, StringBuilder errorInfo) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        HashMap<Object, Object> failPkIdMap = new HashMap<Object, Object>(idList.size());
        if (!operationResult.isSuccess() && allErrorOrValidateInfo.isEmpty()) {
            for (Long id : idList) {
                HashMap<String, String> msgMap = new HashMap<String, String>(2);
                msgMap.put("errorCode", "notExistRecords");
                msgMap.put("errorMsg", operationResult.getMessage());
                failPkIdMap.put(id, msgMap);
            }
        }
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            OperateErrorInfo operateErrorInfo = (OperateErrorInfo)iOperateInfo;
            String errorCode = operateErrorInfo.getErrorCode();
            Object pkValue = operateErrorInfo.getPkValue();
            String message = operateErrorInfo.getMessage();
            errorInfo.append(message).append('\n');
            HashMap<String, String> msgMap = new HashMap<String, String>(2);
            msgMap.put("errorCode", errorCode);
            msgMap.put("errorMsg", message);
            failPkIdMap.put(pkValue, msgMap);
        }
        return failPkIdMap;
    }

    public Object saveConfigItem(List<Map<String, Object>> paramMapList) {
        logger.info("\u914d\u7f6e\u9879\u65b0\u589e\u4fee\u6539\u64cd\u4f5c\u5f00\u59cb\uff0c\u64cd\u4f5c\u7528\u6237\uff1a" + UserServiceHelper.getCurrentUserId());
        StringBuilder errorInfo = new StringBuilder();
        if (paramMapList == null || paramMapList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u5f55\u5165\u914d\u7f6e\u9879\u6240\u9700\u7684\u53c2\u6570", (String)"ConfigItemServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u4fdd\u5b58\u914d\u7f6e\u9879\u6570\u636e{}", paramMapList);
        Object[] ids = paramMapList.stream().filter(p -> p.get("id") != null).map(p -> p.get("id")).toArray();
        Map existMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ricc_configitems"));
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(paramMapList.size());
        ArrayList<DynamicObject> editList = new ArrayList<DynamicObject>(paramMapList.size());
        for (Map<String, Object> paramMap : paramMapList) {
            StringBuilder msgInfo = new StringBuilder();
            long id = (Long)paramMap.getOrDefault("id", 0L);
            boolean isNew = false;
            DynamicObject configItem = (DynamicObject)existMap.get(id);
            if (configItem == null) {
                configItem = BusinessDataServiceHelper.newDynamicObject((String)"ricc_configitems");
                configItem.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                configItem.set("status", (Object)"C");
                configItem.set("id", (Object)id);
                isNew = true;
            }
            this.setBaseDataInfo(configItem, isNew, paramMap, msgInfo);
            this.setTransferInfo(configItem, paramMap, msgInfo);
            this.setEntryInfo(configItem, paramMap);
            if (msgInfo.length() > 0) {
                String number = (String)paramMap.getOrDefault("number", "");
                String name = (String)paramMap.getOrDefault("name", "");
                try {
                    JSONObject nameObject = JSONObject.parseObject((String)name);
                    name = nameObject.getString(RequestContext.getOrCreate().getLang().getLocale().toString());
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    name = (String)paramMap.getOrDefault("name", "");
                }
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u7f16\u7801\uff1a%1$s \u914d\u7f6e\u9879\u540d\u79f0\uff1a%2$s\u914d\u7f6e\u9879\u4fdd\u5b58\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u5982\u4e0b\uff1a%3$s", (String)"ConfigItemServiceImpl_15", (String)"sys-ricc-platform", (Object[])new Object[0]), number, name, msgInfo)).append('\n');
                continue;
            }
            if (isNew) {
                newList.add(configItem);
                continue;
            }
            editList.add(configItem);
        }
        if (!newList.isEmpty()) {
            this.saveData("ricc_configitems", newList, errorInfo);
        }
        if (!editList.isEmpty()) {
            this.saveData("ricc_configitems", editList, errorInfo);
        }
        if (errorInfo.length() > 0) {
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        return ConfigItemServiceImpl.success();
    }

    public Object delConfigItems(List<Long> idList) {
        JSONObject returnInfo;
        StringBuilder errorInfo = new StringBuilder();
        if (idList == null || idList.isEmpty()) {
            errorInfo.append(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u5220\u9664\u914d\u7f6e\u9879\u6240\u9700\u7684\u53c2\u6570", (String)"ConfigItemServiceImpl_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return ConfigItemServiceImpl.fail(errorInfo.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u5220\u9664\u914d\u7f6e\u9879\u6570\u636e{}", idList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ricc_configitems", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
        boolean isSuccess = operationResult.isSuccess();
        List successPkIds = operationResult.getSuccessPkIds();
        if (!isSuccess) {
            Map<Object, Object> failPkIdMap = ConfigItemServiceImpl.buildDelFailInfoMap(operationResult, idList, errorInfo);
            returnInfo = ConfigItemServiceImpl.fail(errorInfo.toString());
            returnInfo.put("failPkIdsInfo", failPkIdMap);
        } else {
            returnInfo = ConfigItemServiceImpl.success();
        }
        returnInfo.put("successPkIds", (Object)successPkIds);
        return returnInfo;
    }

    private void saveData(String entityNumber, List<DynamicObject> saveList, StringBuilder errorInfo) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)option);
        boolean success = operationResult.isSuccess();
        if (!success) {
            operationResult.getAllErrorOrValidateInfo().forEach(p -> errorInfo.append(p.getMessage()).append('\n'));
        }
    }

    private void setBaseDataInfo(DynamicObject configItem, boolean isNew, Map<String, Object> paramMap, StringBuilder errorInfo) {
        String orderField;
        String number = (String)paramMap.getOrDefault("number", "");
        String name = (String)paramMap.getOrDefault("name", "");
        try {
            JSONObject nameObject = JSONObject.parseObject((String)name);
            this.setValue(configItem, "number", number);
            this.setValue(configItem, "name", nameObject);
        }
        catch (Exception e) {
            this.setValue(configItem, "number", number);
            this.setValue(configItem, "name", name);
        }
        long groupId = (Long)paramMap.getOrDefault("group.id", 0L);
        String groupNumber = (String)paramMap.getOrDefault("group.number", "");
        DynamicObject group = null;
        DynamicObject configGroup = configItem.getDynamicObject("group");
        if (groupId > 0L || StringUtils.isNotEmpty((String)groupNumber)) {
            group = this.getBaseData("ricc_configtree", groupId, groupNumber);
            if (group == null) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8f93\u5165\u7684\u914d\u7f6e\u9879\u5206\u7ec4id\uff1a%1$s \u5206\u7ec4\u7f16\u7801\uff1a%2$s\u5728\u5f53\u524d\u73af\u5883\u672a\u627e\u5230\uff0c\u8bf7\u786e\u8ba4\u5206\u7ec4\u662f\u5426\u5df2\u6b63\u5e38\u65b0\u589e\n", (String)"ConfigItemServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), groupId, groupNumber));
                return;
            }
            configItem.set("group_id", group.getPkValue());
            configItem.set("group", (Object)group);
        }
        if (StringUtils.isNotEmpty((String)(orderField = (String)paramMap.getOrDefault("orderfield", "")))) {
            configItem.set("orderfield", (Object)orderField);
        } else {
            long newGroupId;
            long oldGroupId = configGroup == null ? 0L : configGroup.getLong("id");
            long l = newGroupId = group == null ? 0L : group.getLong("id");
            if (isNew || oldGroupId != newGroupId) {
                String newOder = ImplOrderUtil.getNewOder((String)"ricc_configitems", (String)"orderfield", (String)"orderfield", (String)"ricc_configtree", (DynamicObject)group);
                configItem.set("orderfield", (Object)newOder);
            }
        }
        String pageId = (String)paramMap.getOrDefault("page.id", "");
        String pageNumber = (String)paramMap.getOrDefault("page.number", configItem.getString("page.number"));
        DynamicObject page = configItem.getDynamicObject("page");
        if (StringUtils.isNotEmpty((String)pageId) || StringUtils.isNotEmpty((String)pageNumber)) {
            page = this.getPage(pageId, pageNumber);
            if (page == null) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8f93\u5165\u7684\u914d\u7f6e\u8868\u5355id\uff1a%1$s \u914d\u7f6e\u8868\u5355\u7f16\u7801\uff1a%2$s\u5728\u5f53\u524d\u73af\u5883\u672a\u627e\u5230\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u8868\u5355\u6570\u636e\u662f\u5426\u6b63\u5e38\n", (String)"ConfigItemServiceImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0]), pageId, pageNumber));
                return;
            }
            configItem.set("page", (Object)page);
        }
        boolean controlled = (Boolean)paramMap.getOrDefault("controlled", Boolean.FALSE);
        configItem.set("controlled", (Object)controlled);
        if (controlled) {
            String rightPageNumber;
            String rightPageId = (String)paramMap.getOrDefault("rightpage.id", "");
            DynamicObject rightPage = this.getPage(rightPageId, rightPageNumber = (String)paramMap.getOrDefault("rightpage.number", ""));
            if (rightPage == null) {
                configItem.set("rightpage", (Object)page);
            } else {
                configItem.set("rightpage", (Object)rightPage);
            }
        } else {
            configItem.set("rightpage", (Object)page);
        }
        String configType = (String)paramMap.getOrDefault("configtype", "");
        this.setValue(configItem, "configtype", configType);
        boolean isPreset = (Boolean)paramMap.getOrDefault("ispreset", configItem.getBoolean("ispreset"));
        configItem.set("ispreset", (Object)isPreset);
        String explain = (String)paramMap.getOrDefault("explain", "");
        this.setValue(configItem, "explain", explain);
        String pageType = (String)paramMap.getOrDefault(PAGE_TYPE, "");
        String customPage = (String)paramMap.getOrDefault(CUSTOM_PAGE, "");
        this.setPageType(configItem, pageType, customPage);
        String pageEnterParam = (String)paramMap.getOrDefault("pageenterparam", "");
        if (!this.checkPageEnterParam(pageEnterParam, errorInfo)) {
            return;
        }
        this.setValue(configItem, "pageenterparam", pageEnterParam);
        String helpText = (String)paramMap.getOrDefault("helptext", "");
        this.setValue(configItem, "helptext", helpText);
        String enable = (String)paramMap.getOrDefault("enable", "1");
        if (!"1".equals(enable) && !"0".equals(enable)) {
            enable = "1";
        }
        configItem.set("enable", (Object)enable);
    }

    private void setTransferInfo(DynamicObject configItem, Map<String, Object> paramMap, StringBuilder errorInfo) {
        boolean supportAddToPacket = (Boolean)paramMap.getOrDefault(SUPPORT_ADD_TO_PACKET, configItem.getBoolean(SUPPORT_ADD_TO_PACKET));
        configItem.set(SUPPORT_ADD_TO_PACKET, (Object)supportAddToPacket);
        if (supportAddToPacket) {
            String importType = (String)paramMap.getOrDefault(IMPORT_TYPE, configItem.getString(IMPORT_TYPE));
            this.setValue(configItem, IMPORT_TYPE, importType);
            String keyFields = (String)paramMap.getOrDefault("keyfields", "");
            this.setValue(configItem, "keyfields", keyFields);
            String sortField = (String)paramMap.getOrDefault("sortfield", "");
            this.setValue(configItem, "sortfield", sortField);
            String sortWay = (String)paramMap.getOrDefault("sortway", "");
            this.setValue(configItem, "sortway", sortWay);
            if ("excel".equals(importType)) {
                String dataImportType = (String)paramMap.getOrDefault("dataimporttype", "");
                this.setValue(configItem, "dataimporttype", dataImportType);
                long importTemplateId = Long.parseLong(paramMap.getOrDefault("importtemplate.id", 0L).toString());
                String importTemplateNumber = (String)paramMap.getOrDefault("importtemplate.number", "");
                DynamicObject importTemplate = this.getBaseData("bos_importtemplate", importTemplateId, importTemplateNumber);
                if (importTemplate != null) {
                    configItem.set("importtemplateid", importTemplate.getPkValue());
                }
                boolean isOverrideEntry = (Boolean)paramMap.getOrDefault(IS_OVERRIDE_ENTRY, configItem.getBoolean(IS_OVERRIDE_ENTRY));
                configItem.set(IS_OVERRIDE_ENTRY, (Object)isOverrideEntry);
            } else if ("custom".equals(importType)) {
                String plugin = (String)paramMap.getOrDefault(PLUGIN, "");
                this.setValue(configItem, PLUGIN, plugin);
            } else if ("microService".equals(importType)) {
                boolean check;
                Map<String, Object> microParam = paramMap.getOrDefault("microParam", Collections.emptyMap());
                if (!microParam.isEmpty() && (check = this.checkMicroParam(microParam, errorInfo))) {
                    configItem.set(PLUGIN, (Object)JSON.toJSONString(microParam));
                }
            } else if (!"json".equals(importType)) {
                errorInfo.append(ResManager.loadKDString((String)"\u4f20\u8f93\u65b9\u5f0f\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\n", (String)"ConfigItemServiceImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
        }
        String custParamPage = (String)paramMap.getOrDefault("custparampage", "");
        this.setValue(configItem, "custparampage", custParamPage);
        boolean canExportAll = (Boolean)paramMap.getOrDefault(CAN_EXPORT_ALL, configItem.getBoolean(CAN_EXPORT_ALL));
        configItem.set(CAN_EXPORT_ALL, (Object)canExportAll);
        if (canExportAll) {
            String exportFiltersDesc = (String)paramMap.getOrDefault("exportfiltersdesc", "");
            String exportFilters = (String)paramMap.getOrDefault("exportfilters", "");
            this.setValue(configItem, "exportfiltersdesc", exportFiltersDesc);
            this.setValue(configItem, "exportfilters", exportFilters);
        }
    }

    private void setEntryInfo(DynamicObject configItem, Map<String, Object> paramMap) {
        List relyItemEntry = paramMap.getOrDefault("relyitementry", Collections.emptyList());
        DynamicObjectCollection relyEntryObj = configItem.getDynamicObjectCollection("relyitementry");
        relyEntryObj.clear();
        if (!relyItemEntry.isEmpty()) {
            for (Map relyItem : relyItemEntry) {
                String relyItemId = relyItem.getOrDefault("relyitem.id", "");
                String relyRelationField = relyItem.getOrDefault("relyrelationfield", "");
                DynamicObject dynamicObject = new DynamicObject(relyEntryObj.getDynamicObjectType());
                dynamicObject.set("relyitem_id", (Object)relyItemId);
                dynamicObject.set("relyrelationfield", (Object)relyRelationField);
                relyEntryObj.add((Object)dynamicObject);
            }
        }
        List schemeEntry = paramMap.getOrDefault("ricc_schemeentry", Collections.emptyList());
        DynamicObjectCollection schemeEntryObj = configItem.getDynamicObjectCollection("ricc_schemeentry");
        schemeEntryObj.clear();
        if (!schemeEntry.isEmpty()) {
            for (Map scheme : schemeEntry) {
                String iscType = scheme.getOrDefault("isctype", "");
                String schemeId = scheme.getOrDefault("scheme.id", "");
                String entryExplain = scheme.getOrDefault("entryexplain", "");
                DynamicObject dynamicObject = new DynamicObject(relyEntryObj.getDynamicObjectType());
                dynamicObject.set("isctype", (Object)iscType);
                dynamicObject.set("scheme_id", (Object)schemeId);
                dynamicObject.set("entryexplain", (Object)entryExplain);
                schemeEntryObj.add((Object)dynamicObject);
            }
        }
    }

    private void setPageType(DynamicObject configItem, String pageType, String customPage) {
        this.setValue(configItem, PAGE_TYPE, pageType);
        this.setValue(configItem, CUSTOM_PAGE, customPage);
        if (!StringUtils.isEmpty((String)pageType)) {
            return;
        }
        DynamicObject page = configItem.getDynamicObject("page");
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)page.getString("number"));
        if (listFormConfig == null) {
            this.setValue(configItem, PAGE_TYPE, "bos_dynamicform");
            return;
        }
        String pageTypeList = listFormConfig.getListFormId();
        if (pageTypeList.equals("bos_list") || pageTypeList.equals("bos_templatetreelist") || pageTypeList.equals("bos_treelist")) {
            this.setValue(configItem, PAGE_TYPE, pageTypeList);
            return;
        }
        this.setValue(configItem, PAGE_TYPE, "custom");
        this.setValue(configItem, CUSTOM_PAGE, pageTypeList);
    }

    private DynamicObject getBaseData(String entityName, long id, String number) {
        QFilter groupQf = id > 0L ? new QFilter("id", "=", (Object)id) : new QFilter("number", "=", (Object)number);
        DynamicObject baseData = null;
        try {
            baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])groupQf.toArray());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return baseData;
    }

    private DynamicObject getPage(String pageId, String pageNumber) {
        QFilter pageQf = !StringUtils.isEmpty((String)pageId) ? new QFilter("id", "=", (Object)pageId) : new QFilter("number", "=", (Object)pageNumber);
        DynamicObject page = null;
        try {
            page = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (QFilter[])pageQf.toArray());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return page;
    }

    private void setValue(DynamicObject dynamicObject, String key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        dynamicObject.set(key, (Object)value);
    }

    private void setValue(DynamicObject dynamicObject, String key, Object value) {
        if (value == null) {
            return;
        }
        dynamicObject.set(key, value);
    }

    private boolean checkPageEnterParam(String pagEnterParamStr, StringBuilder errorInfo) {
        Map customParamMap;
        String appId;
        String caption;
        JSONObject map;
        if (StringUtils.isEmpty((String)pagEnterParamStr)) {
            return true;
        }
        try {
            map = JSON.parseObject((String)pagEnterParamStr).getJSONObject("params");
        }
        catch (JSONException e) {
            logger.error((Throwable)e);
            String errorTips = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u9875\u9762\u5165\u53e3\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u9875\u9762\u5165\u53e3\u53c2\u6570\u683c\u5f0f\u662f\u5426\u6b63\u5e38\uff0c\u5177\u4f53\u539f\u56e0\uff1a%1$s\n", (String)"ConfigItemServiceImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage());
            errorInfo.append(errorTips);
            return false;
        }
        if (map == null || map.isEmpty()) {
            return true;
        }
        Map captionMap = (Map)map.get("setCaption");
        if (captionMap != null && !captionMap.isEmpty() && StringUtils.isEmpty((String)(caption = (String)captionMap.get("caption")))) {
            String errorTips = ResManager.loadKDString((String)"setCaption\u7684\u503c\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199setCaption\u53c2\u6570\u503c\n", (String)"ConfigItemServiceImpl_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
            errorInfo.append(errorTips);
            return false;
        }
        Map appIdMap = (Map)map.get("setAppId");
        if (appIdMap != null && !appIdMap.isEmpty() && StringUtils.isEmpty((String)(appId = (String)appIdMap.get("appId")))) {
            String errorTips = ResManager.loadKDString((String)"setAppId\u7684\u503c\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199setAppId\u53c2\u6570\u503c\n", (String)"ConfigItemServiceImpl_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
            errorInfo.append(errorTips);
            return false;
        }
        Map customPluginMap = (Map)map.get("addCustPlugin");
        if (customPluginMap != null && !customPluginMap.isEmpty()) {
            for (Map.Entry customPluginEntry : customPluginMap.entrySet()) {
                String plugin = (String)customPluginEntry.getValue();
                String key = (String)customPluginEntry.getKey();
                if (!StringUtils.isEmpty((String)plugin)) continue;
                String errorTips = ResManager.loadKDString((String)"addCustPlugin\u7684%1$s\u503c\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199addCustPlugin\u53c2\u6570\u503c\n", (String)"ConfigItemServiceImpl_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
                errorInfo.append(String.format(errorTips, key));
                return false;
            }
        }
        if ((customParamMap = (Map)map.get("setCustomParam")) != null && !customParamMap.isEmpty()) {
            for (Map.Entry customPluginEntry : customParamMap.entrySet()) {
                String value = (String)customPluginEntry.getValue();
                String key = (String)customPluginEntry.getKey();
                if (!StringUtils.isEmpty((String)key) && !StringUtils.isEmpty((String)value)) continue;
                String errorTips = ResManager.loadKDString((String)"setCustomParam\u5b58\u5728\u53c2\u6570\u540d\u79f0\u6216\u8005\u53c2\u6570\u503c\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199setCustomParam\u53c2\u6570\u540d\u79f0\u548c\u53c2\u6570\u503c\n", (String)"ConfigItemServiceImpl_12", (String)"sys-ricc-platform", (Object[])new Object[0]);
                errorInfo.append(errorTips);
                return false;
            }
        }
        return true;
    }

    private boolean checkMicroParam(Map<String, Object> microParam, StringBuilder errorInfo) {
        String appId = (String)microParam.getOrDefault("appid", "");
        if (StringUtils.isEmpty((String)appId)) {
            errorInfo.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5fae\u670d\u52a1\u5bfc\u5165\u5bfc\u51fa\u7684\u4e1a\u52a1\u5e94\u7528", (String)"ConfigItemServiceImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
            return false;
        }
        String serviceName = (String)microParam.getOrDefault("servicename", "");
        if (StringUtils.isEmpty((String)serviceName)) {
            errorInfo.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5fae\u670d\u52a1\u5bfc\u5165\u5bfc\u51fa\u7684\u670d\u52a1\u540d\u79f0", (String)"ConfigItemServiceImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
            return false;
        }
        List<Map<String, String>> paramList = microParam.getOrDefault("params", Collections.emptyList());
        return this.checkMicroEntryParam(paramList, errorInfo);
    }

    private boolean checkMicroEntryParam(List<Map<String, String>> paramList, StringBuilder errorInfo) {
        if (paramList == null || paramList.isEmpty()) {
            return true;
        }
        int i = 1;
        boolean hasError = true;
        for (Map<String, String> param : paramList) {
            String val = param.get("val");
            if (StringUtils.isEmpty((String)val)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fae\u670d\u52a1\u5bfc\u5165\u5bfc\u51fa\u81ea\u5b9a\u4e49\u53c2\u6570\u7b2c%1$s\u884c\u53c2\u6570\u503c\n", (String)"ConfigItemServiceImpl_7", (String)"sys-ricc-platform", (Object[])new Object[0]), i));
                hasError = false;
            }
            ++i;
        }
        return hasError;
    }
}

