/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.mservice.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import kd.sys.ricc.mservice.impl.PackSchemeServiceImpl;
import org.apache.commons.io.FilenameUtils;

public class MetaDataPackServiceImpl {
    private static final Log logger = LogFactory.getLog(PackSchemeServiceImpl.class);
    private static final String SUCCESS = "success";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZCLOUD = "bizcloud";
    private static final String DATAMODEL = "datamodel";
    private static final String REGEX = "'-'";
    private Map<Object, DynamicObject> cloudIdMapping;

    public static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put(SUCCESS, Boolean.TRUE);
        return result;
    }

    public static Map<String, Object> fail(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put(SUCCESS, Boolean.FALSE);
        result.put("msg", msg);
        return result;
    }

    public Map<String, Object> exportPack(Long packetId, Map<String, Map<String, List<Object>>> params) {
        logger.info("\u5fae\u670d\u52a1\u5143\u6570\u636e\u6253\u5305\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null || params.isEmpty()) {
            return MetaDataPackServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"MetaDataPackServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        StringBuilder msg = new StringBuilder();
        ListSelectedRow selectPacket = this.getSelectRow(packetId, msg);
        if (selectPacket == null) {
            return MetaDataPackServiceImpl.fail(msg.toString());
        }
        logger.info("\u5fae\u670d\u52a1\u6253\u5305\u5143\u6570\u636e\u4f20\u8f93\u5305\u7f16\u7801\u4e3a\uff1a{}", (Object)selectPacket.getNumber());
        boolean success = this.metaDataExport(selectPacket, params, msg);
        boolean isNewPacket = packetId == null || packetId == 0L;
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (!success && isNewPacket) {
            DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])new QFilter("id", "in", selectPacket.getPrimaryKeyValue()).toArray());
        } else {
            result.put("packetName", selectPacket.getName());
        }
        result.put(SUCCESS, success);
        result.put("msg", msg);
        return result;
    }

    private ListSelectedRow getSelectRow(Long packetId, StringBuilder msg) {
        DynamicObject packet;
        ListSelectedRow selectedPacket = new ListSelectedRow();
        if (packetId != null && (packet = QueryServiceHelper.queryOne((String)"ricc_datapacket", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)packetId)})) != null) {
            selectedPacket.setName(packet.getString("name"));
            selectedPacket.setNumber(packet.getString("number"));
            selectedPacket.setPrimaryKeyValue(packet.get("id"));
            return selectedPacket;
        }
        boolean hasNewPacketPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"ricc", (String)"ricc_datapacket", (String)"47156aff000000ac");
        boolean hasSavePacketPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"ricc", (String)"ricc_datapacket", (String)"0=KX5+QVF5+R");
        if (!hasNewPacketPerm || !hasSavePacketPerm) {
            msg.append(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f20\u8f93\u5305\u7684\u65b0\u589e\u6216\u4fdd\u5b58\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"MetaDataPackServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return null;
        }
        return this.createPacket(msg, packetId);
    }

    private ListSelectedRow createPacket(StringBuilder msg, Long packetId) {
        ListSelectedRow selectPacket = new ListSelectedRow();
        DynamicObject newPacket = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datapacket");
        long id = packetId == null || packetId == 0L ? DB.genLongId((String)"ricc_datapacket") : packetId;
        newPacket.set("id", (Object)id);
        newPacket.set("packetversion", (Object)0);
        newPacket.set("status", (Object)"A");
        newPacket.set("creator", (Object)RequestContext.get().getCurrUserId());
        newPacket.set("createtime", (Object)System.currentTimeMillis());
        newPacket.set("dltrcount", (Object)0);
        newPacket.set("enable", (Object)"1");
        newPacket.set("packettype", (Object)DataPacketTypeEnum.METADATA.getVal());
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMddHHmm");
        String currentDateStr = today.format(formatter);
        String packetName = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u6253\u5305%s", (String)"MetaDataPackServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), currentDateStr);
        newPacket.set("name", (Object)packetName);
        String readNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datapacket", (DynamicObject)newPacket, null);
        newPacket.set("number", (Object)readNumber);
        newPacket.set("datasource", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal());
        newPacket.set("lockedstatus", (Object)PacketLockEnum.NOT_LOCKED.getVal());
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPacket});
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4f20\u8f93\u5305\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            msg.append(ResManager.loadKDString((String)"\u521b\u5efa\u4f20\u8f93\u5305\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"MetaDataPackServiceImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e.getMessage());
            return null;
        }
        selectPacket.setName(packetName);
        selectPacket.setNumber(readNumber);
        selectPacket.setPrimaryKeyValue((Object)id);
        return selectPacket;
    }

    private boolean metaDataExport(ListSelectedRow listSelectedRow, Map<String, Map<String, List<Object>>> params, StringBuilder msg) {
        Set<String> selectAppList = params.keySet();
        QFilter idFilter = new QFilter("id", "in", selectAppList);
        DynamicObject[] appInfos = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,number,isv,name,version,bizcloud.id as cloudid,bizcloud", (QFilter[])new QFilter[]{idFilter});
        if (appInfos.length <= 0) {
            msg.append(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", (String)"MetaDataPackServiceImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        String defaultCloudNum = ((DynamicObject)appInfos[0].get(BIZCLOUD)).getString("number");
        String defaultAppNum = appInfos[0].getString("number");
        String defaultAppVersion = appInfos[0].getString("version");
        Map<String, List<String>> cloudAppListMap = this.appListGroupByCloud(appInfos);
        ArrayList<DynamicObject> subDataPackets = new ArrayList<DynamicObject>(cloudAppListMap.size());
        try {
            for (Map.Entry<String, List<String>> cloudMapping : cloudAppListMap.entrySet()) {
                DynamicObject subDataPacket = this.createSubDataPacketByCloud(listSelectedRow, cloudMapping, defaultCloudNum, defaultAppNum, defaultAppVersion, params, msg);
                if (subDataPacket != null) {
                    subDataPackets.add(subDataPacket);
                    continue;
                }
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5143\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff1a\u5f02\u5e38\u5e94\u7528id\u4e3a %s ", (String)"MetaDataPackServiceImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]), Arrays.toString(cloudMapping.getValue().toArray())));
            }
            SubDataPacketDispatch.saveBatchSubDataPacket(listSelectedRow.getPrimaryKeyValue(), subDataPackets);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5143\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            msg.append(e.getMessage()).append(CommonUtil.getExceptionDetailInfo((Throwable)e));
            return false;
        }
        return true;
    }

    private DynamicObject createSubDataPacketByCloud(ListSelectedRow selectedPacket, Map.Entry<String, List<String>> cloudMapping, String defaultCloudNum, String defaultAppNum, String defaultAppVersion, Map<String, Map<String, List<Object>>> params, StringBuilder msg) throws IOException {
        DynamicObject subDataPacket;
        String cloudInfo = cloudMapping.getKey();
        List<String> selectAppList = cloudMapping.getValue();
        String localPath = FileUtils.generateLocalPath();
        String defaultAppPackageName = defaultCloudNum + "-" + defaultAppNum + "-dm";
        String defaultDmPath = localPath + File.separator + defaultAppPackageName;
        String traceIdHash = RequestContext.get().getTraceId();
        String defaultZipPath = defaultDmPath + File.separator + traceIdHash;
        String defaultAppPath = defaultZipPath + File.separator + DATAMODEL + File.separator + defaultAppVersion + File.separator + "main";
        try {
            File defaultAppFile = FileUtils.createFile((String)defaultAppPath).getCanonicalFile();
            defaultAppFile.mkdirs();
        }
        catch (Exception e) {
            logger.error("\u5b89\u88c5\u5305\u521b\u5efa\u5931\u8d25", (Throwable)e);
            throw new RiccBizException(ResManager.loadKDString((String)"\u5b89\u88c5\u5305\u521b\u5efa\u5931\u8d25", (String)"MetaDataPackServiceImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
        }
        ArrayList<String> appZipNames = new ArrayList<String>();
        ArrayList<String> appNumberList = new ArrayList<String>(selectAppList.size());
        StringBuilder selectMetaInfo = new StringBuilder();
        AtomicInteger count = new AtomicInteger();
        for (String selectAppId : selectAppList) {
            AppMetadata selectAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectAppId, (boolean)false);
            if (selectAppMeta == null) continue;
            selectMetaInfo.append("\n------").append(selectAppMeta.getName().getLocaleValue()).append("------\n");
            String selectAppNum = selectAppMeta.getNumber().toLowerCase();
            appNumberList.add(selectAppNum);
            String selectCloudId = selectAppMeta.getBizCloudID();
            DynamicObject selectCloudObject = this.cloudIdMapping.get(selectCloudId);
            String selectCloudNum = selectCloudObject.getString("number").toLowerCase();
            String selectAppPath = defaultAppPath + File.separator + selectAppNum;
            String appPackageName = selectCloudNum + "-" + selectAppNum + "-dm";
            File selectAppFile = null;
            JSONArray dbschemaMsg = new JSONArray();
            JSONArray preinsdataMsg = new JSONArray();
            ArrayList<String> sqlNameList = new ArrayList<String>();
            boolean hasXmlFlag = false;
            selectAppFile = FileUtils.createFile((String)selectAppPath).getCanonicalFile();
            if (!selectAppFile.exists()) {
                selectAppFile.mkdirs();
            }
            Map<String, List<Object>> typeMapping = params.get(selectAppId);
            for (Map.Entry<String, List<Object>> typeToParametersMap : typeMapping.entrySet()) {
                List<Object> value = typeToParametersMap.getValue();
                PackTypes packType = PackTypes.fromValue(typeToParametersMap.getKey());
                if (value == null || value.isEmpty()) {
                    msg.append('\u3010').append(packType.getValue()).append('\u3011').append(ResManager.loadKDString((String)"\u7c7b\u578b\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u505a\u6253\u5305\u5904\u7406\u3002\n", (String)"MetaDataPackServiceImpl_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    continue;
                }
                selectMetaInfo.append(packType.getDescription()).append('\uff1a').append('\n');
                switch (packType) {
                    case PAGE: {
                        this.exportPage(selectMetaInfo, selectAppPath, value);
                        break;
                    }
                    case SCRIPT: {
                        this.exportScript(selectMetaInfo, selectAppPath, value);
                        break;
                    }
                    case WK_BENCH: {
                        hasXmlFlag = this.exportWkBench(selectMetaInfo, selectAppPath, sqlNameList, value);
                        break;
                    }
                    case DB_SCHEME: {
                        this.setSqlValue(value, selectAppPath, selectAppId, dbschemaMsg, "dbschema", selectMetaInfo);
                        break;
                    }
                    case PREINS_DATA: {
                        this.setSqlValue(value, selectAppPath, selectAppId, preinsdataMsg, "preinsdata", selectMetaInfo);
                        break;
                    }
                    case BILL_TYPE: {
                        this.exportBillType(selectMetaInfo, selectAppPath, sqlNameList, value);
                        break;
                    }
                    case CODE_ROLE: {
                        this.exportCodeRole(selectMetaInfo, selectAppPath, sqlNameList, value);
                        break;
                    }
                    case APP_INFO: {
                        DevportalUtil.expAppMetadata((String)selectAppId, (String)selectAppPath, (String)"EXPORT_APP");
                        break;
                    }
                    case CLOUD_INFO: {
                        DevportalUtil.expCloudMetadata((String)selectCloudId, (String)selectAppPath, (String)"EXPORT_CLOUD");
                        selectMetaInfo.append(defaultCloudNum).append("      ").append(selectCloudObject.getString("name")).append('\n');
                        break;
                    }
                }
            }
            InputStream appMd5Input = null;
            try {
                AppPackageUtil.createDataModelXML((String)selectAppId, (String)selectAppNum, (String)selectCloudNum, (String)defaultAppVersion, (String)defaultZipPath);
                AppPackageUtil.createAppXML((String)selectAppId, (String)selectAppNum, (String)selectAppPath, (JSONArray)dbschemaMsg, (JSONArray)preinsdataMsg, sqlNameList, (boolean)hasXmlFlag);
                ArrayList fileList = new ArrayList();
                String datamodelPath = defaultZipPath + File.separator + DATAMODEL;
                List appSourceList = DevportalUtil.recursiveFiles((String)datamodelPath, fileList);
                count.getAndAdd(appSourceList.size());
                StringBuilder appRelPathBuilder = new StringBuilder();
                appSourceList.forEach(appSource -> {
                    int datamodelIndex = appSource.indexOf(DATAMODEL);
                    String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
                    if (!appRelPath.endsWith("filelist.txt")) {
                        appRelPathBuilder.append(appRelPath);
                        appRelPathBuilder.append(System.lineSeparator());
                    }
                });
                String appInfoPath = datamodelPath + File.separator + "filelist.txt";
                this.createLogInfo(appRelPathBuilder.toString(), appInfoPath);
                this.zipDmFile(appPackageName, defaultZipPath);
                appZipNames.add(appPackageName);
                String dmPath = defaultZipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
                Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)dmPath), new String[0]);
                appMd5Input = Files.newInputStream(zipPath, new OpenOption[0]);
                if (!selectAppFile.exists()) continue;
                AppUtils.deleteKd((File)selectAppFile);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fadatamodel\u3001app xml\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                throw new RiccBizException(ResManager.loadKDString((String)"\u5bfc\u51fadatamodel\u3001app xml\u6587\u4ef6\u51fa\u9519", (String)"MetaDataPackServiceImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
            }
            finally {
                if (appMd5Input == null) continue;
                try {
                    appMd5Input.close();
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                    AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)exception.getMessage());
                }
            }
        }
        try {
            if (!appNumberList.isEmpty()) {
                String packagePath = defaultZipPath + File.separator + "appInfo.xml";
                AppPackageUtil.createAppInfo((String)defaultZipPath, appNumberList, (String)packagePath);
                count.getAndIncrement();
            }
            DevportalUtil.zipFiles(appZipNames, (String)defaultZipPath, (String)defaultAppPackageName);
            String downloadPath = defaultZipPath + File.separator + defaultAppPackageName + ".zip";
            String fileName = "ricc_metadata_export_" + System.currentTimeMillis() + ".zip";
            String uploadPath = SysParaUtil.getSavePath() + selectedPacket.getNumber();
            List list = CommonUtil.uploadDataPacket((Object)selectedPacket.getPrimaryKeyValue(), (String)localPath, (String)downloadPath, (String)uploadPath, (String)fileName);
            if (list.isEmpty()) {
                throw new RiccBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"MetaDataPackServiceImpl_19", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            HashMap<String, Object> custParam = new HashMap<String, Object>(2);
            String[] cloudInfoArr = cloudInfo.split(REGEX);
            custParam.put("cloudId", cloudInfoArr[0]);
            custParam.put("cloudNumber", cloudInfoArr[1]);
            subDataPacket = SubDataPacketDispatch.createEntryRow(DataPacketTypeEnum.CONFIG.getVal(), 1372332741948866560L, -1, ((DynamicObject)list.get(0)).getLong("id"), fileName, custParam, selectMetaInfo.toString(), count.get());
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
            throw new RiccBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (String)"MetaDataPackServiceImpl_20", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                File zipFile = FileUtils.createFile((String)defaultZipPath).getCanonicalFile();
                if (zipFile.exists()) {
                    boolean deleteFlag;
                    AppUtils.deleteKd((File)zipFile);
                    String appNumberStr = localPath + File.separator + defaultAppPackageName;
                    File appNumberPath = FileUtils.createFile((String)appNumberStr);
                    if (Objects.requireNonNull(appNumberPath.listFiles()).length == 0 && !(deleteFlag = appNumberPath.delete())) {
                        logger.warn("delete file" + appNumberPath.getAbsolutePath() + "fail.");
                    }
                }
            }
            catch (Exception ioExp) {
                logger.error((Throwable)ioExp);
                AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)ioExp.getMessage());
            }
        }
        return subDataPacket;
    }

    private void exportCodeRole(StringBuilder selectMetaInfo, String selectAppPath, List<String> sqlNameList, List<Object> value) {
        List coderuleFileList;
        List crIdList = value.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
        if (!crIdList.isEmpty() && !(coderuleFileList = CodeRuleServiceHelper.exportCodeRuleByCoderuleID(crIdList)).isEmpty()) {
            for (CoderuleFile coderuleFile : coderuleFileList) {
                sqlNameList.add(coderuleFile.getFileName() + ".sql");
                this.exportSource(coderuleFile, selectAppPath);
                selectMetaInfo.append(coderuleFile.getFileName()).append('\n');
            }
        }
    }

    private void exportBillType(StringBuilder selectMetaInfo, String selectAppPath, List<String> sqlNameList, List<Object> value) {
        List btIdList = value.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
        List billtypeExportFileList = BillTypeServiceHelper.exportBillTypeByIds(btIdList);
        if (!billtypeExportFileList.isEmpty()) {
            for (BillTypeFile billtypeFile : billtypeExportFileList) {
                sqlNameList.add(billtypeFile.getFileName() + ".sql");
                this.exportSource(billtypeFile, selectAppPath);
                selectMetaInfo.append(billtypeFile.getFileName()).append('\n');
            }
        }
    }

    private boolean exportWkBench(StringBuilder selectMetaInfo, String selectAppPath, List<String> sqlNameList, List<Object> value) {
        List wkList = value.stream().filter(Long.class::isInstance).map(Long.class::cast).collect(Collectors.toList());
        QFilter wkFilter = new QFilter("id", "in", wkList);
        DynamicObjectCollection portalSchemes = QueryServiceHelper.query((String)"portal_scheme", (String)"id,number,name", (QFilter[])wkFilter.toArray());
        for (DynamicObject scheme : portalSchemes) {
            selectMetaInfo.append(scheme.get("number")).append("       ").append(scheme.get("name")).append('\n');
        }
        boolean hasXmlFlag = AppPackageUtil.exportPageScheme(wkList, (String)selectAppPath, sqlNameList);
        return hasXmlFlag;
    }

    private void exportScript(StringBuilder selectMetaInfo, String selectAppPath, List<Object> value) {
        List scriptIds = value.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
        QFilter scriptFilter = new QFilter("id", "in", scriptIds);
        DynamicObjectCollection scriptData = QueryServiceHelper.query((String)"ide_pluginscript", (String)"id, txt_scriptnumber, txt_scriptname", (QFilter[])scriptFilter.toArray());
        for (DynamicObject script : scriptData) {
            DevportalUtil.expScriptMeta((String)script.getString("id"), (String)selectAppPath);
            selectMetaInfo.append(script.get("txt_scriptnumber")).append("     ").append(script.get("txt_scriptname")).append('\n');
        }
    }

    private void exportPage(StringBuilder selectMetaInfo, String selectAppPath, List<Object> value) {
        List pageIds = value.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
        QFilter pageFilter = new QFilter("id", "in", pageIds);
        DynamicObjectCollection pageData = QueryServiceHelper.query((String)"bos_formmeta", (String)"id, number, name", (QFilter[])pageFilter.toArray());
        for (DynamicObject page : pageData) {
            DevportalUtil.expFormMetadata((String)page.getString("id"), (String)selectAppPath, (String)"EXPORT_PAGE");
            selectMetaInfo.append(page.get("number")).append("     ").append(page.get("name")).append('\n');
        }
    }

    private void setSqlValue(List<Object> value, String selectAppPath, String selectAppId, JSONArray preinsdataMsg, String type, StringBuilder selectMetaInfo) {
        List sqlData = value.stream().filter(JSONObject.class::isInstance).map(JSONObject.class::cast).collect(Collectors.toList());
        for (JSONObject jsonObject : sqlData) {
            String urlName = jsonObject.getString("urlname");
            selectMetaInfo.append(urlName).append('\n');
            String url = jsonObject.getString("url");
            AppPackageUtil.exportSchOrPreSource((String)selectAppPath, (String)urlName, (String)url, (String)type);
            jsonObject.put("sqlappid", (Object)selectAppId);
            preinsdataMsg.add((Object)jsonObject);
        }
    }

    private Map<String, List<String>> appListGroupByCloud(DynamicObject[] appInfo) {
        HashMap<String, List<String>> cloudAppListMap = new HashMap<String, List<String>>(appInfo.length);
        ArrayList<String> cloudIdList = new ArrayList<String>(10);
        for (DynamicObject oneApp : appInfo) {
            String cloudId = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("id");
            cloudIdList.add(cloudId);
            String cloudNumber = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("number");
            String key = cloudId + REGEX + cloudNumber;
            String appId = oneApp.getString("id");
            List<String> appIdList = new ArrayList<String>();
            List keyVal = (List)cloudAppListMap.get(key);
            if (keyVal != null) {
                appIdList = keyVal;
            }
            appIdList.add(appId);
            cloudAppListMap.put(key, appIdList);
        }
        DynamicObject[] loadCloudData = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZCLOUD, (String)"id,name,number", (QFilter[])new QFilter("id", "in", cloudIdList).toArray());
        this.cloudIdMapping = Arrays.stream(loadCloudData).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        return cloudAppListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLogInfo(String detailErrorInfo, String packagePath) {
        String checkPackagePath = DevportalUtil.checkFilePath((String)packagePath);
        File packageFile = FileUtils.createFile((String)packagePath);
        OutputStream fos = null;
        try {
            boolean packageCreate;
            boolean delete;
            if (packageFile.exists() && !(delete = packageFile.delete())) {
                logger.warn("delete file" + packageFile.getAbsolutePath() + "fail.");
            }
            if (packageCreate = packageFile.createNewFile()) {
                Path customZipPath = Paths.get(checkPackagePath, new String[0]);
                fos = Files.newOutputStream(customZipPath, new OpenOption[0]);
                fos.write(detailErrorInfo.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                    AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)exception.getMessage());
                }
            }
        }
    }

    private void zipDmFile(String appPackageName, String zipPath) {
        File dmFile;
        JSONArray files = new JSONArray();
        File file = FileUtils.createFile((String)zipPath);
        if (file.exists()) {
            files.add((Object)zipPath);
        }
        if (!(dmFile = FileUtils.createFile((String)(zipPath + File.separator + "dm"))).exists()) {
            dmFile.mkdirs();
        }
        String zipFilePath = zipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
        Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)zipFilePath), new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.zipFile((JSONArray)files, (ZipOutputStream)out, (String)"");
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new RiccBizException((Throwable)e);
        }
    }

    private void exportSource(Object objectFile, String appPath) {
        block32: {
            String fileName = "";
            List dataList = Collections.emptyList();
            if (objectFile instanceof CoderuleFile) {
                fileName = ((CoderuleFile)objectFile).getFileName();
                dataList = ((CoderuleFile)objectFile).getFileContent();
            } else if (objectFile instanceof BillTypeFile) {
                fileName = ((BillTypeFile)objectFile).getFileName();
                dataList = ((BillTypeFile)objectFile).getFileContent();
            }
            Path filePath = Paths.get(appPath, "preinsdata", FilenameUtils.getName((String)(fileName + ".sql")));
            File file = FileUtils.createFile((String)filePath.toString());
            File coderuleAboveFile = file.getParentFile();
            if (!coderuleAboveFile.exists()) {
                coderuleAboveFile.mkdirs();
            }
            if (!file.exists()) {
                try {
                    boolean fileCreate = file.createNewFile();
                    if (!fileCreate) break block32;
                    Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)filePath.toString()), new String[0]);
                    try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        for (String data : dataList) {
                            writer.write(data + System.lineSeparator());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
    }

    public static enum PackTypes {
        PAGE("page", new MultiLangEnumBridge("\u7cfb\u7edf\u8868\u5355", "MetaDataPackServiceImpl_9", "sys-ricc-platform")),
        SCRIPT("script", new MultiLangEnumBridge("\u4e1a\u52a1\u811a\u672c", "MetaDataPackServiceImpl_10", "sys-ricc-platform")),
        APP_INFO("appInfo", new MultiLangEnumBridge("\u5e94\u7528\u4fe1\u606f", "MetaDataPackServiceImpl_11", "sys-ricc-platform")),
        CLOUD_INFO("cloudInfo", new MultiLangEnumBridge("\u4e91\u914d\u7f6e\u4fe1\u606f", "MetaDataPackServiceImpl_12", "sys-ricc-platform")),
        BILL_TYPE("billType", new MultiLangEnumBridge("\u5355\u636e\u7c7b\u578b", "MetaDataPackServiceImpl_13", "sys-ricc-platform")),
        CODE_ROLE("codeRole", new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219\u5b9a\u4e49", "MetaDataPackServiceImpl_14", "sys-ricc-platform")),
        WK_BENCH("wkBench", new MultiLangEnumBridge("\u9996\u9875\u5de5\u4f5c\u53f0\u65b9\u6848", "MetaDataPackServiceImpl_15", "sys-ricc-platform")),
        DB_SCHEME("dbScheme", new MultiLangEnumBridge("\u5efa\u8868\u811a\u672c", "MetaDataPackServiceImpl_16", "sys-ricc-platform")),
        PREINS_DATA("preinsData", new MultiLangEnumBridge("\u9884\u63d2\u6570\u636e", "MetaDataPackServiceImpl_17", "sys-ricc-platform"));

        private String value;
        private MultiLangEnumBridge description;

        private PackTypes(String value, MultiLangEnumBridge description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description.loadKDString();
        }

        public static PackTypes fromValue(String value) {
            for (PackTypes resource : PackTypes.values()) {
                if (!resource.getValue().equals(value)) continue;
                return resource;
            }
            String desc = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5143\u6570\u636e\u7c7b\u578b\uff1a%s", (String)"MetaDataPackServiceImpl_18", (String)"sys-ricc-platform", (Object[])new Object[0]), value);
            throw new RiccBizException();
        }
    }
}

