/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.kse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class CertBean {
    private String trustsFilePath = null;
    private String sigSM2FilePath = null;
    private String sigSM2FilePass = null;
    private String encSM2FilePath = null;
    private String encSM2FilePass = null;

    public CertBean() {
    }

    public CertBean(String configPath) throws IOException {
        this(CertBean.loadProperties(configPath));
    }

    public CertBean(String trustsFilePath, String sigSM2FilePath, String sigSM2FilePass, String encSM2FilePath, String encSM2FilePass) {
        this.trustsFilePath = trustsFilePath;
        this.sigSM2FilePath = sigSM2FilePath;
        this.sigSM2FilePass = sigSM2FilePass;
        this.encSM2FilePath = encSM2FilePath;
        this.encSM2FilePass = encSM2FilePass;
    }

    public CertBean(Properties properties) {
        if (properties != null) {
            this.trustsFilePath = properties.getProperty("gmssl.trustsFilePath", null);
            this.sigSM2FilePath = properties.getProperty("gmssl.sigSM2FilePath", null);
            this.sigSM2FilePass = properties.getProperty("gmssl.sigSM2FilePass", null);
            this.encSM2FilePath = properties.getProperty("gmssl.encSM2FilePath", null);
            this.encSM2FilePass = properties.getProperty("gmssl.encSM2FilePass", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String configPath) throws IOException {
        Properties properties = new Properties();
        if (configPath != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(configPath));
                properties.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return properties;
    }

    public String getTrustsFilePath() {
        return this.trustsFilePath;
    }

    public CertBean setTrustsFilePath(String trustsFilePath) {
        this.trustsFilePath = trustsFilePath;
        return this;
    }

    public String getSigSM2FilePath() {
        return this.sigSM2FilePath;
    }

    public CertBean setSigSM2FilePath(String sigSM2FilePath) {
        this.sigSM2FilePath = sigSM2FilePath;
        return this;
    }

    public String getSigSM2FilePass() {
        return this.sigSM2FilePass;
    }

    public CertBean setSigSM2FilePass(String sigSM2FilePass) {
        this.sigSM2FilePass = sigSM2FilePass;
        return this;
    }

    public String getEncSM2FilePath() {
        return this.encSM2FilePath;
    }

    public CertBean setEncSM2FilePath(String encSM2FilePath) {
        this.encSM2FilePath = encSM2FilePath;
        return this;
    }

    public String getEncSM2FilePass() {
        return this.encSM2FilePass;
    }

    public CertBean setEncSM2FilePass(String encSM2FilePass) {
        this.encSM2FilePass = encSM2FilePass;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("CertBean [trustsFilePath=");
        builder.append(this.trustsFilePath);
        builder.append(", sigSM2FilePath=");
        builder.append(this.sigSM2FilePath);
        builder.append(", sigSM2FilePass=");
        builder.append("********");
        builder.append(", encSM2FilePath=");
        builder.append(this.encSM2FilePath);
        builder.append(", encSM2FilePass=");
        builder.append("********");
        builder.append("]");
        return builder.toString();
    }
}

