/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.SSLSocketImpl;
import java.io.IOException;
import java.io.InputStream;

final class AppInputStream
extends InputStream {
    private static final byte[] SKIP_ARRAY = new byte[1024];
    private SSLSocketImpl conn;
    InputRecord record;
    private final byte[] oneByte = new byte[1];

    AppInputStream(SSLSocketImpl conn) {
        this.record = new InputRecord();
        this.conn = conn;
    }

    @Override
    public int available() throws IOException {
        if (this.conn.checkEOF() || !this.record.isAppDataValid()) {
            return 0;
        }
        return this.record.available();
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.oneByte, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buffer.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.conn.checkEOF()) {
            return -1;
        }
        try {
            while (this.record.available() == 0) {
                this.conn.readDataRecord(this.record);
                if (!this.conn.checkEOF()) continue;
                return -1;
            }
            int howmany = Math.min(len, this.record.available());
            howmany = this.record.read(buffer, off, howmany);
            return howmany;
        }
        catch (Exception e) {
            if (Debugger.datashaker.isDebugEnabled()) {
                Debugger.datashaker.debug("read record failure", (Throwable)e);
            }
            this.conn.handleException(e);
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int len;
        int r;
        long skipped = 0L;
        while (n > 0L && (r = this.read(SKIP_ARRAY, 0, len = (int)Math.min(n, (long)SKIP_ARRAY.length))) > 0) {
            n -= (long)r;
            skipped += (long)r;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
    }
}

