/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import cfca.sadk.tls.sun.security.util.GMSSLHelper;
import cfca.sadk.tls.util.DeviceConf;
import cfca.sadk.tls.util.Loggings;
import cfca.sadk.tls.util.Version;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public final class JSSEProvider
extends Provider {
    private static final long serialVersionUID = 3231825739635378733L;
    private static String info = "CFCA GMJSSE Provider (GMTLSv1.1-X509/PKIX key/trust factories)";
    public static final Provider INSTANCE = new JSSEProvider();

    public static Provider getInstance() {
        return INSTANCE;
    }

    public JSSEProvider() {
        super("GMJSSE", 1.8, info);
        this.registerAlgorithms();
    }

    private void registerAlgorithms() {
        boolean checkIdentity = GMSSLHelper.isCheckUrlMatchCertIdentity();
        final boolean isTomcat = DeviceConf.isFortomcat();
        Loggings.ENVIRONMENT.info("GMTLSCheckHostIdentity={}", (Object)checkIdentity);
        Loggings.ENVIRONMENT.info("GMTLSVersion: {}, isTomcat={}", (Object)"v3.4.2.0-20210818");
        Loggings.ENVIRONMENT.info("GMTLSForTomcat={}", (Object)isTomcat);
        Loggings.INFO.info("GMTLSCheckHostIdentity={}", (Object)checkIdentity);
        Loggings.INFO.info(Version.version().build());
        Loggings.INFO.info("GMTLSForTomcat={}", (Object)isTomcat);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JSSEProvider.this.doRegister(isTomcat);
                return null;
            }
        });
    }

    private void doRegister(boolean isTomcat) {
        this.put("KeyManagerFactory.GMTX509", "cfca.sadk.tls.sun.security.ssl.manager.GMX509KeyManagerFactory$GMX509Factory");
        this.put("TrustManagerFactory.GMTX509", "cfca.sadk.tls.sun.security.ssl.manager.GMX509TrustManagerFactory$GMPKIXFactory");
        this.put("SSLContext.GMTLSv1.1", "cfca.sadk.tls.sun.security.ssl.SSLContextImpl$TLS11Context");
        if (isTomcat) {
            this.doRegisterForTomcat();
        }
    }

    private void doRegisterForTomcat() {
        this.put("Alg.Alias.KeyManagerFactory.SunX509", "GMTX509");
        this.put("Alg.Alias.KeyManagerFactory.PKIX", "GMTX509");
        this.put("Alg.Alias.TrustManagerFactory.SunX509", "GMTX509");
        this.put("Alg.Alias.TrustManagerFactory.PKIX", "GMTX509");
        this.put("Alg.Alias.SSLContext.Default", "GMTLSv1.1");
        this.put("Alg.Alias.SSLContext.TLS", "GMTLSv1.1");
    }

    public static String getProviderName() {
        return "GMJSSE";
    }

    public static void setCheckUrlMatchCertIdentity(boolean checkUrlMatchCertIdentity) {
        GMSSLHelper.setCheckUrlMatchCertIdentity(checkUrlMatchCertIdentity);
        Loggings.ENVIRONMENT.info("checkUrlMatchCertIdentity={}", (Object)checkUrlMatchCertIdentity);
    }

    public static boolean isCheckUrlMatchCertIdentity() {
        return GMSSLHelper.isCheckUrlMatchCertIdentity();
    }

    public static void setDeviceType(String deviceType) throws PKIException {
        CryptoFactory.singleton().setDeviceType(deviceType);
        Loggings.ENVIRONMENT.info("deviceType={}", (Object)deviceType);
    }

    public static Session getSession() throws PKIException {
        return CryptoFactory.singleton().session();
    }
}

