/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.impl.SM2Encrypt;
import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPremasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHCrypt;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHParams;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;

public abstract class ClientKeyExchange
extends HandshakeMessage {
    @Override
    public final int messageType() {
        return 16;
    }

    public static final class CKESM2DH
    extends ClientKeyExchange {
        private int curveType = 3;
        private byte[] ecParametersBytes;
        private byte[] pointBytes;
        private ECParameterSpec ecParameters;
        private ECPublicKey publicKey;
        boolean hasEcParameters = true;

        public ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        public CKESM2DH(ECPublicKey publicKey) {
            ECParameterSpec params = publicKey.getParameters();
            if (this.hasEcParameters) {
                this.publicKey = publicKey;
                this.ecParameters = publicKey.getParameters();
                this.ecParametersBytes = ECDHParams.getECParametersBytes(this.ecParameters, this.curveType);
            }
            this.pointBytes = ECNamedCurve.encodePoint(publicKey.getQ(), params.getCurve());
        }

        public CKESM2DH(ECDHCrypt ecdh, HandshakeInStream in) throws IOException {
            ByteArrayOutputStream out = null;
            try {
                if (this.hasEcParameters) {
                    out = new ByteArrayOutputStream();
                    this.curveType = in.getInt8();
                    this.ecParameters = ECDHParams.readECParameters(out, this.curveType, in);
                    this.ecParametersBytes = out.toByteArray();
                } else {
                    this.ecParameters = ecdh.getPublicKey().getParameters();
                }
                this.pointBytes = in.getBytes8();
                this.publicKey = new SM2PublicKey(this.pointBytes);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate secret", e);
            }
            finally {
                out = null;
            }
        }

        @Override
        int messageLength() {
            int length = 1 + this.pointBytes.length;
            if (this.hasEcParameters) {
                length += this.ecParametersBytes.length;
            }
            return length;
        }

        @Override
        void send(HandshakeOutStream s) throws IOException {
            if (this.hasEcParameters) {
                s.write(this.ecParametersBytes);
            }
            s.putBytes8(this.pointBytes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            builder.append("*** ECDHClientKeyExchange");
            this.builderAppend(builder, " ECDH Public value:  ", this.pointBytes);
            builder.append("\n***");
            return builder.toString();
        }
    }

    public static final class CKEPKEA
    extends ClientKeyExchange {
        private ProtocolVersion protocolVersion;
        public SecretKey preMasterKey;
        private byte[] encryptedData;

        public CKEPKEA(ProtocolVersion protocolVersion, ProtocolVersion maxVersion, SecureRandom random, PublicKey encryptionKey) throws IOException {
            String algorithm = this.checkKeyAlgorithm(encryptionKey);
            this.protocolVersion = protocolVersion;
            TlsPremasterSecretParameters params = null;
            try {
                params = new TlsPremasterSecretParameters(protocolVersion.major, protocolVersion.minor);
                this.preMasterKey = params.generatePremasterkey(random);
            }
            catch (Exception e) {
                Debugger.handshaker.debug("Error encrypting premaster secret: generatePremasterkey failed", (Throwable)e);
                throw new CryptoException("SM2 premaster secret generate error", e);
            }
            finally {
                params = null;
            }
            if (SM2Helper.isSM2Type(algorithm)) {
                try {
                    this.encryptedData = SM2Encrypt.INSTANCE.encrypt(encryptionKey, this.preMasterKey.getEncoded());
                }
                catch (CryptoException e) {
                    Debugger.handshaker.debug("Error encrypting premaster secret: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            } else {
                Debugger.handshaker.debug("Error encrypting premaster secret: Unknown algorithm =>" + algorithm);
                throw new CryptoException("Unknown algorithm: " + algorithm);
            }
        }

        public CKEPKEA(ProtocolVersion currentVersion, ProtocolVersion maxVersion, SecureRandom random, HandshakeInStream in, int sizeMessage, PrivateKey encryptionKey) throws IOException {
            String algorithm = this.checkKeyAlgorithm(encryptionKey);
            this.encryptedData = in.getBytes16();
            Exception failover = null;
            byte[] decryptedData = null;
            if (SM2Helper.isSM2Type(algorithm)) {
                try {
                    decryptedData = SM2Encrypt.INSTANCE.decrypt(encryptionKey, this.encryptedData);
                }
                catch (CryptoException e) {
                    Debugger.handshaker.debug("Error decrypting premaster secret: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            } else {
                Debugger.handshaker.debug("Error decrypting premaster secret: Unknown algorithm =>" + algorithm);
                throw new CryptoException("Unknown algorithm: " + algorithm);
            }
            this.preMasterKey = this.polishPreMasterSecretKey(currentVersion, maxVersion, random, decryptedData, failover);
        }

        private SecretKey polishPreMasterSecretKey(ProtocolVersion currentVersion, ProtocolVersion clientHelloVersion, SecureRandom random, byte[] decryptedData, Exception failoverException) {
            this.protocolVersion = clientHelloVersion;
            if (random == null) {
                random = new SecureRandom();
            }
            byte[] preMasterKey = new byte[48];
            random.nextBytes(preMasterKey);
            if (failoverException == null && decryptedData != null) {
                if (decryptedData.length != 48) {
                    Debugger.handshaker.debug("incorrect length of premaster secret: {}", (Object)decryptedData.length);
                    return CKEPKEA.generatePreMasterSecret(clientHelloVersion, preMasterKey, random);
                }
                if (clientHelloVersion.major != decryptedData[0] || clientHelloVersion.minor != decryptedData[1]) {
                    if (Debugger.handshaker.isDebugEnabled()) {
                        Debugger.handshaker.debug("Mismatching Protocol Versions,  ClientHello.client_version is {}, while PreMasterSecret.client_version is {}", (Object)clientHelloVersion, (Object)ProtocolVersion.valueOf(decryptedData[0], decryptedData[1]));
                    }
                    decryptedData = preMasterKey;
                }
                return CKEPKEA.generatePreMasterSecret(clientHelloVersion, decryptedData, random);
            }
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("Error decrypting premaster secret:", (Throwable)failoverException);
            }
            return CKEPKEA.generatePreMasterSecret(clientHelloVersion, preMasterKey, random);
        }

        static SecretKey generatePreMasterSecret(ProtocolVersion version, byte[] encodedSecret, SecureRandom random) {
            Debugger.handshaker.debug("Generating a random fake premaster secret");
            TlsPremasterSecretParameters params = null;
            try {
                params = new TlsPremasterSecretParameters(version.major, version.minor, encodedSecret);
                SecretKey secretKey = params.generatePremasterkey(random);
                return secretKey;
            }
            catch (Exception e) {
                if (Debugger.handshaker.isDebugEnabled()) {
                    Debugger.handshaker.debug("SM2 premaster secret generation error:", (Throwable)e);
                }
                throw new RuntimeException("Could not generate dummy secret", e);
            }
            finally {
                params = null;
            }
        }

        private final String checkKeyAlgorithm(Key encryptionKey) throws SSLKeyException {
            String algorithm = encryptionKey.getAlgorithm().toUpperCase();
            String[] algorithms = new String[]{"SM2"};
            boolean found = false;
            for (int i = 0; i < algorithms.length; ++i) {
                if (!algorithms[i].equals(algorithm)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new SSLKeyException("PrivateKey/PublicKey not of type SM2/SM2");
            }
            return algorithm;
        }

        @Override
        int messageLength() {
            return 2 + this.encryptedData.length;
        }

        @Override
        void send(HandshakeOutStream out) throws IOException {
            out.putBytes16(this.encryptedData);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            builder.append("*** ClientKeyExchange, SM2 PreMasterSecret, ");
            builder.append(this.protocolVersion);
            return builder.toString();
        }
    }
}

