/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.util.GMSSLConstants;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmChecker;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorException;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import cfca.sadk.tls.sun.security.validator.TrustAnchorHelper;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class TLSPKIXValidator
extends TLSValidator {
    private final Set<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters params;
    private final PluginValidator plugin;

    TLSPKIXValidator(TLSValidatorVariant variant, Collection<X509Certificate> trustedCerts) {
        super(variant);
        Set<X509Certificate> trusteds = this.buildTrustedCerts(trustedCerts);
        this.params = this.buildBuilderParameters(variant, trustedCerts);
        this.plugin = this.buildPluginValidator(trusteds);
        this.trustedCerts = trusteds;
    }

    TLSPKIXValidator(TLSValidatorVariant variant, PKIXBuilderParameters params) {
        super(variant);
        Set<X509Certificate> trusteds = this.buildTrustedCerts(params);
        this.params = params;
        this.plugin = this.buildPluginValidator(trusteds);
        this.trustedCerts = trusteds;
    }

    @Override
    public final Collection<X509Certificate> getTrustedCertificates() {
        return this.trustedCerts;
    }

    @Override
    X509Certificate[] engineValidate(X509Certificate[] chain, Collection<X509Certificate> additionals, GMAlgorithmConstraints constraints) throws CertificateException {
        X509Certificate[] trustedCerts;
        if (chain == null || chain.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        if (this.params == null) {
            throw new CertificateException("null builder parameters");
        }
        if (this.plugin == null || this.plugin.isEmpty()) {
            throw new CertificateException("plugin is null or the param of plugin missing");
        }
        PKIXBuilderParameters pkixv = (PKIXBuilderParameters)this.params.clone();
        if (constraints != null) {
            pkixv.addCertPathChecker(new GMAlgorithmChecker(constraints));
        }
        if ((trustedCerts = this.checkOrder(chain, additionals, pkixv)) == null) {
            X509Certificate last = chain[chain.length - 1];
            X500Principal issuer = last.getIssuerX500Principal();
            trustedCerts = this.plugin.trustedSubjects.containsKey(issuer) ? this.doValidate(chain, pkixv, this.plugin.factory) : this.buildTrustedCerts(chain, additionals, pkixv);
        }
        return trustedCerts;
    }

    private X509Certificate[] checkOrder(X509Certificate[] chain, Collection<X509Certificate> additionals, PKIXBuilderParameters params) throws CertificateException {
        X500Principal prevIssuer = null;
        X500Principal dn = null;
        X509Certificate[] chainResult = null;
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] == null) continue;
            dn = chain[i].getSubjectX500Principal();
            if (i != 0 && !dn.equals(prevIssuer)) {
                chainResult = this.buildTrustedCerts(chain, additionals, params);
                break;
            }
            if (this.trustedCerts.contains(chain[i]) || this.plugin.contains(dn, chain[i].getPublicKey())) {
                if (i == 0) {
                    chainResult = new X509Certificate[]{chain[0]};
                    break;
                }
                X509Certificate[] newChain = new X509Certificate[i];
                System.arraycopy(chain, 0, newChain, 0, i);
                chainResult = this.doValidate(newChain, params, this.plugin.factory);
                break;
            }
            prevIssuer = chain[i].getIssuerX500Principal();
        }
        return chainResult;
    }

    private final Set<X509Certificate> buildTrustedCerts(Collection<X509Certificate> trustedCerts) {
        HashSet<X509Certificate> localTrustedCerts = null;
        localTrustedCerts = trustedCerts == null ? Collections.emptySet() : (trustedCerts instanceof Set ? (HashSet<X509Certificate>)trustedCerts : new HashSet<X509Certificate>(trustedCerts));
        return localTrustedCerts;
    }

    private final Set<X509Certificate> buildTrustedCerts(PKIXBuilderParameters params) {
        Set<X509Certificate> localTrustedCerts = null;
        if (params == null) {
            localTrustedCerts = Collections.emptySet();
        } else {
            localTrustedCerts = new HashSet();
            for (TrustAnchor anchor : params.getTrustAnchors()) {
                X509Certificate cert;
                if (anchor == null || (cert = anchor.getTrustedCert()) == null) continue;
                localTrustedCerts.add(cert);
            }
        }
        return localTrustedCerts;
    }

    private final PKIXBuilderParameters buildBuilderParameters(TLSValidatorVariant variant, Collection<X509Certificate> trustedCerts) {
        Set<TrustAnchor> trustedAnchors = null;
        if (trustedCerts == null) {
            trustedAnchors = Collections.emptySet();
        } else {
            trustedAnchors = new HashSet();
            for (X509Certificate cert : trustedCerts) {
                if (cert == null) continue;
                trustedAnchors.add(new TrustAnchor(cert, null));
            }
        }
        PKIXBuilderParameters params = null;
        try {
            params = new PKIXBuilderParameters(trustedAnchors, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Unexpected error: " + e.toString(), e);
        }
        if (variant == TLSValidatorVariant.TLS_SERVER || variant == TLSValidatorVariant.TLS_CLIENT) {
            params.setRevocationEnabled(GMSSLConstants.checkTLSRevocation);
        } else {
            params.setRevocationEnabled(false);
        }
        return params;
    }

    private final PluginValidator buildPluginValidator(Set<X509Certificate> trustedCerts) {
        PluginValidator plugin = new PluginValidator();
        plugin.trustedSubjects = this.buildTrustedSubjects(trustedCerts);
        plugin.factory = this.buildCertificateFactory();
        return plugin;
    }

    private final CertificateFactory buildCertificateFactory() {
        try {
            return JSSEJCE.getCertificateFactory("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    private final Map<X500Principal, List<PublicKey>> buildTrustedSubjects(Collection<X509Certificate> trustedCerts) {
        Map<X500Principal, List<PublicKey>> trustedSubjects = null;
        if (trustedCerts == null) {
            trustedSubjects = Collections.emptyMap();
        } else {
            trustedSubjects = new HashMap();
            List<Object> keys = null;
            X500Principal dn = null;
            for (X509Certificate cert : trustedCerts) {
                if (cert == null) continue;
                dn = cert.getSubjectX500Principal();
                if (trustedSubjects.containsKey(dn)) {
                    keys = trustedSubjects.get(dn);
                } else {
                    keys = new ArrayList();
                    trustedSubjects.put(dn, keys);
                }
                keys.add(cert.getPublicKey());
            }
        }
        return trustedSubjects;
    }

    private final X509Certificate[] doValidate(X509Certificate[] chain, PKIXBuilderParameters params, CertificateFactory factory) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new TLSValidatorException("PKIX path building failed: null or zero-length certificate chain");
        }
        if (factory == null) {
            throw new TLSValidatorException("PKIX path building failed: null certificate factory");
        }
        try {
            params.setDate(new Date());
            CertPath path = factory.generateCertPath(Arrays.asList(chain));
            List<? extends Certificate> certs = path.getCertificates();
            TrustAnchor trustAnchors = TrustAnchorHelper.findTrustAnchor((X509Certificate)certs.get(certs.size() - 1), params.getTrustAnchors());
            return TrustAnchorHelper.toArray(path, trustAnchors);
        }
        catch (Exception e) {
            throw new TLSValidatorException("PKIX path validation failed: " + e.toString(), e);
        }
    }

    private final X509Certificate[] buildTrustedCerts(X509Certificate[] chain, Collection<X509Certificate> additionals, PKIXBuilderParameters params) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new TLSValidatorException("PKIX path building failed: null or zero-length certificate chain");
        }
        try {
            X509Certificate peerCert = chain[0];
            params.setDate(new Date());
            params.setTargetCertConstraints(this.buildSelector(peerCert));
            params.addCertStore(this.buildStore(chain, additionals));
            TrustAnchor trustAnchors = TrustAnchorHelper.findTrustAnchor(peerCert, params.getTrustAnchors());
            if (trustAnchors == null) {
                throw new TLSValidatorException("findTrustAnchor failed: TrustAnchor is null! IssuerDN= " + peerCert.getIssuerDN());
            }
            return TrustAnchorHelper.toArray(chain, trustAnchors);
        }
        catch (Exception e) {
            throw new TLSValidatorException("PKIX path building failed: " + e.toString(), e);
        }
    }

    private X509CertSelector buildSelector(X509Certificate cert) {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        return selector;
    }

    private CertStore buildStore(X509Certificate[] chain, Collection<X509Certificate> additionals) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.addAll(Arrays.asList(chain));
        if (additionals != null) {
            certs.addAll(additionals);
        }
        CertStore store = JSSEJCE.getCertStore("Collection", new CollectionCertStoreParameters(certs));
        return store;
    }

    static final class PluginValidator {
        Map<X500Principal, List<PublicKey>> trustedSubjects;
        CertificateFactory factory;

        PluginValidator() {
        }

        boolean isEmpty() {
            return this.trustedSubjects == null || this.factory == null;
        }

        boolean contains(X500Principal dn, PublicKey publicKey) {
            List<PublicKey> values = this.trustedSubjects.get(dn);
            return values != null && values.contains(publicKey);
        }
    }
}

