/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.core.joran.spi;

import cfca.ch.qos.logback.classic.joran.action.ConfigurationAction;
import java.io.IOException;
import java.io.OutputStream;

public enum ConsoleTarget {
    SystemOut("System.out", new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.write(b);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            System.out.flush();
        }
    }),
    SystemErr("System.err", new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.err.write(b);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.err.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.err.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            System.err.flush();
        }
    });

    private final String name;
    private final OutputStream stream;

    public static ConsoleTarget findByName(String name) {
        ConsoleTarget[] consoleTargetArray = ConsoleTarget.values();
        int n = consoleTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleTarget target = consoleTargetArray[n2];
            if (target.name.equalsIgnoreCase(name)) {
                return target;
            }
            ++n2;
        }
        return null;
    }

    private ConsoleTarget(String name, OutputStream stream) {
        this.name = name;
        this.stream = stream;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return this.name;
    }
}

