/*
 * Decompiled with CFR 0.152.
 */
package cfca.internal.tool;

import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.x509.certificate.X509Cert;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class P7b {
    private static ContentInfo generateP7b(X509Cert[] certs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        DERSet certSet = new DERSet(v);
        DERSet algs = new DERSet();
        DERSet signerInfos = new DERSet();
        ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.data, null);
        SignedData signedData = new SignedData(new ASN1Integer(1), algs, ci, certSet, null, signerInfos);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return contentInfo;
    }

    public static void generateP7bFile(X509Cert[] certs, String fileName) throws PKIException {
        if (certs == null) {
            throw new IllegalArgumentException("null not allowed for certs");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null not allowed for fileName");
        }
        ContentInfo contentInfo = P7b.generateP7b(certs);
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            fos = new FileOutputStream(fileName);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfo.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException("850600", "\u4ea7\u751fP7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", ex);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static X509Cert[] parseP7b(byte[] p7bData) throws PKIException {
        if (ASN1Parser.isBase64Encode(p7bData)) {
            p7bData = Base64.decode(p7bData);
        }
        if (p7bData[0] != 48) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25", new Exception("The P7B certification chain content error."));
        }
        ASN1Sequence sequence = (ASN1Sequence)ASN1Parser.writeBytes2DERObj(p7bData);
        ContentInfo contentInfo = ContentInfo.getInstance(sequence);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PKIException("850601", "\u89e3\u6790P7B\u8bc1\u4e66\u94fe\u7ed3\u6784\u5931\u8d25 \u8bc1\u4e66\u94fe\u7c7b\u578b\u4e0d\u5339\u914d " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        ASN1Set certSet = signedData.getCertificates();
        Enumeration enumeration = certSet.getObjects();
        Vector<X509Cert> v = new Vector<X509Cert>();
        X509Cert cert = null;
        while (enumeration.hasMoreElements()) {
            Certificate certStruc = Certificate.getInstance(enumeration.nextElement());
            cert = new X509Cert(certStruc);
            v.add(cert);
        }
        X509Cert[] certs = new X509Cert[v.size()];
        v.toArray(certs);
        return certs;
    }
}

