/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.cmp;

import cfca.org.bouncycastle.asn1.cmp.CertStatus;
import cfca.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cert.cmp.CMPException;
import cfca.org.bouncycastle.cert.cmp.CMPUtil;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DigestCalculator;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digester;
        AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
        if (digAlg == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digester = digesterProvider.get(digAlg);
        }
        catch (OperatorCreationException e) {
            throw new CMPException("unable to create digester: " + e.getMessage(), e);
        }
        CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digester.getDigest());
    }
}

