/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BEROctetStringGenerator;
import cfca.org.bouncycastle.asn1.BERSet;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.bouncycastle.asn1.x509.CertificateList;
import cfca.org.bouncycastle.asn1.x509.TBSCertificateStructure;
import cfca.org.bouncycastle.asn1.x509.X509CertificateStructure;
import cfca.org.bouncycastle.cert.X509AttributeCertificateHolder;
import cfca.org.bouncycastle.cert.X509CRLHolder;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.NullOutputStream;
import cfca.org.bouncycastle.cms.SignerInfoGenerator;
import cfca.org.bouncycastle.operator.DigestCalculator;
import cfca.org.bouncycastle.util.Store;
import cfca.org.bouncycastle.util.io.Streams;
import cfca.org.bouncycastle.util.io.TeeInputStream;
import cfca.org.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class CMSUtils {
    CMSUtils() {
    }

    static ContentInfo readContentInfo(byte[] input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static ContentInfo readContentInfo(InputStream input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static List getCertificatesFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<X509CertificateStructure> certs = new ArrayList<X509CertificateStructure>();
        try {
            for (X509Certificate x509Certificate : certStore.getCertificates(null)) {
                certs.add(X509CertificateStructure.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            return certs;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing certs", e);
        }
        catch (IOException e) {
            throw new CMSException("error processing certs", e);
        }
        catch (CertificateEncodingException e) {
            throw new CMSException("error encoding certs", e);
        }
    }

    static List getCertificatesFromStore(Store certStore) throws CMSException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            for (X509CertificateHolder c : certStore.getMatches(null)) {
                certs.add(c.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getAttributeCertificatesFromStore(Store attrStore) throws CMSException {
        ArrayList<DERTaggedObject> certs = new ArrayList<DERTaggedObject>();
        try {
            for (X509AttributeCertificateHolder attrCert : attrStore.getMatches(null)) {
                certs.add(new DERTaggedObject(false, 2, attrCert.toASN1Structure()));
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getCRLsFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<CertificateList> crls = new ArrayList<CertificateList>();
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                crls.add(CertificateList.getInstance(ASN1Primitive.fromByteArray(x509CRL.getEncoded())));
            }
            return crls;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing crls", e);
        }
        catch (IOException e) {
            throw new CMSException("error processing crls", e);
        }
        catch (CRLException e) {
            throw new CMSException("error encoding crls", e);
        }
    }

    static List getCRLsFromStore(Store crlStore) throws CMSException {
        ArrayList<CertificateList> certs = new ArrayList<CertificateList>();
        try {
            for (X509CRLHolder c : crlStore.getMatches(null)) {
                certs.add(c.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new BERSet(v);
    }

    static ASN1Set createDerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new DERSet(v);
    }

    static OutputStream createBEROctetOutputStream(OutputStream s, int tagNo, boolean isExplicit, int bufferSize) throws IOException {
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(s, tagNo, isExplicit);
        if (bufferSize != 0) {
            return octGen.getOctetOutputStream(new byte[bufferSize]);
        }
        return octGen.getOctetOutputStream();
    }

    static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) {
        try {
            return TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't extract TBS structure from this cert");
        }
    }

    static IssuerAndSerialNumber getIssuerAndSerialNumber(X509Certificate cert) {
        TBSCertificateStructure tbsCert = CMSUtils.getTBSCertificateStructure(cert);
        return new IssuerAndSerialNumber(tbsCert.getIssuer(), tbsCert.getSerialNumber().getValue());
    }

    private static ContentInfo readContentInfo(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance(in.readObject());
        }
        catch (IOException e) {
            throw new CMSException("IOException reading content.", e);
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        return Streams.readAll(in);
    }

    public static byte[] streamToByteArray(InputStream in, int limit) throws IOException {
        return Streams.readAllLimited(in, limit);
    }

    public static Provider getProvider(String providerName) throws NoSuchProviderException {
        if (providerName != null) {
            Provider prov = Security.getProvider(providerName);
            if (prov != null) {
                return prov;
            }
            throw new NoSuchProviderException("provider " + providerName + " not found.");
        }
        return null;
    }

    static InputStream attachDigestsToInputStream(Collection digests, InputStream s) {
        InputStream result = s;
        for (DigestCalculator digest : digests) {
            result = new TeeInputStream(result, digest.getOutputStream());
        }
        return result;
    }

    static OutputStream attachSignersToOutputStream(Collection signers, OutputStream s) {
        OutputStream result = s;
        for (SignerInfoGenerator signerGen : signers) {
            result = CMSUtils.getSafeTeeOutputStream(result, signerGen.getCalculatingOutputStream());
        }
        return result;
    }

    static OutputStream getSafeOutputStream(OutputStream s) {
        return s == null ? new NullOutputStream() : s;
    }

    static OutputStream getSafeTeeOutputStream(OutputStream s1, OutputStream s2) {
        return s1 == null ? CMSUtils.getSafeOutputStream(s2) : (s2 == null ? CMSUtils.getSafeOutputStream(s1) : new TeeOutputStream(s1, s2));
    }
}

