/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.cms.Attribute;
import cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.org.bouncycastle.cms.CMSAttributeTableGenerator;
import java.util.Hashtable;
import java.util.Map;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = (Hashtable)this.table.clone();
        if (!std.containsKey(CMSAttributes.contentType)) {
            DERObjectIdentifier contentType = (DERObjectIdentifier)parameters.get("contentType");
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

