/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.cms.KeyTransRecipientId;
import cfca.org.bouncycastle.cms.RecipientId;
import cfca.org.bouncycastle.cms.RecipientInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecipientInformationStore {
    private final List all;
    private final Map table = new HashMap();

    public RecipientInformationStore(Collection recipientInfos) {
        for (RecipientInformation recipientInformation : recipientInfos) {
            RecipientId rid = recipientInformation.getRID();
            ArrayList<RecipientInformation> list = (ArrayList<RecipientInformation>)this.table.get(rid);
            if (list == null) {
                list = new ArrayList<RecipientInformation>(1);
                this.table.put(rid, list);
            }
            list.add(recipientInformation);
        }
        this.all = new ArrayList(recipientInfos);
    }

    public RecipientInformation get(RecipientId selector) {
        Collection list = this.getRecipients(selector);
        return list.size() == 0 ? null : (RecipientInformation)list.iterator().next();
    }

    public int size() {
        return this.all.size();
    }

    public Collection getRecipients() {
        return new ArrayList(this.all);
    }

    public Collection getRecipients(RecipientId selector) {
        if (selector instanceof KeyTransRecipientId) {
            KeyTransRecipientId keyTrans = (KeyTransRecipientId)selector;
            byte[] subjectKeyId = keyTrans.getSubjectKeyIdentifier();
            if (keyTrans.getIssuer() != null && subjectKeyId != null) {
                Collection match2;
                ArrayList results = new ArrayList();
                Collection match1 = this.getRecipients(new KeyTransRecipientId(keyTrans.getIssuer(), keyTrans.getSerialNumber()));
                if (match1 != null) {
                    results.addAll(match1);
                }
                if ((match2 = this.getRecipients(new KeyTransRecipientId(subjectKeyId))) != null) {
                    results.addAll(match2);
                }
                return results;
            }
            ArrayList list = (ArrayList)this.table.get(selector);
            return list == null ? new ArrayList() : new ArrayList(list);
        }
        ArrayList list = (ArrayList)this.table.get(selector);
        return list == null ? new ArrayList() : new ArrayList(list);
    }
}

