/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import cfca.org.bouncycastle.crypto.AsymmetricBlockCipher;
import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import cfca.org.bouncycastle.crypto.encodings.OAEPEncoding;
import cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.util.BaseCipherSpi;
import cfca.org.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherSpi
extends BaseCipherSpi {
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameters engineParams;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public CipherSpi(AsymmetricBlockCipher engine) {
        this.cipher = engine;
    }

    public CipherSpi(boolean publicKeyOnly, boolean privateKeyOnly, AsymmetricBlockCipher engine) {
        this.publicKeyOnly = publicKeyOnly;
        this.privateKeyOnly = privateKeyOnly;
        this.cipher = engine;
    }

    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return k.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return k.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }

    protected int engineGetOutputSize(int inputLen) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.engineParams;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String md = Strings.toUpperCase(mode);
        if (md.equals("NONE") || md.equals("ECB")) {
            return;
        }
        if (md.equals("1")) {
            this.privateKeyOnly = true;
            this.publicKeyOnly = false;
            return;
        }
        if (md.equals("2")) {
            this.privateKeyOnly = false;
            this.publicKeyOnly = true;
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String pad = Strings.toUpperCase(padding);
        if (pad.equals("NOPADDING")) {
            this.cipher = new RSABlindedEngine();
        } else if (pad.equals("PKCS1PADDING")) {
            this.cipher = new PKCS1Encoding(new RSABlindedEngine());
        } else if (pad.equals("ISO9796-1PADDING")) {
            this.cipher = new ISO9796d1Encoding(new RSABlindedEngine());
        } else if (pad.equals("OAEPPADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine());
        } else if (pad.equals("OAEPWITHSHA1ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine());
        } else if (pad.equals("OAEPWITHSHA224ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA224Digest());
        } else if (pad.equals("OAEPWITHSHA256ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA256Digest());
        } else if (pad.equals("OAEPWITHSHA384ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA384Digest());
        } else if (pad.equals("OAEPWITHSHA512ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA512Digest());
        } else if (pad.equals("OAEPWITHMD5ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new MD5Digest());
        } else {
            throw new NoSuchPaddingException(padding + " unavailable with RSA.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) throw new IllegalArgumentException("unknown parameter type.");
        if (key instanceof RSAPublicKey) {
            if (this.privateKeyOnly && opmode == 1) {
                throw new InvalidKeyException("mode 1 requires RSAPrivateKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)key);
        } else {
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("unknown key type passed to RSA");
            if (this.publicKeyOnly && opmode == 1) {
                throw new InvalidKeyException("mode 2 requires RSAPublicKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)key);
        }
        if (!(this.cipher instanceof RSABlindedEngine)) {
            void var5_7;
            if (random != null) {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, random);
            } else {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, new SecureRandom());
            }
        }
        switch (opmode) {
            case 1: 
            case 3: {
                void var5_10;
                this.cipher.init(true, (CipherParameters)var5_10);
                return;
            }
            case 2: 
            case 4: {
                void var5_10;
                this.cipher.init(false, (CipherParameters)var5_10);
                return;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + opmode + " passed to RSA");
            }
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            throw new InvalidAlgorithmParameterException("cannot recognise parameters.");
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Eeeek! " + e.toString());
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            out = this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        for (int i = 0; i != out.length; ++i) {
            output[outputOffset + i] = out[i];
        }
        return out.length;
    }

    public static class ISO9796d1Padding
    extends CipherSpi {
        public ISO9796d1Padding() {
            super(new ISO9796d1Encoding(new RSABlindedEngine()));
        }
    }

    public static class OAEPPadding
    extends CipherSpi {
        public OAEPPadding() {
            super(new OAEPEncoding(new RSABlindedEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PublicOnly
    extends CipherSpi {
        public PKCS1v1_5Padding_PublicOnly() {
            super(true, false, new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PrivateOnly
    extends CipherSpi {
        public PKCS1v1_5Padding_PrivateOnly() {
            super(false, true, new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class PKCS1v1_5Padding
    extends CipherSpi {
        public PKCS1v1_5Padding() {
            super(new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class NoPadding
    extends CipherSpi {
        public NoPadding() {
            super(new RSABlindedEngine());
        }
    }
}

