/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.pkcs.bc;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.crypto.ExtendedDigest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.operator.MacCalculator;
import cfca.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import cfca.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import cfca.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProviderBuilder
implements PKCS12MacCalculatorBuilderProvider {
    private ExtendedDigest digest;
    private AlgorithmIdentifier digestAlgorithmIdentifier;

    public BcPKCS12MacCalculatorBuilderProviderBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE));
    }

    public BcPKCS12MacCalculatorBuilderProviderBuilder(ExtendedDigest digest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = digest;
        this.digestAlgorithmIdentifier = algorithmIdentifier;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] password) {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProviderBuilder.this.digest, pbeParams, password);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier;
            }
        };
    }
}

