/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.apple.pay;

import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.crypto.ExtendedDigest;
import cfca.org.bouncycastle.crypto.Signer;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.crypto.signers.DSADigestSigner;
import cfca.org.bouncycastle.crypto.signers.ECDSASigner;
import cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import cfca.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import java.io.IOException;

class BcECDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    BcECDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = BcDefaultDigestProvider.INSTANCE.get(digAlg);
        return new DSADigestSigner(new ECDSASigner(), dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

