/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm.algorithm;

import cfca.org.bouncycastle.crypto.Digest;
import cfca.sm.algorithm.SM3;

public class SM3Digest
implements Digest {
    private byte[] buffer = new byte[64];
    private int offset;
    private byte[] value;
    private int cntBlock;

    public SM3Digest() {
        this.offset = 0;
        this.value = (byte[])SM3.iv.clone();
        this.cntBlock = 0;
    }

    public SM3Digest(SM3Digest dig) {
        this.value = (byte[])SM3.iv.clone();
        this.cntBlock = 0;
        System.arraycopy(dig.buffer, 0, this.buffer, 0, dig.buffer.length);
        this.offset = dig.offset;
        System.arraycopy(dig.value, 0, this.value, 0, dig.value.length);
        this.cntBlock = dig.cntBlock;
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] buffer = this.doFinal();
        System.arraycopy(buffer, 0, out, 0, buffer.length);
        return 32;
    }

    public void reset() {
        this.offset = 0;
        this.cntBlock = 0;
        this.value = (byte[])SM3.iv.clone();
    }

    public void update(byte[] in, int inOff, int len) {
        if (in == null) {
            throw new IllegalArgumentException("null not allowed for in");
        }
        int partLen = 64 - this.offset;
        int inputLen = len;
        int dPos = inOff;
        if (partLen < inputLen) {
            System.arraycopy(in, dPos, this.buffer, this.offset, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.buffer, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(in, dPos, this.buffer, this.offset, inputLen);
        this.offset += inputLen;
    }

    private void doUpdate() {
        byte[] block = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.buffer, i, block, 0, block.length);
            this.doHash(block);
        }
        this.offset = 0;
    }

    private void doHash(byte[] B) {
        byte[] hash = SM3.CF(this.value, B);
        System.arraycopy(hash, 0, this.value, 0, this.value.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] block = new byte[64];
        byte[] bytes = new byte[this.offset];
        System.arraycopy(this.buffer, 0, bytes, 0, bytes.length);
        byte[] padding = SM3.padding(bytes, this.cntBlock);
        for (int i = 0; i < padding.length; i += 64) {
            System.arraycopy(padding, i, block, 0, block.length);
            this.doHash(block);
        }
        byte[] value = (byte[])this.value.clone();
        this.reset();
        return value;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }
}

