/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.BigFileDecrypt;
import cfca.asn1.parser.EnvelopFileParser;
import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.rsa.envelope.RSAEnvelopeUtil;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2.envelope.SM2EnvelopeUtil;
import cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCS7EnvelopedData;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.system.SM2Compatible;
import cfca.util.Base64;
import cfca.util.cipher.lib.BCSoftLib;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;

public class EnvelopeUtil {
    public static final int recipient_policy_requiredSubjectKeyId = 0;
    public static final int recipient_policy_useSubjectKeyIdExt = 1;
    public static final int recipient_policy_useIssuerAndSerialNumber = 2;
    static final Logger logger;

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeMessage>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
            buffer.append("\n receiverCerts: ");
            buffer.append(Debugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            logger.debug(buffer.toString());
        }
        try {
            if (sourceData == null || sourceData.length <= 0) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (symmetricAlgorithm == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (receiverCerts == null || receiverCerts.length == 0 || receiverCerts[0] == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: receiverCerts");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                byte[] base64EnvelopeMessage = null;
                if (receiverCerts[0].isSM2Cert()) {
                    logger.debug("envelopeMessage::::::SM2EnvelopeMessage");
                    base64EnvelopeMessage = SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                } else if (receiverCerts[0].isRSACert()) {
                    logger.debug("envelopeMessage::::::RSAEnvelopeMessage");
                    base64EnvelopeMessage = RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                } else {
                    throw new PKIException("851201", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: receiverCerts[RSA/SM2]");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("envelopeMessage<<<<<<Finished: base64EnvelopeMessage=" + Debugger.dumpBase64(base64EnvelopeMessage));
                }
                return base64EnvelopeMessage;
            }
            catch (Exception e) {
                throw new PKIException("851210", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("envelopeMessage>>>>>>Failure");
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
                buffer.append("\n receiverCerts: ");
                buffer.append(Debugger.dump(receiverCerts));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeFile>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(Debugger.dump(encryptFilePath));
            buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
            buffer.append("\n receiverCerts: ");
            buffer.append(Debugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            logger.debug(buffer.toString());
        }
        try {
            if (sourceFilePath == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (encryptFilePath == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: encryptFilePath");
            }
            if (symmetricAlgorithm == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (receiverCerts == null || receiverCerts.length == 0 || receiverCerts[0] == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: receiverCerts");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            File srcFile = new File(sourceFilePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("851220", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u7684\u6587\u4ef6");
            }
            try {
                if (receiverCerts[0].isSM2Cert()) {
                    logger.debug("envelopeFile::::::SM2EnvelopeFile");
                    SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                } else if (receiverCerts[0].isRSACert()) {
                    logger.debug("envelopeFile::::::RSAEnvelopeFile");
                    RSAEnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                } else {
                    throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: receiverCerts[RSA/SM2]");
                }
                logger.debug("envelopeFile<<<<<<Finished: binaryEnvelopeFile=" + encryptFilePath);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851210", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("envelopeFile<<<<<<Failure");
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n encryptFilePath: ");
                buffer.append(Debugger.dump(encryptFilePath));
                buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
                buffer.append("\n receiverCerts: ");
                buffer.append(Debugger.dump(receiverCerts));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static byte[] envelopeMS(byte[] sourceData, String signAlg, PrivateKey signPriKey, X509Cert signCert, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, boolean sm2WithZFlag) throws PKIException {
        return EnvelopeUtil.envelopeMS(sourceData, signAlg, signPriKey, signCert, symmetricAlgorithm, receiverCerts, session, sm2WithZFlag, 0);
    }

    public static byte[] envelopeMS(byte[] sourceData, String signAlg, PrivateKey signPriKey, X509Cert signCert, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, boolean sm2WithZFlag, int recipientPolicyType) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeMS>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n signAlg: " + signAlg);
            buffer.append("\n signPriKey: ");
            buffer.append(Debugger.dump(signPriKey));
            buffer.append("\n signCert: ");
            buffer.append(Debugger.dump(signCert));
            buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
            buffer.append("\n receiverCerts: ");
            buffer.append(Debugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            logger.debug(buffer.toString());
        }
        try {
            byte[] signData;
            if (sourceData == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (signAlg == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (signPriKey == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signPriKey");
            }
            if (signCert == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signCert");
            }
            if (symmetricAlgorithm == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (receiverCerts == null || receiverCerts.length == 0) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: receiverCerts");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                StringBuffer buffer;
                PKCS7SignedData2 p7 = new PKCS7SignedData2(session);
                X509Cert[] certs = new X509Cert[]{signCert};
                Mechanism mechanism = new Mechanism(signAlg);
                byte[] signture = session.sign(mechanism, signPriKey, sourceData, sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("envelopeMS::::::p7SignMessageAttach, signture=");
                    buffer.append(Debugger.dump(signture));
                    logger.debug(buffer.toString());
                }
                signData = p7.packageSignedData(true, null, sourceData, signture, mechanism, certs);
                if (logger.isDebugEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("envelopeMS::::::p7SignMessageAttach, signedData=");
                    buffer.append(Debugger.dump(signData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851212", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                byte[] base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(signData, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("envelopeMS<<<<<<EnvelopeMessage, base64EnvelopeMessage=");
                    buffer.append(Debugger.dumpBase64(base64EnvelopeMessage));
                    logger.debug(buffer.toString());
                }
                return base64EnvelopeMessage;
            }
            catch (Exception e) {
                throw new PKIException("851210", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("envelopeMS<<<<<<Failure");
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n signAlg: " + signAlg);
                buffer.append("\n signPriKey: ");
                buffer.append(Debugger.dump(signPriKey));
                buffer.append("\n signCert: ");
                buffer.append(Debugger.dump(signCert));
                buffer.append("\n symmetricAlgorithm: " + symmetricAlgorithm);
                buffer.append("\n receiverCerts: ");
                buffer.append(Debugger.dump(receiverCerts));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static final byte[] openEvelopedMessage(byte[] base64EnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEvelopedMessage>>>>>>Running");
            buffer.append("\n base64EnvelopedData: ");
            buffer.append(Debugger.dump(base64EnvelopedData));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(privateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(Debugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (base64EnvelopedData == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64EnvelopedData");
            }
            if (privateKey == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: privateKey");
            }
            if (recipientCert == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recipientCert");
            }
            if (!recipientCert.isSM2Cert() && !recipientCert.isRSACert()) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recipientCert[RSA/SM2]");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                StringBuffer buffer;
                byte[] bEnvelop = null;
                boolean isSM2Type = recipientCert.isSM2Cert();
                bEnvelop = ASN1Parser.isBase64Encode(base64EnvelopedData) ? Base64.decode(base64EnvelopedData) : base64EnvelopedData;
                CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
                ContentInfo info = cmsEnData.toASN1Structure();
                EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
                ASN1Set receivers = enData.getRecipientInfos();
                byte[] symmetricKey = EnvelopeUtil.checkRecipientsAndSymmetricKey(isSM2Type, privateKey, recipientCert, receivers, session);
                EncryptedContentInfo data = enData.getEncryptedContentInfo();
                AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
                Mechanism mechanism = EnvelopeUtil.buildMechanism(symmetricAlgId);
                byte[] encryptedBytes = data.getEncryptedContent().getOctets();
                byte[] sourceData = null;
                if (isSM2Type) {
                    if (logger.isDebugEnabled()) {
                        buffer = new StringBuffer();
                        buffer.append("openEvelopedMessage::::::SM2Decrypt");
                        buffer.append(",symmetricKey=");
                        buffer.append(Debugger.dump(symmetricKey));
                        buffer.append(",mechanism=");
                        buffer.append(Debugger.dump(mechanism));
                        logger.debug(buffer.toString());
                    }
                    sourceData = SM2SymmetricCryptoUtil.cryptoUtil(false, symmetricKey, encryptedBytes, mechanism);
                } else {
                    if (logger.isDebugEnabled()) {
                        buffer = new StringBuffer();
                        buffer.append("openEvelopedMessage::::::RSADecrypt");
                        buffer.append(",symmetricKey=");
                        buffer.append(Debugger.dump(symmetricKey));
                        buffer.append(",mechanism=");
                        buffer.append(Debugger.dump(mechanism));
                        logger.debug(buffer.toString());
                    }
                    sourceData = RSASymmetricCryptoUtil.decrypt(symmetricKey, encryptedBytes, mechanism);
                }
                if (logger.isDebugEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("openEvelopedMessage<<<<<<sourceData=");
                    buffer.append(Debugger.dump(sourceData));
                    logger.debug(buffer.toString());
                }
                return sourceData;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851211", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("openEvelopedMessage<<<<<<Failure");
                buffer.append("\n base64EnvelopedData: ");
                buffer.append(Debugger.dump(base64EnvelopedData));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(privateKey));
                buffer.append("\n recipientCert: ");
                buffer.append(Debugger.dump(recipientCert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static final void openEnvelopedFile(String envelopedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEnvelopedFile>>>>>>Running");
            buffer.append("\n envelopedFilePath: ");
            buffer.append(Debugger.dump(envelopedFilePath));
            buffer.append("\n plainTextFilePath: ");
            buffer.append(Debugger.dump(plainTextFilePath));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(privateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(Debugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (envelopedFilePath == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: envelopedFilePath");
            }
            if (plainTextFilePath == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: plainTextFilePath");
            }
            if (privateKey == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: privateKey");
            }
            if (recipientCert == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recipientCert");
            }
            if (!recipientCert.isSM2Cert() && !recipientCert.isRSACert()) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recipientCert[RSA/SM2]");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            FileOutputStream fos = null;
            FilterOutputStream out = null;
            try {
                EnvelopFileParser parser = new EnvelopFileParser(new File(envelopedFilePath));
                parser.parser();
                ASN1Node receiver_node = parser.getReceiver_node();
                ASN1Node encrypted_node = parser.getEncrypted_node();
                boolean isSM2Type = recipientCert.isSM2Cert();
                ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
                byte[] symmetricKey = EnvelopeUtil.checkRecipientsAndSymmetricKey(isSM2Type, privateKey, recipientCert, receivers, session);
                ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
                byte[] symmetricAlg_byte = symmetric_encrypted.getData();
                AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
                Mechanism mechanism = EnvelopeUtil.buildMechanism(symmetricAlgId);
                File plainTextFile = new File(plainTextFilePath);
                if (!plainTextFile.exists()) {
                    plainTextFile.createNewFile();
                }
                fos = new FileOutputStream(plainTextFile);
                out = new BufferedOutputStream(fos, GlobalVariable.BIG_FILE_BUFFER);
                if (isSM2Type) {
                    if (logger.isDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("openEnvelopedFile::::::SM2Decrypt Running");
                        buffer.append(",symmetricKey=");
                        buffer.append(Debugger.dump(symmetricKey));
                        buffer.append(",mechanism=");
                        buffer.append(Debugger.dump(mechanism));
                        logger.debug(buffer.toString());
                    }
                    ASN1Node encryptedNode = (ASN1Node)encrypted_node.childNodes.get(2);
                    if (encryptedNode.childNodes.size() == 1) {
                        encryptedNode = (ASN1Node)encryptedNode.childNodes.get(0);
                    }
                    BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new SM4Engine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
                    logger.debug("openEnvelopedFile::::::SM2Decrypt Finished.");
                } else {
                    if (logger.isDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("openEnvelopedFile::::::RSADecrypt Running");
                        buffer.append(",symmetricKey=");
                        buffer.append(Debugger.dump(symmetricKey));
                        buffer.append(",mechanism=");
                        buffer.append(Debugger.dump(mechanism));
                        logger.debug(buffer.toString());
                    }
                    ASN1Node encryptedNode = (ASN1Node)encrypted_node.childNodes.get(2);
                    if (encryptedNode.childNodes.size() == 0) {
                        logger.debug("openEnvelopedFile::::::DEREncoding");
                        if (mechanism.getMechanismType().equals("RC4")) {
                            logger.debug("openEnvelopedFile::::::DEREncoding#RC4");
                            BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, encryptedNode, out);
                        } else {
                            logger.debug("openEnvelopedFile::::::DEREncoding#DESede");
                            BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
                        }
                    } else if (encryptedNode.childNodes.size() == 1) {
                        logger.debug("openEnvelopedFile::::::BEREncoding");
                        encryptedNode = (ASN1Node)encryptedNode.childNodes.get(0);
                        if (mechanism.getMechanismType().equals("RC4")) {
                            logger.debug("openEnvelopedFile::::::BEREncoding#RC4");
                            BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, encryptedNode, out);
                        } else {
                            logger.debug("openEnvelopedFile::::::BEREncoding#DESede");
                            BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
                        }
                    } else {
                        logger.debug("openEnvelopedFile::::::MSEncoding");
                        EnvelopeUtil.DecryptMicrosoftFile(mechanism, symmetricKey, encryptedNode, (BufferedOutputStream)out);
                    }
                    logger.debug("openEnvelopedFile::::::RSADecrypt Finished.");
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851211", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("openEnvelopedFile>>>>>>Running");
                buffer.append("\n envelopedFilePath: ");
                buffer.append(Debugger.dump(envelopedFilePath));
                buffer.append("\n plainTextFilePath: ");
                buffer.append(Debugger.dump(plainTextFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(privateKey));
                buffer.append("\n recipientCert: ");
                buffer.append(Debugger.dump(recipientCert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static byte[] openEnvelopedMS(byte[] base64P7SignedDataAndEnvelopedData, PrivateKey recvPriKey, X509Cert recvCert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEnvelopedMS>>>>>>Running");
            buffer.append("\n base64P7SignedDataAndEnvelopedData: ");
            buffer.append(Debugger.dump(base64P7SignedDataAndEnvelopedData));
            buffer.append("\n recvPriKey: ");
            buffer.append(Debugger.dump(recvPriKey));
            buffer.append("\n recvCert: ");
            buffer.append(Debugger.dump(recvCert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signedData;
            if (base64P7SignedDataAndEnvelopedData == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P7SignedDataAndEnvelopedData");
            }
            if (recvPriKey == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recvPriKey");
            }
            if (recvCert == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: recvCert");
            }
            if (session == null) {
                throw new PKIException("851200", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                signedData = EnvelopeUtil.openEvelopedMessage(base64P7SignedDataAndEnvelopedData, recvPriKey, recvCert, session);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("openEnvelopedMS::::::openEvelopedMessage, signedData=");
                    buffer.append(Debugger.dump(signedData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851211", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u521b\u5efa\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
            boolean pass = true;
            byte[] data = null;
            try {
                PKCS7SignedData2 p7 = new PKCS7SignedData2(session);
                p7.loadAsn1(signedData);
                if (p7.verifyP7SignedDataAttach()) {
                    data = p7.getSourceData();
                } else {
                    pass = false;
                }
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("openEnvelopedMS::::::p7VerifyMessageAttach, pass=");
                    buffer.append(pass);
                    buffer.append(",sourceData=");
                    buffer.append(Debugger.dump(data));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851214", "851214", e);
            }
            if (!pass) {
                throw new PKIException("851213", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u6570\u5b57\u7b7e\u540d\u5931");
            }
            return data;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("openEnvelopedMS<<<<<<Failure");
                buffer.append("\n base64P7SignedDataAndEnvelopedData: ");
                buffer.append(Debugger.dump(base64P7SignedDataAndEnvelopedData));
                buffer.append("\n recvPriKey: ");
                buffer.append(Debugger.dump(recvPriKey));
                buffer.append("\n recvCert: ");
                buffer.append(Debugger.dump(recvCert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    private static byte[] checkRecipientsAndSymmetricKey(boolean sm2Type, PrivateKey privateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("checkRecipientsAndSymmetricKey::>>>>>>Running");
            buffer.append("\n sm2Type: " + sm2Type);
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(privateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(Debugger.dump(recipientCert));
            buffer.append("\n receivers: ");
            buffer.append(Debugger.dump(receivers));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] symmetricKey;
            if (receivers == null) {
                throw new PKIException("851221", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u6ca1\u6709\u63a5\u6536\u8005\u4fe1\u606f");
            }
            RecipientInfo recipientInfo = null;
            KeyTransRecipientInfo keyTransRecipientInfo = null;
            ASN1OctetString encryptKey = null;
            AlgorithmIdentifier algId = null;
            int len = receivers.size();
            if (logger.isDebugEnabled()) {
                logger.debug("checkRecipientsAndSymmetricKey::::::::FindRecipientInfo[Runnning]");
            }
            boolean findResult = false;
            for (int i = 0; i < len; ++i) {
                StringBuffer buffer;
                recipientInfo = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (logger.isDebugEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("checkRecipientsAndSymmetricKey::::::::ShowRecipientInfo");
                    buffer.append("\n RecipientInfo=");
                    buffer.append(Debugger.dump(recipientInfo));
                    logger.debug(buffer.toString());
                }
                if (!(recipientInfo.getInfo() instanceof KeyTransRecipientInfo) || !recipientCert.isRecipent(keyTransRecipientInfo = KeyTransRecipientInfo.getInstance(recipientInfo.getInfo()))) continue;
                encryptKey = keyTransRecipientInfo.getEncryptedKey();
                algId = keyTransRecipientInfo.getKeyEncryptionAlgorithm();
                if (logger.isDebugEnabled()) {
                    buffer = new StringBuffer();
                    buffer.append("checkRecipientsAndSymmetricKey::::::::FindRecipientInfo");
                    buffer.append("\n EncryptedKey=");
                    buffer.append(Debugger.dump(encryptKey));
                    buffer.append("\n EncryptionAlgorithm=");
                    buffer.append(Debugger.dump(algId));
                    logger.debug(buffer.toString());
                }
                findResult = true;
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("checkRecipientsAndSymmetricKey::::::::FindRecipientInfo[Finished] findResult=" + findResult);
            }
            if (encryptKey == null) {
                throw new PKIException("851222", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u6ca1\u6709\u63a5\u6536\u8005\u5bc6\u94a5\u4fe1\u606f");
            }
            if (algId == null) {
                throw new PKIException("851223", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u6ca1\u6709\u63a5\u6536\u8005\u7b97\u6cd5\u4fe1\u606f");
            }
            Mechanism contentEncryptionAlg = sm2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
            byte[] encryptedKeyData = encryptKey.getOctets();
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("checkRecipientsAndSymmetricKey::::::::Decrypt Running");
                buffer.append("\n contentEncryptionAlg: ");
                buffer.append(Debugger.dump(contentEncryptionAlg));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(privateKey));
                buffer.append("\n encryptedKeyData: ");
                buffer.append(Debugger.dump(encryptedKeyData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.debug(buffer.toString());
            }
            if ((symmetricKey = session.decrypt(contentEncryptionAlg, privateKey, encryptedKeyData)) == null) {
                throw new PKIException("851224", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u6062\u590d\u89e3\u5bc6\u5bc6\u94a5\u5931\u8d25");
            }
            return symmetricKey;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("checkRecipientsAndSymmetricKey::<<<<<<Failure");
                buffer.append("\n sm2Type: " + sm2Type);
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(privateKey));
                buffer.append("\n recipientCert: ");
                buffer.append(Debugger.dump(recipientCert));
                buffer.append("\n receivers: ");
                buffer.append(Debugger.dump(receivers));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    private static Mechanism buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("buildMechanism::>>>>>>Running");
            buffer.append("\n symmetricAlgId: ");
            buffer.append(Debugger.dump(symmetricAlgId));
            logger.debug(buffer.toString());
        }
        try {
            if (symmetricAlgId == null) {
                throw new PKIException("851223", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u6ca1\u6709\u63a5\u6536\u8005\u7b97\u6cd5\u4fe1\u606f");
            }
            Mechanism mechanism = null;
            String encryptionAlgorithm = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
            if (encryptionAlgorithm.indexOf("CBC") != -1) {
                DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
                CBCParam cbcParam = new CBCParam(doct.getOctets());
                if (encryptionAlgorithm.equals("DESede/CBC/PKCS7Padding")) {
                    logger.debug("buildMechanism::::::::CBC: DES3");
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                } else if (encryptionAlgorithm.equals("SM4/CBC/PKCS7Padding")) {
                    logger.debug("buildMechanism::::::::CBC: SM4");
                    mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
                } else {
                    logger.debug("buildMechanism::::::::CBC: DoNothing");
                }
            } else if (encryptionAlgorithm.indexOf("ECB") != -1) {
                if (encryptionAlgorithm.equals("DESede/ECB/PKCS7Padding")) {
                    logger.debug("buildMechanism::::::::ECB: DES3");
                    mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                } else if (encryptionAlgorithm.equals("SM4/ECB/PKCS7Padding")) {
                    logger.debug("buildMechanism::::::::ECB: SM4");
                    mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
                } else {
                    logger.debug("buildMechanism::::::::ECB: DoNothing");
                }
            } else if (encryptionAlgorithm.indexOf("RC4") != -1) {
                logger.debug("buildMechanism::::::::RC4");
                mechanism = new Mechanism("RC4");
            } else {
                logger.debug("buildMechanism::::::::DoNothing");
            }
            if (mechanism == null) {
                throw new PKIException("851225", "\u6570\u5b57\u4fe1\u5c01\u5de5\u5177\u5305\u89e3\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301: " + encryptionAlgorithm);
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("buildMechanism::<<<<<<Finished,mechanism=");
                buffer.append(Debugger.dump(mechanism));
                logger.debug(buffer.toString());
            }
            return mechanism;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("buildMechanism::<<<<<<Failure");
                buffer.append("\n symmetricAlgId: ");
                buffer.append(Debugger.dump(symmetricAlgId));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    private static final void DecryptMicrosoftFile(Mechanism mechanism, byte[] symmetricKey, ASN1Node encryptedNode, BufferedOutputStream fos) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DecryptMicrosoftFile::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n symmetricKey: ");
            buffer.append(Debugger.dump(symmetricKey));
            logger.debug(buffer.toString());
        }
        try {
            RandomAccessFile raf = null;
            if (mechanism.getMechanismType().equals("RC4")) {
                logger.debug("DecryptMicrosoftFile::::::::RC4");
                RC4Engine rc4 = new RC4Engine();
                KeyParameter keyParam = new KeyParameter(symmetricKey);
                rc4.init(false, keyParam);
                raf = new RandomAccessFile(encryptedNode.f, "r");
                BigFileDecrypt.bigFileRC4Decrypt(rc4, encryptedNode, fos, raf);
            } else {
                DESedeEngine deSedeEngine = new DESedeEngine();
                PaddedBufferedBlockCipher cipher = null;
                CBCParam param = (CBCParam)mechanism.getParam();
                if (param == null) {
                    logger.debug("DecryptMicrosoftFile::::::::DESede/ECB/PKCS7Padding");
                    cipher = new PaddedBufferedBlockCipher(deSedeEngine, new PKCS7Padding());
                    KeyParameter params = new KeyParameter(symmetricKey);
                    cipher.init(false, params);
                } else {
                    logger.debug("DecryptMicrosoftFile::::::::DESede/CBC/PKCS7Padding");
                    cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(deSedeEngine), new PKCS7Padding());
                    ParametersWithIV params = new ParametersWithIV(new KeyParameter(symmetricKey), param.getIv());
                    cipher.init(false, params);
                }
                raf = new RandomAccessFile(encryptedNode.f, "r");
                BigFileDecrypt.bigFileBlockDecrypt(cipher, encryptedNode, fos, raf);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("DecryptMicrosoftFile::<<<<<<Finished");
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("DecryptMicrosoftFile::<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                buffer.append("\n symmetricKey: ");
                buffer.append(Debugger.dump(symmetricKey));
                logger.debug(buffer.toString());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] envelopeMS(byte[] sourceData, String signAlg, PrivateKey signPriKey, X509Cert signCert, String symmetricAlg, X509Cert[] recvCerts, Session session) throws PKIException {
        logger.debug("envelopeMS::>>>>>>Running");
        try {
            byte[] byArray = EnvelopeUtil.envelopeMS(sourceData, signAlg, signPriKey, signCert, symmetricAlg, recvCerts, session, SM2Compatible.isOutputSM2SignedWithZ(), 0);
            return byArray;
        }
        finally {
            logger.debug("envelopeMS::<<<<<<Finished");
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(EnvelopeUtil.class);
    }
}

