/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.api;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.PKCS7SignFileParser;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.util.api.P7Info;
import cfca.util.api.StringHelper;
import cfca.util.cipher.lib.JCrypto;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.File;
import java.math.BigInteger;
import java.util.Enumeration;

public final class P7Helper {
    static final Logger logger = LoggerFactory.getLogger(P7Helper.class);
    static volatile Session session = null;

    public static final P7Info getP7InfoFromMessage(String base64P7SignedString) throws PKIException {
        PKCS7SignedData2 p7 = null;
        if (StringHelper.isEmpty(base64P7SignedString)) {
            throw new PKIException("null not allowed for base64P7SignedString");
        }
        try {
            Session session = P7Helper.session();
            p7 = new PKCS7SignedData2(session);
            p7.loadBase64(Base64.decode(base64P7SignedString));
            X509Cert signCert = p7.getSignerX509Cert();
            P7Info p7SignedData = new P7Info(signCert, p7.getSignOID(), signCert.getCertType());
            return p7SignedData;
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getP7InfoFromMessage<<<<<<Failure");
            buffer.append("\n base64P7SignedString: ");
            buffer.append(Debugger.dump(base64P7SignedString));
            logger.error(buffer.toString(), e);
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", e);
        }
    }

    public static final P7Info getP7InfoFromFile(String signFile) throws PKIException {
        if (StringHelper.isEmpty(signFile)) {
            throw new PKIException("null not allowed for signFile");
        }
        try {
            PKCS7SignFileParser parser = new PKCS7SignFileParser(new File(signFile));
            parser.parser();
            logger.debug("verifyP7SignedFile::::::Parser Okay");
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            X509Cert signerCert = null;
            String signOID = null;
            SignerInfo signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                signOID = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().getId();
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                signerCert = P7Helper.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySM2P7SignedFile<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
            }
            P7Info p7SignedData = new P7Info(signerCert, signOID, signerCert.getCertType());
            return p7SignedData;
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getP7InfoFromFile<<<<<<Failure");
            buffer.append("\n signFile: ");
            buffer.append(signFile);
            logger.error(buffer.toString(), e);
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", e);
        }
    }

    private static X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException("null not allowed for certs");
            }
            if (issuerAndSN == null) {
                throw new PKIException("null not allowed for issuerAndSN");
            }
            String issuer = issuerAndSN.getName().toString();
            BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
            X500Name certIssuer = null;
            BigInteger certSN = null;
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] == null) continue;
                certIssuer = certs[i].getIssuerX500Name();
                certSN = certs[i].getSerialNumber();
                if (!certIssuer.toString().equals(issuer) || certSN.compareTo(sn) != 0) continue;
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getSignerCert::<<<<<<Finished");
                    buffer.append("\n match cert: ");
                    buffer.append(Debugger.dump(certs[i]));
                    logger.debug(buffer.toString());
                }
                return certs[i];
            }
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<NO NOT FIND SignerCert");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString());
            }
            return null;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<Failure");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<Failure");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString(), e);
            }
            throw new PKIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Session session() throws PKIException {
        if (session != null) return session;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (session != null) return session;
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                throw new PKIException("Open session failure: " + e.getMessage());
            }
            return session;
        }
    }
}

