/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1;

import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1String;
import cmbc.cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.StreamUtil;
import cmbc.cfca.org.bouncycastle.util.Arrays;
import cmbc.cfca.org.bouncycastle.util.Strings;
import java.io.IOException;

public class DERPrintableString
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERPrintableString getInstance(Object obj) {
        if (obj == null || obj instanceof DERPrintableString) {
            return (DERPrintableString)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERPrintableString) {
            return DERPrintableString.getInstance(o);
        }
        return new DERPrintableString(ASN1OctetString.getInstance(o).getOctets());
    }

    DERPrintableString(byte[] string) {
        this.string = string;
    }

    public DERPrintableString(String string) {
        this(string, false);
    }

    public DERPrintableString(String string, boolean validate) {
        if (validate && !DERPrintableString.isPrintableString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(19, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    public boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString s = (DERPrintableString)o;
        return Arrays.areEqual(this.string, s.string);
    }

    public String toString() {
        return this.getString();
    }

    public static boolean isPrintableString(String str) {
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch > '\u007f') {
                return false;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') continue;
            switch (ch) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

