/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetStringParser;
import cmbc.cfca.org.bouncycastle.asn1.ASN1SequenceParser;
import cmbc.cfca.org.bouncycastle.asn1.cms.CompressedDataParser;
import cmbc.cfca.org.bouncycastle.asn1.cms.ContentInfoParser;
import cmbc.cfca.org.bouncycastle.cms.CMSContentInfoParser;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSTypedStream;
import cmbc.cfca.org.bouncycastle.operator.InputExpander;
import cmbc.cfca.org.bouncycastle.operator.InputExpanderProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] compressedData) throws CMSException {
        this(new ByteArrayInputStream(compressedData));
    }

    public CMSCompressedDataParser(InputStream compressedData) throws CMSException {
        super(compressedData);
    }

    public CMSTypedStream getContent() throws CMSException {
        try {
            CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser content = comData.getEncapContentInfo();
            ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
            return new CMSTypedStream(content.getContentType().toString(), (InputStream)new InflaterInputStream(bytes.getOctetStream()));
        }
        catch (IOException e) {
            throw new CMSException("IOException reading compressed content.", e);
        }
    }

    public CMSTypedStream getContent(InputExpanderProvider expanderProvider) throws CMSException {
        try {
            CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser content = comData.getEncapContentInfo();
            InputExpander expander = expanderProvider.get(comData.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
            return new CMSTypedStream(content.getContentType().getId(), expander.getInputStream(bytes.getOctetStream()));
        }
        catch (IOException e) {
            throw new CMSException("IOException reading compressed content.", e);
        }
    }
}

