/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric;

import cmbc.cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cmbc.cfca.org.bouncycastle.crypto.engines.NoekeonEngine;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cmbc.cfca.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import cmbc.cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class Noekeon {
    private Noekeon() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Noekeon.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.NOEKEON", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.NOEKEON", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.NOEKEON", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.NOEKEON", PREFIX + "$KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Noekeon IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Noekeon parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Noekeon", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Noekeon", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new NoekeonEngine());
        }
    }
}

