/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jce.provider;

import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import cmbc.cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cmbc.cfca.org.bouncycastle.jce.spec.ECParameterSpec;
import java.security.Permission;
import javax.crypto.spec.DHParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "DhDefaultParams");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile DHParameterSpec dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setParameter(String parameterName, Object parameter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (parameterName.equals("threadLocalEcImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if (!(parameter instanceof ECParameterSpec) && parameter != null) {
                throw new IllegalArgumentException("not a valid ECParameterSpec");
            }
            ECParameterSpec curveSpec = (ECParameterSpec)parameter;
            if (curveSpec == null) {
                this.ecThreadSpec.set(null);
                return;
            } else {
                this.ecThreadSpec.set(curveSpec);
            }
            return;
        } else if (parameterName.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            if (!(parameter instanceof ECParameterSpec) && parameter != null) throw new IllegalArgumentException("not a valid ECParameterSpec");
            this.ecImplicitCaParams = (ECParameterSpec)parameter;
            return;
        } else if (parameterName.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(parameter instanceof DHParameterSpec) && parameter != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            DHParameterSpec dhSpec = (DHParameterSpec)parameter;
            if (dhSpec == null) {
                this.dhThreadSpec.set(null);
                return;
            } else {
                this.dhThreadSpec.set(dhSpec);
            }
            return;
        } else {
            if (!parameterName.equals("DhDefaultParams")) return;
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(parameter instanceof DHParameterSpec) && parameter != null) throw new IllegalArgumentException("not a valid DHParameterSpec");
            this.dhDefaultParams = (DHParameterSpec)parameter;
        }
    }

    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec spec = (ECParameterSpec)this.ecThreadSpec.get();
        if (spec != null) {
            return spec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters() {
        DHParameterSpec spec = (DHParameterSpec)this.dhThreadSpec.get();
        if (spec != null) {
            return spec;
        }
        return this.dhDefaultParams;
    }
}

