/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.operator.bc;

import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.crypto.Digest;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculator;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.operator.bc.BcUtil;
import java.io.IOException;
import java.io.OutputStream;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    public DigestCalculator get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
        Digest dig = BcUtil.createDigest(algorithm);
        final DigestOutputStream stream = new DigestOutputStream(dig);
        return new DigestCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            public OutputStream getOutputStream() {
                return stream;
            }

            public byte[] getDigest() {
                return stream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes, 0, bytes.length);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

