/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.pkcs;

import cmbc.cfca.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.operator.InputDecryptor;
import cmbc.cfca.org.bouncycastle.operator.InputDecryptorProvider;
import cmbc.cfca.org.bouncycastle.pkcs.PKCSException;
import cmbc.cfca.org.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
    }

    public EncryptedPrivateKeyInfo toASN1Structure() {
        return this.encryptedPrivateKeyInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.encryptedPrivateKeyInfo.getEncoded();
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        InputDecryptor decrytor = inputDecryptorProvider.get(this.encryptedPrivateKeyInfo.getEncryptionAlgorithm());
        ByteArrayInputStream encIn = new ByteArrayInputStream(this.encryptedPrivateKeyInfo.getEncryptedData());
        try {
            return PrivateKeyInfo.getInstance(Streams.readAll(decrytor.getInputStream(encIn)));
        }
        catch (Exception e) {
            throw new PKCSException("unable to read encrypted data: " + e.getMessage(), e);
        }
    }
}

