/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.rsa.signature;

import cmbc.cfca.system.SecureRandoms;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class RSAPKCS1Padding {
    private static int HEADER_LENGTH = 10;

    static final byte[] addPKCS1Padding(byte[] derDigest, RSAPrivateKey priKey, int blockLen) {
        byte[] block = new byte[blockLen];
        block[0] = 0;
        block[1] = 1;
        int inLen = derDigest.length;
        for (int i = 2; i != block.length - inLen - 1; ++i) {
            block[i] = -1;
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(derDigest, 0, block, block.length - inLen, inLen);
        return block;
    }

    static final byte[] addPKCS1Padding(byte[] data, RSAPublicKey pubKey, int blockLen) {
        byte[] block = new byte[blockLen];
        block[0] = 0;
        block[1] = 2;
        byte[] padding = SecureRandoms.getInstance().genBytesWithoutZero(block.length - 3 - data.length);
        System.arraycopy(padding, 0, block, 2, padding.length);
        block[block.length - data.length - 1] = 0;
        System.arraycopy(data, 0, block, block.length - data.length, data.length);
        return block;
    }

    static final byte[] remPKCS1Padding(byte[] paddingData) throws Exception {
        byte pad;
        int start;
        byte type = paddingData[1];
        if (type != 1 && type != 2 && type != 9) {
            throw new SecurityException("unknown block type");
        }
        for (start = 2; start != paddingData.length && (pad = paddingData[start]) != 0; ++start) {
            if (type != 1 || pad == -1) continue;
            throw new SecurityException("block padding incorrect");
        }
        if (++start > paddingData.length || start < HEADER_LENGTH) {
            throw new SecurityException("no data in block");
        }
        byte[] result = new byte[paddingData.length - start];
        System.arraycopy(paddingData, start, result, 0, result.length);
        return result;
    }
}

