/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.rsa.signature;

import cmbc.cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cmbc.cfca.org.bouncycastle.util.Arrays;
import cmbc.cfca.rsa.signature.PKCS8ToPKCS1Util;
import cmbc.cfca.rsa.signature.RSACrypt;
import cmbc.cfca.rsa.signature.RSAPKCS1Padding;
import cmbc.cfca.sm2rsa.common.PKIException;
import cryptokit.jni.JNIRSA;
import java.security.Key;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAPackageUtil {
    public static byte[] encrypt(byte[] digestData, Key privateKey) throws Exception {
        if (digestData == null) {
            throw new Exception("null is not allowed for digestData");
        }
        if (privateKey == null) {
            throw new Exception("null is not allowed for privateKey");
        }
        RSACrypt signer = new RSACrypt();
        RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
        RSAKeyParameters priParameter = RSAPackageUtil.generatePrivateKeyParameter(priKey);
        signer.init(true, priParameter);
        try {
            return signer.encrypt(digestData);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public static final byte[] decrypt(byte[] encryptedData, Key publicKey) throws Exception {
        if (encryptedData == null) {
            throw new Exception("null is not allowed for encryptedData");
        }
        if (publicKey == null) {
            throw new Exception("null is not allowed for publicKey");
        }
        RSACrypt signer = new RSACrypt();
        RSAPublicKey pubKey = (RSAPublicKey)publicKey;
        RSAKeyParameters pubParameter = RSAPackageUtil.generatePublicKeyParameter(pubKey);
        signer.init(false, pubParameter);
        return signer.decrypt(encryptedData);
    }

    public static final byte[] encryptByJNI(byte[] hash, RSAPrivateKey privateKey) throws Exception {
        byte[] output;
        if (hash == null) {
            throw new Exception("null is not allowed for hash");
        }
        if (privateKey == null) {
            throw new Exception("null is not allowed for privateKey");
        }
        int blockLen = (privateKey.getModulus().bitLength() + 7) / 8;
        byte[] pkcs1PriKey = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(privateKey);
        byte[] input = RSAPKCS1Padding.addPKCS1Padding(hash, privateKey, blockLen);
        boolean encryptedResult = JNIRSA.dowithPrivateKey(input, pkcs1PriKey, output = new byte[input.length]);
        if (!encryptedResult) {
            throw new SecurityException("encryped failure");
        }
        return output;
    }

    public static byte[] decryptByJNI(byte[] encryptedData, RSAPublicKey publicKey) throws Exception {
        byte[] output;
        if (encryptedData == null) {
            throw new Exception("null is not allowed for encryptedData");
        }
        if (publicKey == null) {
            throw new Exception("null is not allowed for publicKey");
        }
        int blockLen = (publicKey.getModulus().bitLength() + 7) / 8;
        byte[] pkcs1PubKey = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(publicKey);
        boolean decryptedResult = JNIRSA.dowithPublicKey(encryptedData, pkcs1PubKey, output = new byte[blockLen]);
        if (!decryptedResult) {
            throw new SecurityException("decryped failure");
        }
        return RSAPKCS1Padding.remPKCS1Padding(output);
    }

    public static byte[] encryptByJNI(byte[] srcData, RSAPublicKey publicKey) throws Exception {
        byte[] output;
        if (srcData == null) {
            throw new Exception("null is not allowed for srcData");
        }
        if (publicKey == null) {
            throw new Exception("null is not allowed for publicKey");
        }
        int blockLen = (publicKey.getModulus().bitLength() + 7) / 8;
        byte[] pkcs1PubKey = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(publicKey);
        byte[] input = RSAPKCS1Padding.addPKCS1Padding(srcData, publicKey, blockLen);
        boolean encryptedResult = JNIRSA.dowithPublicKey(input, pkcs1PubKey, output = new byte[blockLen]);
        if (!encryptedResult) {
            throw new SecurityException("encryped failure");
        }
        return output;
    }

    public static byte[] decryptByJNI(byte[] encryptedData, RSAPrivateKey privateKey) throws Exception {
        byte[] output;
        if (encryptedData == null) {
            throw new Exception("null is not allowed for encryptedData");
        }
        if (privateKey == null) {
            throw new Exception("null is not allowed for privateKey");
        }
        int blockLen = (privateKey.getModulus().bitLength() + 7) / 8;
        byte[] pkcs1PriKey = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(privateKey);
        boolean encryptedResult = JNIRSA.dowithPrivateKey(encryptedData, pkcs1PriKey, output = new byte[blockLen]);
        if (!encryptedResult) {
            throw new SecurityException("encryped failure");
        }
        return RSAPKCS1Padding.remPKCS1Padding(output);
    }

    public static boolean isRSAHashEqual(byte[] extractHash, byte[] calcuHash) {
        if (calcuHash == null || extractHash == null) {
            return false;
        }
        if (extractHash.length == calcuHash.length) {
            return Arrays.constantTimeAreEqual(extractHash, calcuHash);
        }
        if (extractHash.length == calcuHash.length - 2) {
            int i;
            DigestInfo dInfo = DigestInfo.getInstance(calcuHash);
            int len = dInfo.getDigest().length;
            int sigOffset = extractHash.length - len - 2;
            int expectedOffset = calcuHash.length - len - 2;
            calcuHash[1] = (byte)(calcuHash[1] - 2);
            calcuHash[3] = (byte)(calcuHash[3] - 2);
            int nonEqual = 0;
            for (i = 0; i < len; ++i) {
                nonEqual |= extractHash[sigOffset + i] ^ calcuHash[expectedOffset + i];
            }
            for (i = 0; i < sigOffset; ++i) {
                nonEqual |= extractHash[i] ^ calcuHash[i];
            }
            return nonEqual == 0;
        }
        return false;
    }

    public static final RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    public static final RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        return new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
    }
}

