/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.system;

import java.security.SecureRandom;

public final class SecureRandoms {
    SecureRandom random = new SecureRandom();
    private static volatile SecureRandoms instance = new SecureRandoms();

    public static SecureRandoms getInstance() {
        return instance;
    }

    private SecureRandoms() {
    }

    public final SecureRandom newSecureRandom() {
        return new SecureRandom();
    }

    public final byte[] genBytes(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Required length >= 0");
        }
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        return bytes;
    }

    public final byte[] genBytesWithoutZero(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Required length >= 0");
        }
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        for (int i = 0; i < bytes.length; ++i) {
            while (bytes[i] == 0) {
                bytes[i] = (byte)this.random.nextInt();
            }
        }
        return bytes;
    }
}

