/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERBitString;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIConstant;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.sm2rsa.common.X9ObjectIdentifiers;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.system.SM2Compatible;
import cmbc.cfca.util.Base64;
import cmbc.cfca.util.KeyUtil;
import cmbc.cfca.util.cipher.lib.Session;
import java.security.KeyPair;

public final class P10RequestUtil {
    static final Logger logger;
    private KeyPair keyPair;

    public String generateRSAPKCS10Request(Mechanism mechanism, int RSAKeyLength, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateRSAPKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: " + (mechanism == null ? "none" : mechanism.getMechanismType()));
            buffer.append("\n RSAKeyLength: " + RSAKeyLength);
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
            }
            if (session == null) {
                throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                this.keyPair = KeyUtil.generateRSAKeyPair(mechanism, RSAKeyLength, session);
            }
            catch (Exception e) {
                throw new PKIException("851711", "\u7533\u8bf7\u5de5\u5177\u5305\u4ea7\u751f\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            try {
                SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
                X500Name subject = new X500Name("CN=CFCA");
                CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
                AlgorithmIdentifier signAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
                byte[] sourceData = certRequestInfo.getEncoded("DER");
                byte[] signature = session.sign(new Mechanism("SHA1withRSAEncryption"), this.keyPair.getPrivate(), sourceData, false);
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                String base64P10Text = new String(Base64.encode(p10.getEncoded()), "UTF8");
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("generateRSAPKCS10Request<<<<<<Finished");
                    buffer.append("\n base64P10Text: ");
                    buffer.append(Debugger.dump(base64P10Text));
                    logger.debug(buffer.toString());
                }
                return base64P10Text;
            }
            catch (Exception e) {
                throw new PKIException("851712", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateRSAPKCS10Request<<<<<<Failure");
                buffer.append("\n mechanism: " + (mechanism == null ? "none" : mechanism.getMechanismType()));
                buffer.append("\n RSAKeyLength: " + RSAKeyLength);
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public String generateSM2PKCS10Request(Mechanism mechanism, Session session, boolean sm2WithZFlag) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateSM2PKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: " + (mechanism == null ? "none" : mechanism.getMechanismType()));
            buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
            }
            if (session == null) {
                throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                this.keyPair = KeyUtil.generateSM2KeyPair(mechanism, session);
            }
            catch (Exception e) {
                throw new PKIException("851711", "\u7533\u8bf7\u5de5\u5177\u5305\u4ea7\u751f\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            try {
                SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
                X500Name subject = new X500Name("CN=CFCA");
                CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
                AlgorithmIdentifier signAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.sm3_with_SM2, (ASN1Encodable)DERNull.INSTANCE);
                byte[] sourceData = certRequestInfo.getEncoded("DER");
                byte[] signature = session.sign(new Mechanism("SM3withSM2"), this.keyPair.getPrivate(), sourceData, sm2WithZFlag);
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                String base64P10Text = new String(Base64.encode(p10.getEncoded()), "UTF8");
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("generateSM2PKCS10Request<<<<<<Finished");
                    buffer.append("\n base64P10Text: ");
                    buffer.append(Debugger.dump(base64P10Text));
                    logger.debug(buffer.toString());
                }
                return base64P10Text;
            }
            catch (Exception e) {
                throw new PKIException("851712", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateSM2PKCS10Request<<<<<<Failure");
                buffer.append("\n mechanism: " + (mechanism == null ? "none" : mechanism.getMechanismType()));
                buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public static String getSubjectFromP10Request(String base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSubjectFromP10Request>>>>>>Running");
            buffer.append("\n base64P10Request: ");
            buffer.append(Debugger.dump(base64P10Request));
            logger.debug(buffer.toString());
        }
        try {
            PKCS10CertificationRequest p10 = P10RequestUtil.decodeP10Request(base64P10Request);
            try {
                return p10.getSubject().toString();
            }
            catch (Exception e) {
                throw new PKIException("851713", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSubjectFromP10Request<<<<<<Failure");
                buffer.append("\n base64P10Request: ");
                buffer.append(Debugger.dump(base64P10Request));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public static String getSignAlgFromP10Request(String base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSignAlgFromP10Request>>>>>>Running");
            buffer.append("\n base64P10Request: ");
            buffer.append(Debugger.dump(base64P10Request));
            logger.debug(buffer.toString());
        }
        try {
            PKCS10CertificationRequest p10 = P10RequestUtil.decodeP10Request(base64P10Request);
            try {
                ASN1ObjectIdentifier oid = p10.getSignatureAlgorithm().getAlgorithm();
                boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
                if (!isContain) {
                    return oid.getId();
                }
                String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
                return sigAlgName;
            }
            catch (Exception e) {
                throw new PKIException("851713", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignAlgFromP10Request<<<<<<Failure");
                buffer.append("\n base64P10Request: ");
                buffer.append(Debugger.dump(base64P10Request));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public static byte[] getSignatureFromP10Request(String base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSignatureFromP10Request>>>>>>Running");
            buffer.append("\n base64P10Request: ");
            buffer.append(Debugger.dump(base64P10Request));
            logger.debug(buffer.toString());
        }
        try {
            PKCS10CertificationRequest p10 = P10RequestUtil.decodeP10Request(base64P10Request);
            try {
                return p10.getSignature();
            }
            catch (Exception e) {
                throw new PKIException("851713", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignatureFromP10Request<<<<<<Failure");
                buffer.append("\n base64P10Request: ");
                buffer.append(Debugger.dump(base64P10Request));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public String generateSM2PKCS10Request(Mechanism mechanism, Session session) throws PKIException {
        if (mechanism == null) {
            throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
        }
        if (session == null) {
            throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
        }
        return this.generateSM2PKCS10Request(mechanism, session, SM2Compatible.isOutputSM2SignedWithZ());
    }

    private static PKCS10CertificationRequest decodeP10Request(String base64P10Request) throws PKIException {
        byte[] encoding;
        if (base64P10Request == null) {
            throw new PKIException("851700", "\u7533\u8bf7\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P10Request");
        }
        try {
            encoding = Base64.decode(base64P10Request);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decodeP10Request<<<<<<Failure invalid Base64Encoding");
                buffer.append("\n base64P10Request: ");
                buffer.append(Debugger.dump(base64P10Request));
                logger.error(buffer.toString(), e);
            }
            throw new PKIException("851713", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
        }
        try {
            return new PKCS10CertificationRequest(encoding);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decodeP10Request<<<<<<Failure invalid PKCS10CertificationRequest");
                buffer.append("\n base64P10Request: ");
                buffer.append(Debugger.dump(base64P10Request));
                logger.error(buffer.toString(), e);
            }
            throw new PKIException("851713", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(P10RequestUtil.class);
    }
}

