/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.internal.tool.ASN1Parser;
import cmbc.cfca.org.bouncycastle.asn1.cms.Attribute;
import cmbc.cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cmbc.cfca.org.bouncycastle.asn1.cms.CMSAttributes;
import cmbc.cfca.org.bouncycastle.asn1.cms.Time;
import cmbc.cfca.org.bouncycastle.cms.CMSSignedDataParser;
import cmbc.cfca.org.bouncycastle.cms.SignerInformation;
import cmbc.cfca.org.bouncycastle.cms.SignerInformationStore;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cmbc.cfca.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCS7SignedData;
import cmbc.cfca.sm2rsa.common.PKCS7SignedData2;
import cmbc.cfca.sm2rsa.common.PKCS7SignedFile;
import cmbc.cfca.sm2rsa.common.PKCS7SignedFile2;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.system.SM2Compatible;
import cmbc.cfca.util.Base64;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class SignatureUtil {
    static final Logger logger;
    private X509Cert signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;
    private boolean sm2WithZFlag = SM2Compatible.isOutputSM2SignedWithZ();

    public SignatureUtil() {
        if (logger.isDebugEnabled()) {
            logger.debug("SignatureUtil sm2WithZFlag" + this.sm2WithZFlag);
        }
    }

    public boolean isSm2WithZFlag() {
        if (logger.isDebugEnabled()) {
            logger.debug("isSm2WithZFlag: " + this.sm2WithZFlag);
        }
        return this.sm2WithZFlag;
    }

    public void setSm2WithZFlag(boolean sm2WithZFlag) {
        if (logger.isDebugEnabled()) {
            logger.debug("setSm2WithZFlag: " + sm2WithZFlag);
        }
        this.sm2WithZFlag = sm2WithZFlag;
    }

    public final byte[] getSourceData() {
        if (logger.isDebugEnabled()) {
            logger.debug("getSourceData: sourceData= " + (this.sourceData == null ? "none" : Hex.toHexString(this.sourceData)));
        }
        return this.sourceData;
    }

    public final byte[] getSignature() {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignature: signature= " + (this.signature == null ? "none" : Hex.toHexString(this.signature)));
        }
        return this.signature;
    }

    public final String getDigestAlgorithm() {
        if (logger.isDebugEnabled()) {
            logger.debug("getDigestAlgorithm: digestAlgorithm= " + (this.digestAlgorithm == null ? "none" : this.digestAlgorithm));
        }
        return this.digestAlgorithm;
    }

    public final X509Cert getSignerCert() {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerCert: signCert= " + Debugger.dump(this.signCert));
        }
        return this.signCert;
    }

    public final String getTimeFromTimeStamp(byte[] bTimeStamp) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getTimeFromTimeStamp Running");
            buffer.append("\n bTimeStamp: " + (bTimeStamp == null ? "none" : Hex.toHexString(bTimeStamp)));
            logger.debug(buffer.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getTimeFromTimeStamp: bTimeStamp= " + (bTimeStamp == null ? "none" : Hex.toHexString(bTimeStamp)));
        }
        if (bTimeStamp == null) {
            if (logger.isErrorEnabled()) {
                logger.error("getTimeFromTimeStamp: required bTimeStamp not null");
            }
            throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: bTimeStamp");
        }
        CMSSignedDataParser sp = null;
        try {
            byte[] base64TimeStamp = ASN1Parser.isBase64Encode(bTimeStamp) ? Base64.decode(bTimeStamp) : bTimeStamp;
            sp = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), (InputStream)new ByteArrayInputStream(base64TimeStamp));
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            String signDateText = null;
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                AttributeTable attributeTable = signer.getSignedAttributes();
                Attribute signTimeAttri = attributeTable.get(CMSAttributes.signingTime);
                Time time = Time.getInstance(signTimeAttri.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                signDateText = format.format(signTimeDate);
            }
            sp.close();
            if (logger.isDebugEnabled()) {
                logger.debug("getTimeFromTimeStamp Okay: signDate= " + signDateText);
            }
            return signDateText;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("getTimeFromTimeStamp failure", e);
            }
            throw new PKIException("851502", "\u7b7e\u540d\u5de5\u5177\u5305\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public final byte[] p1SignByHash(String signAlg, byte[] digest, PrivateKey priKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (digest == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: digest");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkHashLength(digest, signAlg);
            this.checkKeyType(priKey, signAlg);
            try {
                byte[] signData = Base64.encode(this.encodedToASN1(session.signByHash(new Mechanism(signAlg), priKey, digest)));
                if (logger.isDebugEnabled()) {
                    logger.debug("p1SignByHash<<<<<<Finished: signData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1SignByHash<<<<<<Failure");
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n digest: ");
                buffer.append(Debugger.dump(digest));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final boolean p1VerifyByHash(String signAlg, byte[] digest, byte[] base64P1SignedData, PublicKey pubKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(Debugger.dump(base64P1SignedData));
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n PublicKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (digest == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: digest");
            }
            if (base64P1SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P1SignedData");
            }
            if (pubKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkHashLength(digest, signAlg);
            this.checkKeyType(pubKey, signAlg);
            byte[] signature = this.decodedSignValue(base64P1SignedData);
            try {
                boolean verifyResult = session.verifyByHash(new Mechanism(signAlg), pubKey, digest, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("p1VerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1VerifyByHash<<<<<<Failure");
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n base64P1SignedData: ");
                buffer.append(Debugger.dump(base64P1SignedData));
                buffer.append("\n digest: ");
                buffer.append(Debugger.dump(digest));
                buffer.append("\n PublicKey: ");
                buffer.append(Debugger.dump(pubKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final byte[] p1SignMessage(String signAlg, byte[] sourceData, PrivateKey priKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignMessage>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            try {
                byte[] signData = Base64.encode(this.encodedToASN1(session.sign(new Mechanism(signAlg), priKey, sourceData, this.sm2WithZFlag)));
                if (logger.isDebugEnabled()) {
                    logger.debug("p1SignMessage<<<<<<Finished: sm2WithZFlag=" + this.sm2WithZFlag + ",signData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1SignMessage<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final boolean p1VerifyMessage(String signAlg, byte[] sourceData, byte[] base64P1SignedData, PublicKey pubKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyMessage>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(Debugger.dump(base64P1SignedData));
            buffer.append("\n PublicKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (base64P1SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P1SignedData");
            }
            if (pubKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(pubKey, signAlg);
            byte[] signature = this.decodedSignValue(base64P1SignedData);
            try {
                boolean verifyResult = session.verifySign(new Mechanism(signAlg), pubKey, sourceData, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("p1VerifyMessage<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1VerifyMessage<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n base64P1SignedData: ");
                buffer.append(Debugger.dump(base64P1SignedData));
                buffer.append("\n PublicKey: ");
                buffer.append(Debugger.dump(pubKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final byte[] p1SignFile(String signAlg, String sourceFilePath, PrivateKey priKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignFile>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            try {
                byte[] signData = Base64.encode(this.encodedToASN1(session.sign(new Mechanism(signAlg), priKey, sourceFilePath, this.sm2WithZFlag)));
                if (logger.isDebugEnabled()) {
                    logger.debug("p1SignFile<<<<<<Finished: sm2WithZFlag=" + this.sm2WithZFlag + ",signData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1SignFile<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(this.sourceData));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final boolean p1VerifyFile(String signAlg, String sourceFilePath, byte[] base64P1SignedData, PublicKey pubKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyFile>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(Debugger.dump(base64P1SignedData));
            buffer.append("\n PublicKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (base64P1SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P1SignedData");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(pubKey, signAlg);
            byte[] signature = this.decodedSignValue(base64P1SignedData);
            try {
                boolean verifyResult = session.verifySign(new Mechanism(signAlg), pubKey, sourceFilePath, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("p1VerifyFile<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1VerifyFile<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n base64P1SignedData: ");
                buffer.append(Debugger.dump(base64P1SignedData));
                buffer.append("\n PublicKey: ");
                buffer.append(Debugger.dump(pubKey));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public final byte[] p7SignByHash(String signAlg, byte[] digest, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signture;
            Mechanism mechanism;
            X509Cert[] certs;
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (digest == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: digest");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            this.checkCertType(cert, signAlg);
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                certs = new X509Cert[]{cert};
                mechanism = new Mechanism(signAlg);
                signture = session.signByHash(new Mechanism(signAlg), priKey, digest);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignByHash::::::signValue=" + (signture == null ? "none" : Hex.toHexString(signture)));
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                byte[] signData = Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignByHash<<<<<<Finished: signedData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (Exception e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignByHash<<<<<<Failure");
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n digest: ");
                buffer.append(Debugger.dump(digest));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final boolean p7VerifyByHash(byte[] digest, byte[] base64P7SignedData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyByHash>>>>>>Running");
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(Debugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (digest == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: digest");
            }
            if (base64P7SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P7SignedData");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                p7.loadBase64(base64P7SignedData);
                this.signCert = p7.getSignerX509Cert();
                this.digestAlgorithm = p7.getDigestAlgorithm();
                this.signature = p7.getSignature();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("p7VerifyByHash:::::Decode ");
                    buffer.append("\n signCert=");
                    buffer.append(Debugger.dump(this.signCert));
                    buffer.append("\n digestAlgorithm=");
                    buffer.append(Debugger.dump(this.digestAlgorithm));
                    buffer.append("\n signature=");
                    buffer.append(Debugger.dump(this.signature));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851521", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u65f6\u89e3\u5305\u5931\u8d25", e);
            }
            try {
                boolean verifyResult = p7.verifyP7SignedDataByHash(digest);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7VerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyByHash<<<<<<Failure");
                buffer.append("\n digest: ");
                buffer.append(Debugger.dump(digest));
                buffer.append("\n base64P7SignedData: ");
                buffer.append(Debugger.dump(base64P7SignedData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final byte[] p7SignMessageAttach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageAttach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signture;
            Mechanism mechanism;
            X509Cert[] certs;
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (cert == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: cert");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            this.checkCertType(cert, signAlg);
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                certs = new X509Cert[]{cert};
                mechanism = new Mechanism(signAlg);
                signture = session.sign(mechanism, priKey, sourceData, this.sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignMessageAttach::::: signValue=" + (signture == null ? "none" : Hex.toHexString(signture)));
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                byte[] signData = Base64.encode(p7.packageSignedData(true, null, sourceData, signture, mechanism, certs));
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignMessageAttach<<<<<<Finished: signedData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (Exception e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignMessageAttach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final boolean p7VerifyMessageAttach(byte[] base647SignedData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageAttach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n base64P7SignedData: ");
            buffer.append(Debugger.dump(base647SignedData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (base647SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base647SignedData");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                p7.loadBase64(base647SignedData);
                this.signCert = p7.getSignerX509Cert();
                this.sourceData = p7.getSourceData();
                this.digestAlgorithm = p7.getDigestAlgorithm();
                this.signature = p7.getSignature();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("p7VerifyMessageAttach:::::Decode ");
                    buffer.append("\n signCert=");
                    buffer.append(Debugger.dump(this.signCert));
                    buffer.append("\n digestAlgorithm=");
                    buffer.append(Debugger.dump(this.digestAlgorithm));
                    buffer.append("\n signature=");
                    buffer.append(Debugger.dump(this.signature));
                    buffer.append("\n sourceData=");
                    buffer.append(Debugger.dump(this.sourceData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851521", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u65f6\u89e3\u5305\u5931\u8d25", e);
            }
            try {
                boolean verifyResult = p7.verifyP7SignedDataAttach();
                if (logger.isDebugEnabled()) {
                    logger.debug("p7VerifyMessageAttach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyMessageAttach Running");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append(Debugger.dump(base647SignedData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final byte[] p7SignMessageDetach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageDetach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signture;
            Mechanism mechanism;
            X509Cert[] certs;
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            this.checkCertType(cert, signAlg);
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                certs = new X509Cert[]{cert};
                mechanism = new Mechanism(signAlg);
                signture = session.sign(mechanism, priKey, sourceData, this.sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignMessageDetach:::::signValue=" + (signture == null ? "none" : Hex.toHexString(signture)));
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                byte[] signData = Base64.encode(p7.packageSignedData(false, null, sourceData, signture, mechanism, certs));
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignMessageDetach<<<<<<Finished: signedData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (Exception e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignMessageDetach Running");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final boolean p7VerifyMessageDetach(byte[] sourceData, byte[] base64P7SignedData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageDetach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(Debugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (sourceData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (base64P7SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P7SignedData");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                p7.loadBase64(base64P7SignedData);
                this.signCert = p7.getSignerX509Cert();
                this.digestAlgorithm = p7.getDigestAlgorithm();
                this.signature = p7.getSignature();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("p7VerifyMessageDetach:::::Decode ");
                    buffer.append("\n signCert=");
                    buffer.append(Debugger.dump(this.signCert));
                    buffer.append("\n digestAlgorithm=");
                    buffer.append(Debugger.dump(this.digestAlgorithm));
                    buffer.append("\n signature=");
                    buffer.append(Debugger.dump(this.signature));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851521", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u65f6\u89e3\u5305\u5931\u8d25", e);
            }
            try {
                boolean verifyResult = p7.verifyP7SignedData(sourceData);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7VerifyMessageDetach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyMessageDetach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n base64P7SignedData: ");
                buffer.append(Debugger.dump(base64P7SignedData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final void p7SignFileAttach(String signAlg, String sourceFilePath, String signFilePath, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignFileAttach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n signFilePath: " + (signFilePath == null ? "none" : signFilePath));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signture;
            Mechanism mechanism;
            X509Cert[] certs;
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (signFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signFilePath");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570:  priKey");
            }
            if (cert == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: cert");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            this.checkCertType(cert, signAlg);
            PKCS7SignedFile p7 = this.buildPKCS7SignedFile(session);
            try {
                certs = new X509Cert[]{cert};
                mechanism = new Mechanism(signAlg);
                signture = session.sign(mechanism, priKey, sourceFilePath, this.sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignFileAttach:::::signValue=" + (signture == null ? "none" : Hex.toHexString(signture)));
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                p7.packageSignedFile(null, sourceFilePath, signFilePath, signture, mechanism, certs);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignFileAttach<<<<<<Finished");
                }
            }
            catch (Exception e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
            catch (Error e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileAttach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n signFilePath: " + (signFilePath == null ? "none" : signFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final boolean p7VerifyFileAttach(String signFilePath, String outSourceFilePath, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyFileAttach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signFilePath: " + (signFilePath == null ? "none" : signFilePath));
            buffer.append("\n outSourceFilePath: " + (outSourceFilePath == null ? "none" : outSourceFilePath));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (signFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signFilePath");
            }
            if (outSourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: outSourceFilePath");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            try {
                PKCS7SignedFile p7 = this.buildPKCS7SignedFile(session);
                boolean verifyResult = p7.verifyP7SignedFile(signFilePath, outSourceFilePath);
                this.signCert = p7.getSignerX509Cert();
                this.digestAlgorithm = p7.getDigestAlgorithm();
                this.signature = p7.getSignature();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("p7VerifyFileAttach<<<<<<Finished: verifyResult=" + verifyResult);
                    buffer.append("\n signCert=");
                    buffer.append(Debugger.dump(this.signCert));
                    buffer.append("\n digestAlgorithm=");
                    buffer.append(Debugger.dump(this.digestAlgorithm));
                    buffer.append("\n signature=");
                    buffer.append(Debugger.dump(this.signature));
                    logger.debug(buffer.toString());
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyFileAttach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signFilePath: " + (signFilePath == null ? "none" : signFilePath));
                buffer.append("\n outSourceFilePath: " + (outSourceFilePath == null ? "none" : outSourceFilePath));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final byte[] p7SignFileDetach(String signAlg, String sourceFilePath, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignFileDetach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n signAlg: ");
            buffer.append(Debugger.dump(signAlg));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n privateKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signture;
            Mechanism mechanism;
            X509Cert[] certs;
            if (signAlg == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: signAlg");
            }
            if (sourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (priKey == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: priKey");
            }
            if (cert == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: cert");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            this.checkKeyType(priKey, signAlg);
            this.checkCertType(cert, signAlg);
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                certs = new X509Cert[]{cert};
                mechanism = new Mechanism(signAlg);
                signture = session.sign(mechanism, priKey, sourceFilePath, this.sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignFileDetach:::::signValue=" + (signture == null ? "none" : Hex.toHexString(signture)));
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851510", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u5931\u8d25", e);
            }
            try {
                byte[] signData = Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
                if (logger.isDebugEnabled()) {
                    logger.debug("p7SignFileDetach<<<<<<Finished: signedData=" + Debugger.dumpBase64(signData));
                }
                return signData;
            }
            catch (Exception e) {
                throw new PKIException("851511", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u7b7e\u540d\u65f6\u6253\u5305\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileDetach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n signAlg: ");
                buffer.append(Debugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(Debugger.dump(priKey));
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public final boolean p7VerifyFileDetach(String sourceFilePath, byte[] base64P7SignedData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyFileDetach>>>>>>Running");
            buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(Debugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (sourceFilePath == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (base64P7SignedData == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64P7SignedData");
            }
            if (session == null) {
                throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            try {
                p7.loadBase64(base64P7SignedData);
                this.signCert = p7.getSignerX509Cert();
                this.digestAlgorithm = p7.getDigestAlgorithm();
                this.signature = p7.getSignature();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("p7VerifyFileDetach:::::Decode ");
                    buffer.append("\n signCert=");
                    buffer.append(Debugger.dump(this.signCert));
                    buffer.append("\n digestAlgorithm=");
                    buffer.append(Debugger.dump(this.digestAlgorithm));
                    buffer.append("\n signature=");
                    buffer.append(Debugger.dump(this.signature));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851521", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u65f6\u89e3\u5305\u5931\u8d25", e);
            }
            try {
                boolean verifyResult = p7.verifyP7SignedData(sourceFilePath);
                if (logger.isDebugEnabled()) {
                    logger.debug("p7VerifyFileDetach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851520", "\u7b7e\u540d\u5de5\u5177\u5305\u6267\u884c\u6821\u9a8c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyFileDetach<<<<<<Failure");
                buffer.append("\n sm2WithZFlag: " + this.sm2WithZFlag);
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n base64P7SignedData: ");
                buffer.append(Debugger.dump(base64P7SignedData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    final PKCS7SignedData buildPKCS7SignedData(Session session) {
        PKCS7SignedData p7 = null;
        p7 = this.isNewFormat() ? new PKCS7SignedData2(session) : new PKCS7SignedData(session);
        return p7;
    }

    final PKCS7SignedFile buildPKCS7SignedFile(Session session) {
        PKCS7SignedFile p7 = null;
        p7 = this.isNewFormat() ? new PKCS7SignedFile2(session) : new PKCS7SignedFile(session);
        return p7;
    }

    boolean isNewFormat() {
        logger.debug("isNewFormat=False: RAW(R+S)");
        return false;
    }

    private final byte[] decodedSignValue(byte[] base64SignData) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("decodedSignValue>>>>>>" + (base64SignData == null ? "none" : Hex.toHexString(base64SignData)));
        }
        if (base64SignData == null) {
            throw new PKIException("851500", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64SignData");
        }
        byte[] asn1RS_RS = ASN1Parser.isBase64Encode(base64SignData) ? Base64.decode(base64SignData) : base64SignData;
        byte[] signature = null;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            signature = asn1RS_RS;
        } else if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            signature = this.decodedFromASN1(asn1RS_RS);
        } else {
            throw new PKIException("851501", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: base64SignData");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("decodedSignValue<<<<<<" + (signature == null ? "none" : Hex.toHexString(signature)));
        }
        return signature;
    }

    private final byte[] encodedToASN1(byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("encodedToASN1>>>>>>" + (signData == null ? "none" : Hex.toHexString(signData)));
        }
        byte[] signature = null;
        if (this.isNewFormat() && signData != null && signData.length == 64) {
            ASN1SM2Signature asn1 = new ASN1SM2Signature(signData);
            try {
                signature = asn1.getEncoded();
            }
            catch (IOException e) {
                throw new PKIException("851501", "\u7b7e\u540d\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: signData", e);
            }
        } else {
            signature = signData;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("encodedToASN1<<<<<<" + (signature == null ? "none" : Hex.toHexString(signature)));
        }
        return signature;
    }

    private final byte[] decodedFromASN1(byte[] asn1EncodedRS) {
        if (logger.isDebugEnabled()) {
            logger.debug("decodedFromASN1>>>>>>" + (asn1EncodedRS == null ? "none" : Hex.toHexString(asn1EncodedRS)));
        }
        if (asn1EncodedRS == null) {
            throw new SecurityException("Unknown signature value");
        }
        byte[] signature = null;
        if (this.isNewFormat()) {
            try {
                ASN1SM2Signature value = new ASN1SM2Signature(asn1EncodedRS);
                signature = value.getRS();
            }
            catch (PKIException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("invalid asn1EncodedRS<<<<<<" + (signature == null ? "none" : Hex.toHexString(signature)), e);
                }
                throw new SecurityException(e.getMessage(), e);
            }
            return signature;
        }
        signature = asn1EncodedRS;
        if (logger.isDebugEnabled()) {
            logger.debug("decodedFromASN1<<<<<<" + (signature == null ? "none" : Hex.toHexString(signature)));
        }
        return signature;
    }

    private final void checkHashLength(byte[] digest, String signAlg) throws PKIException {
        String algorithm = signAlg.toLowerCase();
        if (algorithm.indexOf("rsa") >= 0) {
            if (algorithm.indexOf("sha256") >= 0 && digest.length != 32) {
                throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
            }
            if (algorithm.indexOf("sha512") >= 0 && digest.length != 64) {
                throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
            }
            if (algorithm.indexOf("sha384") >= 0 && digest.length != 48) {
                throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
            }
            if (algorithm.indexOf("sha1") >= 0 && digest.length != 20) {
                throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
            }
            if (algorithm.indexOf("md5") >= 0 && digest.length != 16) {
                throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
            }
        }
        if (algorithm.indexOf("sm2") >= 0 && algorithm.indexOf("sm3") >= 0 && digest.length != 32) {
            throw new PKIException("851530", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u6563\u5217\u503c\u4e0d\u5339\u914d");
        }
    }

    private final void checkKeyType(Key key, String signAlg) throws PKIException {
        if (signAlg.toLowerCase().indexOf(key.getAlgorithm().toLowerCase()) < 0) {
            throw new PKIException("851531", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u7b7e\u540d\u5bc6\u94a5/\u6821\u9a8c\u5bc6\u94a5\u4e0d\u5339\u914d");
        }
    }

    private final void checkCertType(X509Cert cert, String signAlg) throws PKIException {
        if (signAlg.toLowerCase().indexOf(cert.getPublicKey().getAlgorithm().toLowerCase()) < 0) {
            throw new PKIException("851532", "\u7b7e\u540d\u5de5\u5177\u5305\u7b7e\u540d\u7b97\u6cd5\u548c\u7b7e\u540d\u8bc1\u4e66/\u6821\u9a8c\u8bc1\u4e66\u4e0d\u5339\u914d");
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(SignatureUtil.class);
    }
}

