/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util.cipher.lib;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cmbc.cfca.org.bouncycastle.math.ec.ECPoint;
import cmbc.cfca.rsa.signature.RSAPackageUtil;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cmbc.cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cmbc.cfca.sadk32.signature.sm2.SM2PackageUtil;
import cmbc.cfca.sm2.signature.SM2PrivateKey;
import cmbc.cfca.sm2.signature.SM2PublicKey;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.system.SM2Compatible;
import cmbc.cfca.util.cipher.lib.BaseLib;
import cmbc.cfca.util.cipher.lib.CMBCCustomUtils;
import cryptokit.SMJNI.SM2JNI;
import cryptokit.SMJNI.SM3JNI;
import cryptokit.jni.JNISM2;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class JNISoftLib
extends BaseLib {
    static final Logger logger;

    final KeyPair SM2GenerateKeyPair() throws PKIException {
        logger.debug("SM2GenerateKeyPair>>>>>>Running");
        try {
            byte[] d = new byte[32];
            byte[] pubx = new byte[32];
            byte[] puby = new byte[32];
            for (int i = 0; i < 6; ++i) {
                SM2JNI.generateKeypair(d, pubx, puby);
                if (d[0] != 0 && pubx[0] != 0 && puby[0] != 0) continue;
            }
            ECDomainParameters spec = SM2Params.sm2DomainParameters;
            ECPoint point = spec.getCurve().createPoint(new BigInteger(1, pubx), new BigInteger(1, puby));
            ECPublicKeyParameters pub = new ECPublicKeyParameters(point, spec);
            ECPrivateKeyParameters priv = new ECPrivateKeyParameters(new BigInteger(1, d), spec);
            SM2PublicKey pubKey = new SM2PublicKey(pub);
            SM2PrivateKey priKey = new SM2PrivateKey(priv);
            KeyPair keypair = new KeyPair(pubKey, priKey);
            logger.debug("SM2GenerateKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (Exception e) {
            logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
        catch (Error e) {
            logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
    }

    final KeyPair RSAGenerateKeyPair(int keyLength) throws PKIException {
        logger.debug("RSAGenerateKeyPair>>>>>>Running");
        if (keyLength <= 512 || keyLength > 4096) {
            throw new PKIException("key length is illgal:" + keyLength);
        }
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(keyLength);
            KeyPair keypair = keyPairGen.generateKeyPair();
            logger.debug("RSAGenerateKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (Exception e) {
            logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
        catch (Error e) {
            logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
    }

    final byte[] SM2Sign(byte[] hash, SM2PrivateKey sm2PrivateKey) throws PKIException {
        logger.debug("SM2Sign>>>>>>Running");
        try {
            byte[] returnBytes = SM2PackageUtil.encryptByJNI(hash, sm2PrivateKey.getD_Bytes());
            logger.debug("SM2Sign<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("SM2Sign<<<<<<Failure", e);
            throw new PKIException("SM2Sign Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Sign<<<<<<Failure", e);
            throw new PKIException("SM2Sign Failure", e);
        }
    }

    final boolean SM2Verify(byte[] hash, byte[] signData, SM2PublicKey sm2PublicKey) throws PKIException {
        logger.debug("SM2Verify>>>>>>Running");
        try {
            boolean returnFlag = SM2PackageUtil.verifyByJNI(hash, signData, sm2PublicKey.getPubX(), sm2PublicKey.getPubY());
            logger.debug("SM2Verify<<<<<<Finished");
            return returnFlag;
        }
        catch (Exception e) {
            logger.error("SM2Verify<<<<<<Failure", e);
            throw new PKIException("SM2Verify Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Verify<<<<<<Failure", e);
            throw new PKIException("SM2Verify Failure", e);
        }
    }

    final boolean SM2CMBCVerify(SM2PublicKey sm2PublicKey, byte[] signData, byte[] hash) throws PKIException {
        logger.debug("SM2CMBCVerify>>>>>>Running");
        try {
            boolean returnFlag = CMBCCustomUtils.verifyByHash(sm2PublicKey, hash, signData, true);
            logger.debug("SM2CMBCVerify<<<<<<Finished");
            return returnFlag;
        }
        catch (Exception e) {
            logger.error("SM2CMBCVerify<<<<<<Failure", e);
            throw new PKIException("SM2CMBCVerify Failure", e);
        }
        catch (Error e) {
            logger.error("SM2CMBCVerify<<<<<<Failure", e);
            throw new PKIException("SM2CMBCVerify Failure", e);
        }
    }

    final byte[] SM2Encrypt(SM2PublicKey sm2PublicKey, byte[] sourceData) throws PKIException {
        logger.debug("SM2Encrypt>>>>>>Running");
        try {
            int encryptedType;
            if (sourceData == null) {
                throw new PKIException("SM2Encrypt Failure: null not allowed for sourceData");
            }
            byte[] encryptedData = new byte[sourceData.length + 96];
            boolean jniReturnResult = JNISM2.encrypt(sourceData, sm2PublicKey.getPubX(), sm2PublicKey.getPubY(), encryptedData);
            if (!jniReturnResult) {
                throw new PKIException("SM2Encrypt Failure: jniReturnCode=" + jniReturnResult);
            }
            if (SM2Compatible.isOutputSM2EncryptedRAWC1C2C3()) {
                encryptedType = 16;
            } else {
                encryptedType = 1;
                ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptedData, 16);
                encryptedData = asn1.getEncryptedBytes(1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SM2Encrypt<<<<<<Finished: encryptedType=" + encryptedType);
            }
            return encryptedData;
        }
        catch (Exception e) {
            logger.error("SM2Encrypt<<<<<<Failure", e);
            throw new PKIException("SM2Encrypt Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Encrypt<<<<<<Failure", e);
            throw new PKIException("SM2Encrypt Failure", e);
        }
    }

    final byte[] SM2Decrypt(SM2PrivateKey sm2PrivateKey, byte[] encryptData) throws PKIException {
        logger.debug("SM2Decrypt>>>>>>Running");
        try {
            if (encryptData == null || encryptData.length < 92) {
                throw new PKIException("SM2Decrypt Failure: null or length not allowed for encryptData");
            }
            byte[] decryptedData = null;
            if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
                ASN1SM2Cipher encoding = new ASN1SM2Cipher(encryptData, 1);
                byte[] jniEncryptData = encoding.getEncryptedBytes(16);
                decryptedData = new byte[jniEncryptData.length - 96];
                boolean jniReturnResult = JNISM2.decrypt(jniEncryptData, sm2PrivateKey.getD_Bytes(), decryptedData);
                if (!jniReturnResult) {
                    throw new PKIException("SM2Decrypt Failure: jniReturnCode=" + jniReturnResult);
                }
            } else {
                boolean jniReturnResult;
                byte[] dBytes = sm2PrivateKey.getD_Bytes();
                decryptedData = new byte[encryptData.length - 96];
                try {
                    jniReturnResult = JNISM2.decrypt(encryptData, dBytes, decryptedData);
                }
                catch (Exception e) {
                    jniReturnResult = false;
                }
                if (!jniReturnResult && SM2Compatible.isCompatibleSM2DecryptedRAWC1C3C2()) {
                    ASN1SM2Cipher encoding = new ASN1SM2Cipher(encryptData, 4);
                    byte[] jniEncryptData = encoding.getEncryptedBytes(16);
                    jniReturnResult = JNISM2.decrypt(jniEncryptData, dBytes, decryptedData);
                }
                if (!jniReturnResult) {
                    throw new PKIException("SM2Decrypt Failure: jniReturnCode=" + jniReturnResult);
                }
            }
            logger.debug("SM2Decrypt<<<<<<Finished");
            return decryptedData;
        }
        catch (Exception e) {
            logger.error("SM2Decrypt<<<<<<Failure", e);
            throw new PKIException("SM2Decrypt Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Decrypt<<<<<<Failure", e);
            throw new PKIException("SM2Decrypt Failure", e);
        }
    }

    final byte[] SM3HashMessage(SM2PublicKey sm2PublicKey, byte[] sourceData, boolean withZ) throws PKIException {
        logger.debug("SM3HashMessage>>>>>>Running");
        try {
            byte[] hash = new byte[32];
            SM3JNI sm3_jni = new SM3JNI();
            if (withZ) {
                sm3_jni.update(sm2PublicKey.getDefaultZ());
            }
            sm3_jni.doFinal(sourceData, hash);
            logger.debug("SM3HashMessage<<<<<<Finished");
            return hash;
        }
        catch (Exception e) {
            logger.error("SM3HashMessage<<<<<<Failure", e);
            throw new PKIException("SM3HashMessage Failure", e);
        }
        catch (Error e) {
            logger.error("SM3HashMessage<<<<<<Failure", e);
            throw new PKIException("SM3HashMessage Failure", e);
        }
    }

    final byte[] RSASignEncrypt(RSAPrivateKey Key2, byte[] derHashValue) throws PKIException {
        logger.debug("RSASignEncrypt>>>>>>Running");
        try {
            byte[] returnBytes = RSAPackageUtil.encryptByJNI(derHashValue, Key2);
            logger.debug("RSASignEncrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSASignEncrypt<<<<<<Failure", e);
            throw new PKIException("RSASignEncrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSASignEncrypt<<<<<<Failure", e);
            throw new PKIException("RSASignEncrypt Failure", e);
        }
    }

    final byte[] RSAVerifyDecrypt(RSAPublicKey publicKey, byte[] signData) throws PKIException {
        logger.debug("RSAVerifyDecrypt>>>>>>Running");
        try {
            byte[] returnBytes = RSAPackageUtil.decryptByJNI(signData, publicKey);
            logger.debug("RSAVerifyDecrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSAVerifyDecrypt<<<<<<Failure", e);
            throw new PKIException("RSAVerifyDecrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSAVerifyDecrypt<<<<<<Failure", e);
            throw new PKIException("RSAVerifyDecrypt Failure", e);
        }
    }

    final byte[] RSAEncrypt(RSAPublicKey publicKey, byte[] sourceData, Mechanism mechanism) throws PKIException {
        logger.debug("RSAEncrypt>>>>>>Running");
        try {
            byte[] returnBytes = RSAPackageUtil.encryptByJNI(sourceData, publicKey);
            logger.debug("RSAEncrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSAEncrypt<<<<<<Failure", e);
            throw new PKIException("RSAEncrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSAEncrypt<<<<<<Failure", e);
            throw new PKIException("RSAEncrypt Failure", e);
        }
    }

    final byte[] RSADecrypt(RSAPrivateKey Key2, byte[] encryptedData, Mechanism mechanism) throws PKIException {
        logger.debug("RSADecrypt>>>>>>Running");
        try {
            byte[] returnBytes = RSAPackageUtil.decryptByJNI(encryptedData, Key2);
            logger.debug("RSADecrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSADecrypt<<<<<<Failure", e);
            throw new PKIException("RSADecrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSADecrypt<<<<<<Failure", e);
            throw new PKIException("RSADecrypt Failure", e);
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(JNISoftLib.class);
    }
}

