/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.pkcs.EncryptedData;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class EncryptedPrivateKeyInfo
extends ASN1Encodable {
    private AlgorithmIdentifier algId;
    private ASN1OctetString data;

    public EncryptedPrivateKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.data = (ASN1OctetString)enumeration.nextElement();
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.algId = algorithmIdentifier;
        this.data = new DEROctetString(byArray);
    }

    public static EncryptedPrivateKeyInfo getInstance(Object object) {
        if (object instanceof EncryptedData) {
            return (EncryptedPrivateKeyInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncryptedPrivateKeyInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.algId;
    }

    public byte[] getEncryptedData() {
        return this.data.getOctets();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(this.data);
        return new DERSequence(aSN1EncodableVector);
    }
}

