/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class X509NameTest
implements Test {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SN=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com"};

    public String getName() {
        return "X509Name";
    }

    private X509Name fromBytes(byte[] byArray) throws IOException {
        return X509Name.getInstance(new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject());
    }

    public TestResult perform() {
        Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
        hashtable.put(X509Name.C, "AU");
        hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
        hashtable.put(X509Name.L, "Melbourne");
        hashtable.put(X509Name.ST, "Victoria");
        hashtable.put(X509Name.E, "feedback-crypto@bouncycastle.org");
        X509Name x509Name = new X509Name(hashtable);
        if (!x509Name.equals(x509Name)) {
            return new SimpleTestResult(false, this.getName() + ": Failed same object test");
        }
        X509Name x509Name2 = new X509Name(hashtable);
        if (!x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed same name test");
        }
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        vector.addElement(X509Name.C);
        vector.addElement(X509Name.O);
        vector.addElement(X509Name.L);
        vector.addElement(X509Name.ST);
        vector.addElement(X509Name.E);
        Vector<DERObjectIdentifier> vector2 = new Vector<DERObjectIdentifier>();
        vector2.addElement(X509Name.E);
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (!x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed reverse name test");
        }
        vector2 = new Vector();
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed different name test");
        }
        vector2 = new Vector();
        vector2.addElement(X509Name.ST);
        vector2.addElement(X509Name.L);
        vector2.addElement(X509Name.O);
        vector2.addElement(X509Name.C);
        x509Name = new X509Name(vector, hashtable);
        x509Name2 = new X509Name(vector2, hashtable);
        if (x509Name.equals(x509Name2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed subset name test");
        }
        try {
            X509Name x509Name3;
            byte[] byArray = Hex.decode("305e310b300906035504061302415531283026060355040a131f546865204c6567696f6e206f662074686520426f756e637920436173746c6531253010060355040713094d656c626f75726e653011060355040b130a4173636f742056616c65");
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            X509Name x509Name4 = X509Name.getInstance(aSN1InputStream.readObject());
            if (!x509Name4.toString().equals("C=AU,O=The Legion of the Bouncy Castle,L=Melbourne+OU=Ascot Vale")) {
                return new SimpleTestResult(false, this.getName() + ": Failed composite to string test");
            }
            x509Name4 = new X509Name("C=AU, O=The Legion of the Bouncy Castle, L=Melbourne + OU=Ascot Vale");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(x509Name4);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (byArray.length != byArray2.length) {
                return new SimpleTestResult(false, this.getName() + ": Failed composite string to encoding test");
            }
            int n = 0;
            while (n != byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return new SimpleTestResult(false, this.getName() + ": Failed composite string to encoding test");
                }
                ++n;
            }
            int n2 = 0;
            while (n2 != this.subjects.length) {
                x509Name3 = new X509Name(this.subjects[n2]);
                byteArrayOutputStream = new ByteArrayOutputStream();
                aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                aSN1OutputStream.writeObject(x509Name3);
                aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                x509Name3 = X509Name.getInstance(aSN1InputStream.readObject());
                if (!x509Name3.toString().equals(this.subjects[n2])) {
                    return new SimpleTestResult(false, this.getName() + ": failed regeneration test " + n2);
                }
                ++n2;
            }
            x509Name3 = new X509Name("SN=BBB + CN=AA");
            if (!this.fromBytes(x509Name3.getEncoded()).toString().equals("CN=AA+SN=BBB")) {
                return new SimpleTestResult(false, this.getName() + ": failed sort test 1");
            }
            x509Name3 = new X509Name("CN=AA + SN=BBB");
            if (!this.fromBytes(x509Name3.getEncoded()).toString().equals("CN=AA+SN=BBB")) {
                return new SimpleTestResult(false, this.getName() + ": failed sort test 2");
            }
            x509Name3 = new X509Name("SN=B + CN=AA");
            if (!this.fromBytes(x509Name3.getEncoded()).toString().equals("SN=B+CN=AA")) {
                return new SimpleTestResult(false, this.getName() + ": failed sort test 3");
            }
            x509Name3 = new X509Name("CN=AA + SN=B");
            if (!this.fromBytes(x509Name3.getEncoded()).toString().equals("SN=B+CN=AA")) {
                return new SimpleTestResult(false, this.getName() + ": failed sort test 4");
            }
            x509Name3 = new X509Name("CN=AA + CN=AA + CN=AA");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception " + exception.getMessage(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        X509NameTest x509NameTest = new X509NameTest();
        TestResult testResult = x509NameTest.perform();
        System.out.println(testResult);
    }
}

