/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAPublicKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        DSAParameters dSAParameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = dSAParameters.getQ();
        BigInteger bigInteger3 = dSAParameters.getP();
        BigInteger bigInteger4 = dSAParameters.getG();
        while ((bigInteger = new BigInteger(160, secureRandom)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger5, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }
}

