/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.modes;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.params.ParametersWithIV;

public class PGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private byte[] tmp;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;
    private boolean inlineIv;

    public PGPCFBBlockCipher(BlockCipher blockCipher, boolean bl) {
        this.cipher = blockCipher;
        this.inlineIv = bl;
        this.blockSize = blockCipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.FR = new byte[this.blockSize];
        this.FRE = new byte[this.blockSize];
        this.tmp = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        if (this.inlineIv) {
            return this.cipher.getAlgorithmName() + "/PGPCFBwithIV";
        }
        return this.cipher.getAlgorithmName() + "/PGPCFB";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.inlineIv) {
            return this.forEncryption ? this.encryptBlockWithIV(byArray, n, byArray2, n2) : this.decryptBlockWithIV(byArray, n, byArray2, n2);
        }
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    public void reset() {
        this.count = 0;
        int n = 0;
        while (n != this.FR.length) {
            this.FR[n] = this.inlineIv ? (byte)0 : this.IV[n];
            ++n;
        }
        this.cipher.reset();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.IV.length) {
                System.arraycopy(byArray, 0, this.IV, this.IV.length - byArray.length, byArray.length);
                int n = 0;
                while (n < this.IV.length - byArray.length) {
                    this.IV[n] = 0;
                    ++n;
                }
            } else {
                System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            }
            this.reset();
            this.cipher.init(true, parametersWithIV.getParameters());
        } else {
            this.reset();
            this.cipher.init(true, cipherParameters);
        }
    }

    private byte encryptByte(byte by, int n) {
        return (byte)(this.FRE[n] ^ by);
    }

    private int encryptBlockWithIV(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count == 0) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n3 = 0;
            while (n3 < this.blockSize) {
                byArray2[n2 + n3] = this.encryptByte(this.IV[n3], n3);
                ++n3;
            }
            System.arraycopy(byArray2, n2, this.FR, 0, this.blockSize);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            byArray2[n2 + this.blockSize] = this.encryptByte(this.IV[this.blockSize - 2], 0);
            byArray2[n2 + this.blockSize + 1] = this.encryptByte(this.IV[this.blockSize - 1], 1);
            System.arraycopy(byArray2, n2 + 2, this.FR, 0, this.blockSize);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n4 = 0;
            while (n4 < this.blockSize) {
                byArray2[n2 + this.blockSize + 2 + n4] = this.encryptByte(byArray[n + n4], n4);
                ++n4;
            }
            System.arraycopy(byArray2, n2 + this.blockSize + 2, this.FR, 0, this.blockSize);
            this.count += 2 * this.blockSize + 2;
            return 2 * this.blockSize + 2;
        }
        if (this.count >= this.blockSize + 2) {
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n5 = 0;
            while (n5 < this.blockSize) {
                byArray2[n2 + n5] = this.encryptByte(byArray[n + n5], n5);
                ++n5;
            }
            System.arraycopy(byArray2, n2, this.FR, 0, this.blockSize);
        }
        return this.blockSize;
    }

    private int decryptBlockWithIV(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.count == 0) {
            int n3 = 0;
            while (n3 < this.blockSize) {
                this.FR[n3] = byArray[n + n3];
                ++n3;
            }
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            this.count += this.blockSize;
            return 0;
        }
        if (this.count == this.blockSize) {
            System.arraycopy(byArray, n, this.tmp, 0, this.blockSize);
            System.arraycopy(this.FR, 2, this.FR, 0, this.blockSize - 2);
            this.FR[this.blockSize - 2] = this.tmp[0];
            this.FR[this.blockSize - 1] = this.tmp[1];
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n4 = 0;
            while (n4 < this.blockSize - 2) {
                byArray2[n2 + n4] = this.encryptByte(this.tmp[n4 + 2], n4);
                ++n4;
            }
            System.arraycopy(this.tmp, 2, this.FR, 0, this.blockSize - 2);
            this.count += 2;
            return this.blockSize - 2;
        }
        if (this.count >= this.blockSize + 2) {
            System.arraycopy(byArray, n, this.tmp, 0, this.blockSize);
            byArray2[n2 + 0] = this.encryptByte(this.tmp[0], this.blockSize - 2);
            byArray2[n2 + 1] = this.encryptByte(this.tmp[1], this.blockSize - 1);
            System.arraycopy(this.tmp, 0, this.FR, this.blockSize - 2, 2);
            this.cipher.processBlock(this.FR, 0, this.FRE, 0);
            int n5 = 0;
            while (n5 < this.blockSize - 2) {
                byArray2[n2 + n5 + 2] = this.encryptByte(this.tmp[n5 + 2], n5);
                ++n5;
            }
            System.arraycopy(this.tmp, 2, this.FR, 0, this.blockSize - 2);
        }
        return this.blockSize;
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.cipher.processBlock(this.FR, 0, this.FRE, 0);
        int n3 = 0;
        while (n3 < this.blockSize) {
            byArray2[n2 + n3] = this.encryptByte(byArray[n + n3], n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.blockSize) {
            this.FR[n4] = byArray2[n2 + n4];
            ++n4;
        }
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.cipher.processBlock(this.FR, 0, this.FRE, 0);
        int n3 = 0;
        while (n3 < this.blockSize) {
            byArray2[n2 + n3] = this.encryptByte(byArray[n + n3], n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.blockSize) {
            this.FR[n4] = byArray[n + n4];
            ++n4;
        }
        return this.blockSize;
    }
}

