/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.digests.SHA512Digest;
import cn.com.infosec.util.encoders.Hex;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;

public class SHA512DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e";
    private static String testVec2 = "61";
    private static String resVec2 = "1f40fc92da241694750979ee6cf582f2d5d7d28e18335de05abc54d0560e0f5302860c652bf08d560252aa5e74210546f369fbbbce8c12cfc7957b2652fe9a75";
    private static String testVec3 = "616263";
    private static String resVec3 = "ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f";
    private static String testVec4 = "61626364656667686263646566676869636465666768696a6465666768696a6b65666768696a6b6c666768696a6b6c6d6768696a6b6c6d6e68696a6b6c6d6e6f696a6b6c6d6e6f706a6b6c6d6e6f70716b6c6d6e6f7071726c6d6e6f707172736d6e6f70717273746e6f707172737475";
    private static String resVec4 = "8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909";
    private static String testVec5 = "61616161616161616161";
    private static String resVec5 = "e718483d0ce769644e2e42c7bc15b4638e1f98b13b2044285632a803afa973ebde0ff244877ea60a4cb0432ce577c31beb009c5c2c49aa2e4eadb217ad8cc09b";

    public String getName() {
        return "SHA512";
    }

    public TestResult perform() {
        SHA512Digest sHA512Digest = new SHA512Digest();
        byte[] byArray = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode(byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "SHA-512 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode(testVec2);
        sHA512Digest.update(byArray2, 0, byArray2.length);
        sHA512Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "SHA-512 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec3);
        sHA512Digest.update(byArray2, 0, byArray2.length);
        sHA512Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "SHA-512 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec4);
        sHA512Digest.update(byArray2, 0, byArray2.length);
        sHA512Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA-512 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec4);
        sHA512Digest.update(byArray2, 0, byArray2.length / 2);
        SHA512Digest sHA512Digest2 = new SHA512Digest(sHA512Digest);
        sHA512Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA512Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA512 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        sHA512Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA512Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA512 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode(testVec5);
        int n = 0;
        while (n < 100000) {
            sHA512Digest.update(byArray2, 0, byArray2.length);
            ++n;
        }
        sHA512Digest.doFinal(byArray, 0);
        string = new String(Hex.encode(byArray));
        if (!resVec5.equals(string)) {
            return new SimpleTestResult(false, "SHA-512 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        SHA512DigestTest sHA512DigestTest = new SHA512DigestTest();
        TestResult testResult = sHA512DigestTest.perform();
        System.out.println(testResult);
    }
}

