/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ocsp.CertStatus;
import cn.com.infosec.asn1.ocsp.RevokedInfo;
import cn.com.infosec.asn1.ocsp.SingleResponse;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.ocsp.CertificateID;
import cn.com.infosec.ocsp.RevokedStatus;
import cn.com.infosec.ocsp.UnknownStatus;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SingleResp {
    SingleResponse resp;

    public SingleResp(SingleResponse singleResponse) {
        this.resp = singleResponse;
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public Object getCertStatus() {
        CertStatus certStatus = this.resp.getCertStatus();
        if (certStatus.getTagNo() == 0) {
            return null;
        }
        if (certStatus.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(certStatus.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        return simpleDateFormat.parse(this.resp.getThisUpdate().getTime(), new ParsePosition(0));
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        return simpleDateFormat.parse(this.resp.getNextUpdate().getTime(), new ParsePosition(0));
    }

    public X509Extensions getSingleExtensions() {
        return this.resp.getSingleExtensions();
    }
}

