/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.util;

import com.cib.fintech.dfp.open.sdk.exception.SdkExType;
import com.cib.fintech.dfp.open.sdk.exception.SdkException;
import com.cib.fintech.dfp.open.sdk.util.Base64;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SymmetricEncrypt {
    private static final BouncyCastleProvider BC = new BouncyCastleProvider();
    private static final String ALGORITHM_SM4 = "SM4";
    private static final String ALGORITHM_SM4_CBC_PKCS5 = "SM4/CBC/PKCS5Padding";
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_AES_CBC_PKCS5 = "AES/CBC/PKCS5Padding";
    private static final int SYMMETRIC_KEY_LENGTH = 128;
    private static final String SECURE_RANDOM_ALGORITHMS = "SHA1PRNG";
    private static final int SM4_KEY_LENGTH = 128;

    public static String aesEncrypt(String content, String reqParamEncryptKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES_CBC_PKCS5);
            IvParameterSpec iv = new IvParameterSpec(SymmetricEncrypt.initIv(ALGORITHM_AES_CBC_PKCS5));
            cipher.init(1, (Key)SymmetricEncrypt.getSecretKey(reqParamEncryptKey), iv);
            byte[] result = cipher.doFinal(content.getBytes("UTF-8"));
            return Base64.encode(result);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.REQ_PARAM_ENCRYPT_ERR);
        }
    }

    public static String aesDecrypt(String content, String reqParamEncryptKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES_CBC_PKCS5);
            IvParameterSpec iv = new IvParameterSpec(SymmetricEncrypt.initIv(ALGORITHM_AES_CBC_PKCS5));
            cipher.init(2, (Key)SymmetricEncrypt.getSecretKey(reqParamEncryptKey), iv);
            byte[] result = cipher.doFinal(Base64.decode(content));
            return new String(result, "UTF-8");
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.REQ_PARAM_ENCRYPT_ERR);
        }
    }

    private static SecretKeySpec getSecretKey(String symmetricKey) throws Exception {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(ALGORITHM_AES);
            SecureRandom random = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHMS);
            random.setSeed(symmetricKey.getBytes("UTF-8"));
            keyGenerator.init(128, random);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, ALGORITHM_AES);
            return secretKeySpec;
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.REQ_PARAM_ENCRYPT_ERR);
        }
    }

    public static String generateSM4Key() {
        byte[] keyBytes = SymmetricEncrypt.generateSM4KeyBytes();
        String stringKey = Base64.encode(keyBytes);
        return stringKey;
    }

    public static byte[] generateSM4KeyBytes() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(ALGORITHM_SM4, (Provider)BC);
        }
        catch (Exception e) {
            return null;
        }
        keyGenerator.init(128, new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    private static byte[] initIv(String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    private static byte[] initBCIv(String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm, (Provider)BC);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    public static String sm4Encrypt(String content, String reqParamEncryptKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_SM4_CBC_PKCS5, (Provider)BC);
            IvParameterSpec iv = new IvParameterSpec(SymmetricEncrypt.initBCIv(ALGORITHM_SM4_CBC_PKCS5));
            SecretKeySpec sm4Key = new SecretKeySpec(Base64.decode(reqParamEncryptKey), ALGORITHM_SM4);
            cipher.init(1, (Key)sm4Key, iv);
            byte[] result = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.encode(result);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.REQ_PARAM_ENCRYPT_ERR);
        }
    }

    public static String sm4Decrypt(String content, String reqParamEncryptKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_SM4_CBC_PKCS5, (Provider)BC);
            IvParameterSpec iv = new IvParameterSpec(SymmetricEncrypt.initBCIv(ALGORITHM_SM4_CBC_PKCS5));
            SecretKeySpec sm4Key = new SecretKeySpec(Base64.decode(reqParamEncryptKey), ALGORITHM_SM4);
            cipher.init(2, (Key)sm4Key, iv);
            byte[] result = cipher.doFinal(Base64.decode(content));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.REQ_PARAM_ENCRYPT_ERR);
        }
    }
}

