/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.DSA;
import com.nbcb.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.nbcb.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.nbcb.bouncycastle.crypto.signers.ECDSASigner;
import com.nbcb.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.nbcb.bouncycastle.crypto.tls.TlsDSASigner;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

