/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.aes.utils.JsonUtils;
import com.nbcb.sdk.gm.SM2Utils;
import com.nbcb.sdk.gm.SM3Utils;
import com.nbcb.sdk.gm.Utils;
import com.nbcb.sdk.gm.gmnew.SM4Utils;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.JsonHelperFactory;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.util.Map;
import java.util.TreeMap;

public class ApproveDevService {
    private static Log log = NbczLogger.getLog(ApproveDevService.class);

    public static byte[] encry(SDKRequestHead head, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        String reqStr = ApproveDevService.encryString(head, randomKey, cntrKey, syncKey);
        byte[] value = reqStr.getBytes("UTF-8");
        return value;
    }

    public static String encryString(SDKRequestHead head, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        StringBuilder reqSB = new StringBuilder("{");
        String hashstr1 = head.getAPP_Key() + head.getRndm_Num() + head.getMAC_Adr() + head.getIP_Adr();
        byte[] hashByte = SM3Utils.hash(hashstr1.getBytes());
        byte[] signValueByte = SM2Utils.signByPrivateKey(hashByte, KeyStoreFactory.getInstance().getmerchantPrivatekey());
        head.setSgn(Utils.encryptByBASE64(signValueByte));
        String headJson = JsonUtils.objToJSON(head);
        String cntrKeyBase64 = Utils.encryptByBASE64(cntrKey);
        JsonUtils.appendField(reqSB, "CntrKey", cntrKeyBase64, true);
        String syncKeyBase64 = Utils.encryptByBASE64(syncKey);
        JsonUtils.appendField(reqSB, "SyncKey", syncKeyBase64, false);
        String data = reqSB.toString();
        reqSB = new StringBuilder("{");
        JsonUtils.appendStruct(reqSB, "Head", headJson, true);
        JsonUtils.appendStruct(reqSB, "Data", data, false);
        byte[] reqByte = reqSB.toString().getBytes("UTF-8");
        reqSB = new StringBuilder("{");
        byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
        JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
        byte[] randomKeyByRSA = SM2Utils.encrypt(randomKey, KeyStoreFactory.getInstance().getOpenPublicKey());
        JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByRSA), false);
        return reqSB.toString();
    }

    public static void decry(byte[] resp, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        ApproveDevService.decryString(new String(resp, "UTF-8"), randomKey, cntrKey, syncKey);
    }

    public static String decryString(String resp, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        Map<String, Object> mapObj = jsonHelper.getMapObj(resp, Object.class);
        String scrtData = (String)mapObj.get("ScrtData");
        if (scrtData == null) {
            ApproveDevService.checkApproveDevRes(mapObj, jsonHelper);
        }
        String sign = (String)mapObj.get("ScrtSgn");
        byte[] respByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(scrtData));
        String respMsg = new String(respByte, "UTF-8");
        log.info("\u5f00\u53d1\u8005\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587=[" + respMsg + "]");
        byte[] signByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(sign));
        boolean signValue = SM2Utils.verifyByPublicKey(respByte, KeyStoreFactory.getInstance().getOpenPublicKey(), Utils.decryptByBASE64(new String(signByte)));
        if (!signValue) {
            throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
        }
        Map<String, Object> dataMap = jsonHelper.getMapObj(respMsg, Object.class);
        String data = jsonHelper.toJSONString(dataMap.get("Data"));
        String headstr = jsonHelper.toJSONString(dataMap.get("Head"));
        Map<String, String> head = JsonUtils.getMapObj(headstr);
        Map<String, String> map = JsonUtils.getMapObj(data);
        TreeMap<String, Object> tokenMap = new TreeMap<String, Object>();
        if (map.containsKey("CntrKey") && map.containsKey("SyncKey")) {
            cntrKey = Utils.decryptByBASE64(map.get("CntrKey"));
            syncKey = Utils.decryptByBASE64(map.get("SyncKey"));
        }
        tokenMap.put("CntrKey", cntrKey);
        tokenMap.put("SyncKey", syncKey);
        tokenMap.put("APP_Token", map.get("APP_Token"));
        tokenMap.put("expirein", map.get("expirein"));
        tokenMap.put("expires", map.get("expires"));
        tokenMap.put("startTime", map.get("startTime"));
        tokenMap.put("updatetime", map.get("updatetime"));
        tokenMap.put("Txn_Rsp_Cd_Dsc", head.get("Txn_Rsp_Cd_Dsc"));
        tokenMap.put("Txn_Rsp_Inf", head.get("Txn_Rsp_Inf"));
        tokenMap.put("SYS_RESP_CODE", head.get("SYS_RESP_CODE"));
        tokenMap.put("SYS_RESP_DESC", head.get("SYS_RESP_DESC"));
        KeyStoreFactory.getInstance().setTokenMap(tokenMap);
        return respMsg;
    }

    private static void checkApproveDevRes(Map<String, Object> mapObj, JsonHelper jsonHelper) throws SDKException {
        if (mapObj.get("Data") == null) {
            return;
        }
        String data = jsonHelper.toJSONString(mapObj.get("Data"));
        Map<String, String> dataMap = jsonHelper.getMapObj(data);
        String retCode = dataMap.get("retCode");
        String retMsg = dataMap.get("retMsg");
        if (retCode != null) {
            SDKExceptionEnums sdk = SDKExceptionEnums.CONSTANT_ERROR;
            sdk.setCode(retCode);
            sdk.setMessage(retMsg);
            throw new SDKException(sdk);
        }
    }

    public static byte[] encry(String appkey, SDKRequestHead head, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        String reqStr = ApproveDevService.encryString(appkey, head, randomKey, cntrKey, syncKey);
        byte[] value = reqStr.getBytes("UTF-8");
        return value;
    }

    public static String encryString(String appkey, SDKRequestHead head, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        StringBuilder reqSB = new StringBuilder("{");
        String hashstr1 = head.getAPP_Key() + head.getRndm_Num() + head.getMAC_Adr() + head.getIP_Adr();
        byte[] hashByte = SM3Utils.hash(hashstr1.getBytes());
        byte[] signValueByte = SM2Utils.signByPrivateKey(hashByte, ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getmerchantPrivatekey());
        head.setSgn(Utils.encryptByBASE64(signValueByte));
        String headJson = JsonUtils.objToJSON(head);
        String cntrKeyBase64 = Utils.encryptByBASE64(cntrKey);
        JsonUtils.appendField(reqSB, "CntrKey", cntrKeyBase64, true);
        String syncKeyBase64 = Utils.encryptByBASE64(syncKey);
        JsonUtils.appendField(reqSB, "SyncKey", syncKeyBase64, false);
        String data = reqSB.toString();
        reqSB = new StringBuilder("{");
        JsonUtils.appendStruct(reqSB, "Head", headJson, true);
        JsonUtils.appendStruct(reqSB, "Data", data, false);
        byte[] reqByte = reqSB.toString().getBytes("UTF-8");
        reqSB = new StringBuilder("{");
        byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
        JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
        byte[] randomKeyByRSA = SM2Utils.encrypt(randomKey, ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getOpenPublicKey());
        JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByRSA), false);
        return reqSB.toString();
    }

    public static void decry(String appkey, byte[] resp, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        ApproveDevService.decryString(appkey, new String(resp, "UTF-8"), randomKey, cntrKey, syncKey);
    }

    public static String decryString(String appkey, String resp, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        Map<String, Object> mapObj = jsonHelper.getMapObj(resp, Object.class);
        String scrtData = (String)mapObj.get("ScrtData");
        if (scrtData == null) {
            ApproveDevService.checkApproveDevRes(mapObj, jsonHelper);
        }
        String sign = (String)mapObj.get("ScrtSgn");
        byte[] respByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(scrtData));
        String respMsg = new String(respByte, "UTF-8");
        log.info("\u5f00\u53d1\u8005\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587=[" + respMsg + "]");
        byte[] signByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(sign));
        boolean signValue = SM2Utils.verifyByPublicKey(respByte, ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getOpenPublicKey(), Utils.decryptByBASE64(new String(signByte)));
        if (!signValue) {
            throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
        }
        Object dataObj = jsonHelper.getMapObj(respMsg, Object.class).get("Data");
        String data = jsonHelper.toJSONString(dataObj);
        Object headObj = jsonHelper.getMapObj(respMsg, Object.class).get("Head");
        Map<String, String> head = jsonHelper.getMapObj(jsonHelper.toJSONString(headObj));
        Map<String, String> map = JsonUtils.getMapObj(data);
        TreeMap<String, Object> tokenMap = new TreeMap<String, Object>();
        if (map.containsKey("CntrKey") && map.containsKey("SyncKey")) {
            cntrKey = Utils.decryptByBASE64(map.get("CntrKey"));
            syncKey = Utils.decryptByBASE64(map.get("SyncKey"));
        }
        tokenMap.put("CntrKey", cntrKey);
        tokenMap.put("SyncKey", syncKey);
        tokenMap.put("APP_Token", map.get("APP_Token"));
        tokenMap.put("expirein", map.get("expirein"));
        tokenMap.put("expires", map.get("expires"));
        tokenMap.put("startTime", map.get("startTime"));
        tokenMap.put("updatetime", map.get("updatetime"));
        tokenMap.put("Txn_Rsp_Cd_Dsc", head.get("Txn_Rsp_Cd_Dsc"));
        tokenMap.put("Txn_Rsp_Inf", head.get("Txn_Rsp_Inf"));
        tokenMap.put("SYS_RESP_CODE", head.get("SYS_RESP_CODE"));
        tokenMap.put("SYS_RESP_DESC", head.get("SYS_RESP_DESC"));
        ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().setTokenMap(tokenMap);
        return respMsg;
    }

    public static boolean IsCliperText(String respStr) {
        try {
            JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
            Map<String, Object> jsonObject = jsonHelper.parseObject(respStr);
            if (jsonObject.containsKey("Head")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

