/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.MechanismKit;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.CSRPublicKeyHelper;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.openssl.PEMParser;
import cfca.sadk.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.Signature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PublicKey;

abstract class CSRDecoder {
    private static final String CHARSET = "ASCII";
    private static final int MIN_LENGTH = 100;
    static final String HEADLINE_CERTIFICATE_REQUEST = "CERTIFICATE REQUEST";

    CSRDecoder() {
    }

    static final PKCS10CertificationRequest decodedCertificationRequest(byte[] p10Data) throws PKIException {
        PKCS10CertificationRequest certificationRequest;
        if (p10Data == null) {
            throw new PKIException("decodedCertificationRequest  failed: p10Data==null");
        }
        if (p10Data.length < 100) {
            throw new PKIException("decodedCertificationRequest  failed: p10Data<100");
        }
        if (p10Data[0] == 48) {
            certificationRequest = CSRDecoder.decodedPKCS10CertificationRequestFromDER(p10Data);
        } else {
            String lines = Strings.fromByteArray(Arrays.copyOfRange(p10Data, 0, 100)).trim();
            if (lines.charAt(0) == 'M') {
                certificationRequest = CSRDecoder.decodedPKCS10CertificationRequestFromBase64(p10Data);
            } else if (lines.indexOf(HEADLINE_CERTIFICATE_REQUEST) > 0) {
                certificationRequest = CSRDecoder.decodedPKCS10CertificationRequestFromPEM(p10Data);
            } else {
                throw new PKIException("decodedCertificationRequest  failed: PKCS10CertificationRequest malformed base64P10Data");
            }
        }
        return certificationRequest;
    }

    private static final PKCS10CertificationRequest decodedPKCS10CertificationRequestFromDER(byte[] asn1P10Data) throws PKIException {
        try {
            return new PKCS10CertificationRequest(asn1P10Data);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decodedCertificationRequest  failed: malformed asn1P10Data=" + SADKDebugger.dump(asn1P10Data), (Throwable)e);
            throw new PKIException("decodedCertificationRequest  failed: malformed asn1P10Data", e);
        }
    }

    private static final PKCS10CertificationRequest decodedPKCS10CertificationRequestFromBase64(byte[] base64P10Data) throws PKIException {
        byte[] asn1P10Data;
        try {
            asn1P10Data = Base64.decode(base64P10Data);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decodedCertificationRequest  failed: malformed base64P10Data=" + SADKDebugger.dumpBase64(base64P10Data), (Throwable)e);
            throw new PKIException("decodedCertificationRequest  failed: malformed base64P10Data", e);
        }
        try {
            return new PKCS10CertificationRequest(asn1P10Data);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decodedCertificationRequest  failed: malformed base64P10Data=" + SADKDebugger.dumpBase64(asn1P10Data), (Throwable)e);
            throw new PKIException("decodedCertificationRequest  failed: malformed base64P10Data", e);
        }
    }

    private static final PKCS10CertificationRequest decodedPKCS10CertificationRequestFromPEM(byte[] pemP10Data) throws PKIException {
        Object object;
        try {
            PEMParser parser = new PEMParser(new InputStreamReader((InputStream)new ByteArrayInputStream(pemP10Data), CHARSET));
            object = parser.readObject();
            parser.close();
        }
        catch (IOException e) {
            LoggerManager.exceptionLogger.error("decodedCertificationRequest  failed: PKCS10CertificationRequest malformed pemP10Data=" + SADKDebugger.dumpBase64(pemP10Data));
            throw new PKIException("decodedCertificationRequest  failed: PKCS10CertificationRequest malformed pemP10Data", e);
        }
        if (object instanceof PKCS10CertificationRequest) {
            return (PKCS10CertificationRequest)object;
        }
        LoggerManager.exceptionLogger.error("decodedCertificationRequest  failed: PKCS10CertificationRequest malformed pemP10Data=" + SADKDebugger.dumpBase64(pemP10Data));
        throw new PKIException("decodedCertificationRequest  failed: PKCS10CertificationRequest malformed pemP10Data");
    }

    static final boolean isP10RequestSignatureValid(byte[] base64P10RequestData) throws PKIException {
        byte[] signature;
        PublicKey key;
        String sigAlgName;
        byte[] sourceData;
        PKCS10CertificationRequest p10 = CSRDecoder.decodedCertificationRequest(base64P10RequestData);
        try {
            sourceData = p10.toASN1Structure().getCertificationRequestInfo().getEncoded("DER");
        }
        catch (IOException e) {
            throw new PKIException("isP10RequestSignatureValid  failed: sourceData get failure");
        }
        try {
            sigAlgName = CSRDecoder.getValidSignatureAlgName(p10.getSignatureAlgorithm());
        }
        catch (PKIException e) {
            throw new PKIException("isP10RequestSignatureValid  failed: sigAlgName get failure", e);
        }
        try {
            key = CSRPublicKeyHelper.buildPublicKeyFrom(p10.getSubjectPublicKeyInfo());
        }
        catch (PKIException e) {
            throw new PKIException("isP10RequestSignatureValid  failed: PublicKey get failure", e);
        }
        try {
            signature = p10.getSignature();
        }
        catch (Exception e) {
            throw new PKIException("isP10RequestSignatureValid  failed: signature get failure", e);
        }
        try {
            byte[] signValue = Base64.encode(signature);
            boolean isValid = new Signature().p1VerifyMessage(sigAlgName, sourceData, signValue, key, BCSoftLib.INSTANCE());
            if (!isValid) {
                LoggerManager.exceptionLogger.error("isP10RequestSignatureValid  failed: p1VerifyMessage False-->" + SADKDebugger.dump(base64P10RequestData));
            }
            return isValid;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("isP10RequestSignatureValid  failed: p1VerifyMessage failure-->" + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("isP10RequestSignatureValid  failed: p1VerifyMessage failure", e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("isP10RequestSignatureValid  failed: p1VerifyMessage failure-->" + SADKDebugger.dump(base64P10RequestData), (Throwable)e);
            throw new PKIException("isP10RequestSignatureValid  failed: p1VerifyMessage failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("isP10RequestSignatureValid  failed: p1VerifyMessage failure-->" + SADKDebugger.dump(base64P10RequestData), e);
            throw new PKIException("isP10RequestSignatureValid  failed: p1VerifyMessage failure", e);
        }
    }

    static final String getSubjectFromP10Request(byte[] base64P10RequestData) throws PKIException {
        PKCS10CertificationRequest p10 = CSRDecoder.decodedCertificationRequest(base64P10RequestData);
        String subject = null;
        try {
            subject = p10.getSubject().toString();
        }
        catch (Exception e) {
            throw new PKIException("getSubjectFromP10Request Failure: " + e.getMessage(), e);
        }
        return subject;
    }

    static final String getSignatureAlgorithmFromP10Request(byte[] base64P10RequestData) throws PKIException {
        PKCS10CertificationRequest p10 = CSRDecoder.decodedCertificationRequest(base64P10RequestData);
        return CSRDecoder.getValidSignatureAlgName(p10.getSignatureAlgorithm());
    }

    static final byte[] getSignatureFromP10Request(byte[] base64P10RequestData) throws PKIException {
        PKCS10CertificationRequest p10 = CSRDecoder.decodedCertificationRequest(base64P10RequestData);
        return p10.getSignature();
    }

    static final String getValidSignatureAlgName(AlgorithmIdentifier signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("getValidSignatureAlgName  failed: signatureAlgorithm==null");
        }
        ASN1ObjectIdentifier algorithm = signatureAlgorithm.getAlgorithm();
        if (algorithm == null) {
            throw new PKIException("getValidSignatureAlgName  failed: algorithm==null");
        }
        String algorithmName = MechanismKit.OIDALGMap.get(algorithm);
        if (algorithmName == null) {
            throw new PKIException("getValidSignatureAlgName  failed:  dot not support algorithmName=" + signatureAlgorithm);
        }
        return algorithmName;
    }
}

