/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoInfo;
import cfca.sadk.extend.session.link.ICryptoLink;
import cfca.sadk.extend.session.link.jni.CryptoLinkImp;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.lib.crypto.DeviceInfo;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNIInit;
import cryptokit.jni.JNISDF;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CryptoLinkManager {
    private final long warningTimeThreshold;
    private final long sessionHandleTimeout;
    private final ICryptoLink cryptoAPI;
    private final LinkedBlockingQueue<Long> sessionHandles;
    private String deviceInfo = null;
    private final long deviceHandle;
    private final long sessionHandle;
    private final boolean sessionsEnabled;
    private static volatile CryptoLinkManager SINGLETON = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoLinkManager getSingleton(CryptoInfo cryptoInfo) throws CryptoException {
        if (SINGLETON != null) return SINGLETON;
        Class<CryptoLinkManager> clazz = CryptoLinkManager.class;
        synchronized (CryptoLinkManager.class) {
            if (SINGLETON != null) return SINGLETON;
            CryptoLinkManager manager = new CryptoLinkManager(cryptoInfo);
            LoggerManager.systemLogger.info("CryptoManager build instance {}", (Object)manager);
            SINGLETON = manager;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SINGLETON;
        }
    }

    public CryptoLinkManager(CryptoInfo cryptoInfo) throws CryptoException {
        long strTime = System.currentTimeMillis();
        if (cryptoInfo == null) {
            throw new CryptoException("CryptoLinkManager construct failed: cryptoInfo is NULL");
        }
        String sdfLibPath = cryptoInfo.getSdfLibPath();
        long warningTimeThreshold = cryptoInfo.getWarningTimeThreshold();
        int sessionNumber = cryptoInfo.getSessionNumber();
        long sessionHandleTimeout = cryptoInfo.getSessionTimeout();
        boolean supportIdleTest = cryptoInfo.isSupportIdleTest();
        LoggerManager.systemLogger.info("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={},supportIdleTest={})", new Object[]{sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout, supportIdleTest});
        try {
            JNIInit.initOpenSSL();
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoSessionManager construct initOpenSSL failed", e);
            throw new CryptoException("CryptoSessionManager construct initOpenSSL failed", e);
        }
        try {
            CryptoLinkImp cryptoAPI = new CryptoLinkImp(new JNISDF(), warningTimeThreshold, supportIdleTest);
            this.warningTimeThreshold = warningTimeThreshold;
            this.sessionHandleTimeout = sessionHandleTimeout < 0L ? 5000L : sessionHandleTimeout;
            cryptoAPI.loadSDFLib(sdfLibPath);
            long deviceHandle = cryptoAPI.openDevice();
            LoggerManager.systemLogger.info("deviceHandle={}", (Object)deviceHandle);
            this.deviceHandle = deviceHandle;
            this.cryptoAPI = cryptoAPI;
            if (sessionNumber <= 0) {
                this.sessionsEnabled = false;
                this.sessionHandle = cryptoAPI.openSession(deviceHandle);
                this.sessionHandles = null;
                LoggerManager.systemLogger.info("sessionsEnabled={}, sessionHandle={}", (Object)this.sessionsEnabled, (Object)this.sessionHandle);
            } else {
                this.sessionsEnabled = true;
                this.sessionHandle = 0L;
                this.sessionHandles = this.openCryptoSession(cryptoAPI, deviceHandle, sessionNumber);
                LoggerManager.systemLogger.info("sessionsEnabled={}, sessionNumber={}", (Object)this.sessionsEnabled, (Object)this.sessionHandles.size());
            }
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("CryptoSessionManager construct failed", (Throwable)e);
            throw e;
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={})", new Object[]{sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout});
        } else {
            LoggerManager.systemLogger.info("CryptoSessionManager construct(sdfLibPath={},warningTimeThreshold={},sessionNumber={},sessionHandleTimeout={})", new Object[]{sdfLibPath, warningTimeThreshold, sessionNumber, sessionHandleTimeout});
        }
    }

    private final LinkedBlockingQueue<Long> openCryptoSession(ICryptoLink cryptoAPI, long deviceHandle, int sessionNumber) throws CryptoException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("OpenCryptoSession...");
        LinkedBlockingQueue<Long> sessionHandles = new LinkedBlockingQueue<Long>();
        try {
            int i = 0;
            while (i < sessionNumber) {
                long session = cryptoAPI.openSession(deviceHandle);
                LoggerManager.systemLogger.info("OpenCryptoSession sessionHandle#{}={}", (Object)(++i), (Object)session);
                sessionHandles.add(session);
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("OpenCryptoSession failed", (Throwable)e);
            throw new CryptoException("OpenCryptoSession failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("OpenCryptoSession failed", e);
            throw new CryptoException("OpenCryptoSession failed", e);
        }
        LoggerManager.systemLogger.info("OpenCryptoSession Successfully!");
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("OpenCryptoSession costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("OpenCryptoSession costTime={}", (Object)costTime);
        }
        return sessionHandles;
    }

    protected final Long pollSessionHandle() throws CryptoException {
        Long sessionHandle;
        if (this.sessionsEnabled) {
            long strTime = System.currentTimeMillis();
            try {
                sessionHandle = this.sessionHandles.poll(this.sessionHandleTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LoggerManager.exceptionLogger.error("pollSessionHandle throw InterruptedException", (Throwable)e);
                throw new CryptoException("pollSessionHandle throw InterruptedException", e);
            }
            if (sessionHandle == null) {
                LoggerManager.exceptionLogger.error("pollSessionHandle timeout in {} milliseconds", (Object)this.sessionHandleTimeout);
                throw new CryptoException("pollSessionHandle timeout in " + this.sessionHandleTimeout + " milliseconds");
            }
            long costTime = System.currentTimeMillis() - strTime;
            if (costTime > this.warningTimeThreshold) {
                LoggerManager.timeoutLogger.warn("pollSessionHandle sessionHandle={},costTime={}, pollTimeout={}", new Object[]{NumberHelper.hex(sessionHandle), costTime, this.sessionHandleTimeout});
            } else {
                LoggerManager.systemLogger.info("pollSessionHandle sessionHandle={},costTime={}, pollTimeout={}", new Object[]{NumberHelper.hex(sessionHandle), costTime, this.sessionHandleTimeout});
            }
        } else {
            sessionHandle = this.sessionHandle;
        }
        return sessionHandle;
    }

    protected final void releaseSessionHandle(Long sessionHandle) throws CryptoException {
        if (this.sessionsEnabled && sessionHandle != null) {
            LoggerManager.systemLogger.info("releaseSessionHandle sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
            this.sessionHandles.add(sessionHandle);
        }
    }

    protected final boolean idleTest() throws CryptoException {
        LoggerManager.systemLogger.info("idleTest running: ");
        boolean idleTestResult = false;
        Long sessionHandle = null;
        try {
            sessionHandle = this.pollSessionHandle();
            LoggerManager.systemLogger.info("idleTest sessionHandle: {}", (Object)NumberHelper.hex(sessionHandle));
            int returnValue = this.cryptoAPI.idleTest(sessionHandle);
            LoggerManager.systemLogger.info("idleTest sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
            boolean bl = idleTestResult = returnValue == 0;
            if (!idleTestResult) {
                LoggerManager.exceptionLogger.error("idleTest sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
                throw new CryptoException("idleTest failed: returnValue=" + NumberHelper.hex(returnValue));
            }
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("idleTest failed");
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("idleTest failed");
            throw new CryptoException("idleTest failed", e);
        }
        finally {
            if (this.sessionsEnabled && sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        LoggerManager.systemLogger.info("idleTest passed");
        return idleTestResult;
    }

    final synchronized String getDeviceInfo() {
        if (this.deviceInfo == null) {
            byte[] deivceBytes = null;
            try {
                deivceBytes = this.getDeviceInfoBytes();
                String deviceVersion = Strings.fromByteArray(deivceBytes);
                LoggerManager.systemLogger.info("decodeDeviceInfo deviceVersion: {}", (Object)deviceVersion);
                DeviceInfo device = this.decodeDeviceInfo(deviceVersion);
                LoggerManager.systemLogger.info("decodeDeviceInfo deviceInfo: {}", (Object)device);
                this.deviceInfo = deviceVersion;
            }
            catch (CryptoException e) {
                LoggerManager.exceptionLogger.error("decodeDeviceInfo failed", (Object)Hex.toHexString(deivceBytes));
            }
        }
        return this.deviceInfo;
    }

    final byte[] getDeviceInfoBytes() throws CryptoException {
        LoggerManager.systemLogger.info("GetDeviceInfo running: ");
        byte[] deviceInfo = new byte[64];
        long sessionHandle = 0L;
        try {
            sessionHandle = this.cryptoAPI.openSession(this.deviceHandle);
            LoggerManager.systemLogger.info("getDeviceInfo sessionHandle: {}", (Object)NumberHelper.hex(sessionHandle));
            int returnResult = this.cryptoAPI.getDeviceInfo(sessionHandle, deviceInfo);
            if (returnResult != 0) {
                LoggerManager.exceptionLogger.error("GetDeviceInfo failed: returnResult={}", (Object)NumberHelper.hex(returnResult));
                throw new CryptoException("GetDeviceInfo failed: returnResult=" + NumberHelper.hex(returnResult));
            }
            LoggerManager.systemLogger.info("GetDeviceInfo sessionHandle: {}, returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("GetDeviceInfo failed");
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GetDeviceInfo failed");
            throw new CryptoException("GetDeviceInfo failed", e);
        }
        finally {
            if (sessionHandle != 0L) {
                this.cryptoAPI.closeSession(sessionHandle);
            }
        }
        LoggerManager.systemLogger.info("GetDeviceInfo passed: deviceInfo={}", (Object)SADKDebugger.dump(deviceInfo));
        return deviceInfo;
    }

    ICryptoLink getCryptoAPI() {
        return this.cryptoAPI;
    }

    public DeviceInfo[] getDeviceInfos() throws CryptoException {
        LoggerManager.systemLogger.info("getDeviceInfos running: ");
        Long sessionHandle = null;
        byte[] devicesInfoOutput = new byte[1024];
        try {
            sessionHandle = this.pollSessionHandle();
            LoggerManager.systemLogger.info("getDeviceInfos sessionHandle: {}", (Object)NumberHelper.hex(sessionHandle));
            int returnValue = this.cryptoAPI.getSNAndHwVersion(sessionHandle, devicesInfoOutput);
            LoggerManager.systemLogger.info("getDeviceInfos sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
            if (returnValue != 0) {
                LoggerManager.exceptionLogger.error("getDeviceInfos sessionHandle: {}, returnValue={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnValue));
                throw new CryptoException("getDeviceInfos failed: returnValue=" + NumberHelper.hex(returnValue));
            }
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("getDeviceInfos failed");
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getDeviceInfos failed");
            throw new CryptoException("getDeviceInfos failed", e);
        }
        finally {
            if (this.sessionsEnabled && sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        LoggerManager.systemLogger.info("getDeviceInfos passed: devicesInfoOutput={}", (Object)SADKDebugger.dump(devicesInfoOutput));
        return this.decodeDevicesInfo(devicesInfoOutput);
    }

    private DeviceInfo[] decodeDevicesInfo(byte[] devicesInfoBytes) throws CryptoException {
        DeviceInfo[] deviceInfoItems = null;
        if (devicesInfoBytes != null) {
            int len = 0;
            while (len++ < devicesInfoBytes.length && devicesInfoBytes[len] != 0) {
            }
            if (len > 0) {
                byte[] versionsBytes = new byte[len];
                System.arraycopy(devicesInfoBytes, 0, versionsBytes, 0, len);
                String devicesInfo = Strings.fromByteArray(versionsBytes);
                LoggerManager.systemLogger.info("decodeDevicesInfo devicesInfo: {}", (Object)devicesInfo);
                String[] versions = devicesInfo.split(";");
                deviceInfoItems = new DeviceInfo[versions.length];
                for (int i = 0; i < versions.length; ++i) {
                    deviceInfoItems[i] = this.decodeDeviceInfo(versions[i]);
                }
            }
        }
        return deviceInfoItems;
    }

    private DeviceInfo decodeDeviceInfo(String values) throws CryptoException {
        DeviceInfo deviceInfo = null;
        if (values != null) {
            int cardType;
            String[] tokens = values.split("\\|");
            if (tokens.length < 3) {
                throw new CryptoException("decodeDeviceInfo failed: invalid values->" + values);
            }
            try {
                cardType = Integer.parseInt(tokens[0]);
            }
            catch (NumberFormatException e) {
                throw new CryptoException("decodeDeviceInfo failed: invalid values->" + values, e);
            }
            String deviceSerialNumber = tokens[1];
            String firewareVersion = tokens[2];
            String pcbVersion = tokens.length > 3 ? tokens[3] : null;
            String seVersion = tokens.length > 4 ? tokens[4] : null;
            deviceInfo = new DeviceInfo(cardType, deviceSerialNumber, firewareVersion, pcbVersion, seVersion);
            LoggerManager.systemLogger.info("decodeDeviceInfo deviceInfo: {}", (Object)deviceInfo);
        }
        return deviceInfo;
    }
}

