/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import java.io.BufferedInputStream;
import java.io.InputStream;

final class SM2CardHashHelper {
    private SM2CardHashHelper() {
    }

    static final byte[] sm3(GMTKey cardKey, InputStream stream) throws CryptoException {
        if (stream == null) {
            throw new CryptoException("sm3 missing stream");
        }
        byte[] hashValue = new byte[32];
        BufferedInputStream sourceData = null;
        try {
            SM3Digest digest = new SM3Digest();
            if (cardKey != null) {
                byte[] zvalue = cardKey.getDefaultZ();
                if (zvalue == null) {
                    throw new CryptoException("sm3 cardKey without tDefaultZ");
                }
                if (zvalue.length != 32) {
                    throw new CryptoException("sm3 cardKey with invalid DefaultZ");
                }
                digest.update(zvalue, 0, 32);
            }
            hashValue = new byte[digest.getDigestSize()];
            byte[] buffer = new byte[65536];
            sourceData = new BufferedInputStream(stream);
            int rLength = 0;
            while ((rLength = ((InputStream)sourceData).read(buffer)) > 0) {
                digest.update(buffer, 0, rLength);
            }
            digest.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new CryptoException("sm3 Failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("sm3 Failure", e);
        }
        return hashValue;
    }

    static final byte[] sm3(GMTKey cardKey, byte[] sourceData) throws CryptoException {
        if (sourceData == null) {
            throw new CryptoException("sm3 missing sourceData");
        }
        byte[] hashValue = new byte[32];
        try {
            SM3Digest digest = new SM3Digest();
            if (cardKey != null) {
                byte[] zvalue = cardKey.getDefaultZ();
                if (zvalue == null) {
                    throw new CryptoException("sm3 cardKey without tDefaultZ");
                }
                if (zvalue.length != 32) {
                    throw new CryptoException("sm3 cardKey with invalid DefaultZ");
                }
                digest.update(zvalue, 0, 32);
            }
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new CryptoException("sm3 Failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("sm3 Failure", e);
        }
        return hashValue;
    }
}

