/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.ExtendLibFactory;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.lib.crypto.card.CardLibParams;
import cfca.sadk.lib.crypto.hard.HardLib;
import cfca.sadk.lib.crypto.jni.JNIInit;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.system.Environments;
import cfca.sadk.system.logging.LoggerManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JCrypto {
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JNI_LIB = "JNISOFT_LIB";
    public static final String JHARD_LIB = "JHARD_LIB";
    public static final String JCARD_LIB = "JCARD_LIB";
    public static final int DEVICE_TYPE_JSOFT_LIB = 0;
    public static final int DEVICE_TYPE_JNI_LIB = 1;
    public static final int DEVICE_TYPE_JHARD_LIB = 2;
    public static final int DEVICE_TYPE_JCARD_LIB = 3;
    private ConcurrentMap<String, Session> htable = new ConcurrentHashMap<String, Session>(4);
    private static volatile JCrypto jCrypto = null;

    private JCrypto() {
        Environments.environments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JCrypto getInstance() {
        if (jCrypto != null) return jCrypto;
        Class<JCrypto> clazz = JCrypto.class;
        synchronized (JCrypto.class) {
            if (jCrypto != null) return jCrypto;
            jCrypto = new JCrypto();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jCrypto;
        }
    }

    public Session openSession(String deviceName) throws PKIException {
        Session session = (Session)this.htable.get(deviceName);
        if (session == null) {
            throw new PKIException(PKIException.OPSESSION, PKIException.OPSESSION_DES + " " + deviceName);
        }
        return session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean initialize(String deviceName, Object param) throws PKIException {
        try {
            if (this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JSOFT_LIB)) {
                this.htable.put(deviceName, BCSoftLib.INSTANCE());
                return true;
            } else if (deviceName.equals(JHARD_LIB)) {
                if (param == null) {
                    this.htable.put(deviceName, new HardLib(null));
                    return true;
                } else {
                    if (!(param instanceof String)) throw new PKIException("initialize failure with invalid param-type: " + param);
                    this.htable.put(deviceName, new HardLib((String)param));
                }
                return true;
            } else if (deviceName.equals(JNI_LIB)) {
                LoggerManager.systemLogger.info("JNI_LIB initialize@JNIInit.initOpenSSL");
                JNIInit.initOpenSSL();
                this.htable.put(deviceName, JNISoftLib.INSTANCE());
                return true;
            } else {
                if (!deviceName.equals(JCARD_LIB)) return true;
                JNIInit.initOpenSSL();
                LoggerManager.systemLogger.info("JCARD_LIB initialize@JNIInit.initOpenSSL");
                Session session = this.buildCardLib(param);
                this.htable.put(deviceName, session);
            }
            return true;
        }
        catch (Exception ex) {
            LoggerManager.exceptionLogger.error("Jcrypto initialize failure", (Throwable)ex);
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + deviceName, ex);
        }
        catch (Throwable ex) {
            LoggerManager.exceptionLogger.error("Jcrypto initialize failure", ex);
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + deviceName, ex);
        }
    }

    private final Session buildCardLib(Object param) throws Exception {
        CardLibParams cardParams = CardLibParams.build(param);
        Session session = ExtendLibFactory.buildExtendLib(cardParams.getCardIniPath());
        if (session == null) {
            session = new CardLib(cardParams);
        }
        return session;
    }

    public long formateLocalTime(String localTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        date = simpleDateFormat.parse(localTime);
        return date.getTime();
    }

    public synchronized boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (!this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JNI_LIB)) {
                LoggerManager.systemLogger.info("JNI_LIB finalize@JNIInit.unInitOpenSSL");
                JNIInit.unInitOpenSSL();
            } else if (!deviceName.equals(JHARD_LIB) && deviceName.equals(JCARD_LIB)) {
                Session session = (Session)this.htable.get(JCARD_LIB);
                if (session != null && session instanceof CardLib) {
                    LoggerManager.systemLogger.info("JCARD_LIB finalize@unloadLib");
                    ((CardLib)session).unloadLib();
                }
                LoggerManager.systemLogger.info("JCARD_LIB finalize@JNIInit.unInitOpenSSL");
                JNIInit.unInitOpenSSL();
            }
            this.htable.remove(deviceName);
            return true;
        }
        catch (Exception ex) {
            LoggerManager.exceptionLogger.error("Jcrypto finalize failure", (Throwable)ex);
            throw new PKIException(PKIException.FINI, PKIException.FINI_DES + " " + deviceName, ex);
        }
        catch (Throwable ex) {
            LoggerManager.exceptionLogger.error("Jcrypto finalize failure", ex);
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + deviceName, ex);
        }
    }
}

