/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200r.BigIntegers;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKey;
import cfca.sadk.lib.crypto.card.c200r.RSARefPrivateKeyParams;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;

public final class C200ExternalRSAPrivateKey
extends BCRSAPrivateCrtKey
implements C200RSAKey {
    private static final long serialVersionUID = -1821426554423688246L;
    final int bitLength;
    final byte[] priKeyData;

    C200ExternalRSAPrivateKey(byte[] priKeyData) throws CardException {
        super(new RSARefPrivateKeyParams((byte[])priKeyData).params);
        this.bitLength = BigIntegers.parseModulusBitLength(priKeyData);
        this.priKeyData = priKeyData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("C200ExternalRSAPrivateKey [bitLength=");
        builder.append(this.bitLength);
        builder.append(",priKeyData=");
        builder.append(Hex.toHexString(this.priKeyData, 0, 1028));
        builder.append("]");
        return builder.toString();
    }

    public final boolean isHardKey() {
        return false;
    }

    public final int getKeyIndex() {
        return 0;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public final byte[] keyData() throws CardException {
        return (byte[])this.priKeyData.clone();
    }

    public final String dumpPublicKey() {
        return "pubKeyData=" + Hex.toHexString(this.priKeyData, 0, 1028);
    }
}

