/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Crypto;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class CipherSpi
extends javax.crypto.CipherSpi {
    protected int mode;
    protected Key key;
    protected boolean forEncryption;

    protected byte[] engineDoFinal(byte[] input, int offset, int len) throws IllegalBlockSizeException, BadPaddingException {
        SM2Crypto crypto = new SM2Crypto();
        byte[] finalData = null;
        try {
            if (this.mode == 1) {
                ECPoint Q;
                if (this.key instanceof BCECPublicKey) {
                    Q = ((BCECPublicKey)this.key).getQ();
                } else if (this.key instanceof GMTPublicKey) {
                    Q = ((GMTPublicKey)this.key).getQ();
                } else {
                    throw new InvalidParameterException("key type error,SM2PublicKey or BCECPublicKey expected!");
                }
                crypto.initEncrypt(Q);
                finalData = crypto.encrypt(input);
            } else if (this.mode == 2) {
                BigInteger d;
                if (this.key instanceof BCECPrivateKey) {
                    d = ((BCECPrivateKey)this.key).getD();
                } else if (this.key instanceof GMTPrivateKey) {
                    d = ((GMTPrivateKey)this.key).getD();
                } else {
                    throw new InvalidParameterException("key type error,SM2PrivateKey or BCECPrivateKey expected!");
                }
                crypto.initDecrypt(d);
                finalData = crypto.decrypt(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalData;
    }

    protected int engineDoFinal(byte[] input, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    protected int engineGetBlockSize() {
        return 32;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int arg0) {
        return 0;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int mode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (mode == 1) {
            if (key instanceof BCECPublicKey) {
                this.key = (BCECPublicKey)key;
                this.mode = mode;
                this.forEncryption = true;
                return;
            } else {
                if (!(key instanceof GMTPublicKey)) throw new InvalidParameterException("key type error,SM2PublicKey or BCECPublicKey expected!");
                this.key = (GMTPublicKey)key;
                this.mode = mode;
                this.forEncryption = true;
            }
            return;
        } else {
            if (mode != 2) throw new InvalidParameterException("mode error,ENCRYPT_MODE or DECRYPT_MODE expected!");
            if (key instanceof BCECPrivateKey) {
                this.key = (BCECPrivateKey)key;
                this.mode = mode;
                this.forEncryption = false;
                return;
            } else {
                if (!(key instanceof GMTPrivateKey)) throw new InvalidParameterException("key type error,SM2PrivateKey or BCECPrivateKey expected!");
                this.key = (GMTPrivateKey)key;
                this.mode = mode;
                this.forEncryption = false;
            }
        }
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameterSpec arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameters arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected void engineSetMode(String arg0) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
    }

    protected byte[] engineUpdate(byte[] arg0, int arg1, int arg2) {
        throw new UnsupportedOperationException();
    }

    protected int engineUpdate(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key paramKey) throws InvalidKeyException {
        return 32;
    }
}

