/*
 * Decompiled with CFR 0.152.
 */
package com.czb.commons.cfca;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.czb.commons.cfca.CfcaException;
import com.czb.commons.cfca.SM2CertUtils;
import com.koalii.svs.client.Svs2ClientHelper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import vot4java.runtime.Frame;
import vot4java.runtime.GenericObject;

public class SignVerUtils {
    private static final Integer CERT_ILLEGAL_CODE = -6404;
    private static final Integer CONNECT_ERR_CODE = -1;

    private SignVerUtils() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject(this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{1467516609, 0, 398342295, 1147796533};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1467516609: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case 398342295: {
                    Object object = new Object();
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject3 = new GenericObject();
                    genericObject3.setObject(object);
                    frame.push(genericObject3);
                    ++n;
                    break;
                }
                case 1147796533: {
                    return;
                }
            }
        }
    }

    public static byte[] signature(byte[] sm2CertData, String sm2FilePass, byte[] sourceData, Session session) throws PKIException, UnsupportedEncodingException {
        X509Cert x509Cert = SM2CertUtils.getX509CertFromSm2(sm2CertData);
        PrivateKey privateKey = SM2CertUtils.getPrivateKeyFromSm2(sm2CertData, sm2FilePass);
        Signature signKit = new Signature();
        String signAlg = "sm3WithSM2Encryption";
        return signKit.p7SignMessageAttach(signAlg, sourceData, privateKey, x509Cert, session);
    }

    public static boolean verify(byte[] sourceData, byte[] signContext, Session session) throws PKIException {
        Signature signKit = new Signature();
        return signKit.p7VerifyMessageDetach(sourceData, signContext, session);
    }

    public static int pkcs7VerifyWithSource(Svs2ClientHelper helper, String signData, byte[] oriData) throws UnsupportedEncodingException {
        int resCode = -1;
        Svs2ClientHelper.SvsResultData mResult = helper.parsePkcs7Sign(signData);
        if (mResult.m_originData == null) {
            String errorInfo = "P7\u63d0\u53d6\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a";
            throw new CfcaException(errorInfo);
        }
        byte[] extractData = mResult.m_originData;
        if (!MessageDigest.isEqual(oriData, extractData)) {
            String errorInfo = "P7\u63d0\u53d6\u7b7e\u540d\u539f\u6587\u548c\u539f\u59cb\u539f\u6587\u4e0d\u4e00\u81f4";
            throw new CfcaException(errorInfo);
        }
        Svs2ClientHelper.SvsResultData result = helper.pkcs7Verify(signData, oriData);
        resCode = result.m_errno;
        if (resCode != 0) {
            String errorInfo = resCode == CERT_ILLEGAL_CODE ? "\u9a8c\u7b7e\u670d\u52a1\u5668\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bc1\u4e66\u4e0d\u5408\u6cd5!" : (resCode == CONNECT_ERR_CODE ? "\u9a8c\u7b7e\u670d\u52a1\u5668\u901a\u8baf\u51fa\u9519!" : "\u5176\u4ed6\u9a8c\u7b7e\u5f02\u5e38!");
            String errMsg = String.format("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25,\u9519\u8bef\u7801\u3010%d\u3011,\u9519\u8bef\u4fe1\u606f\u3010%s\u3011", resCode, errorInfo);
            throw new CfcaException(errMsg);
        }
        return resCode;
    }

    public static int pkcs7VerifyNoSource(Svs2ClientHelper helper, String signData, byte[] oriData) throws UnsupportedEncodingException {
        int resCode = -1;
        Svs2ClientHelper.SvsResultData result = helper.pkcs7Verify(signData, oriData);
        resCode = result.m_errno;
        if (resCode != 0) {
            String errorInfo = resCode == CERT_ILLEGAL_CODE ? "\u9a8c\u7b7e\u670d\u52a1\u5668\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bc1\u4e66\u4e0d\u5408\u6cd5!" : (resCode == CONNECT_ERR_CODE ? "\u9a8c\u7b7e\u670d\u52a1\u5668\u901a\u8baf\u51fa\u9519!" : "\u5176\u4ed6\u9a8c\u7b7e\u5f02\u5e38!");
            String errMsg = String.format("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25,\u9519\u8bef\u7801\u3010%d\u3011,\u9519\u8bef\u4fe1\u606f\u3010%s\u3011", resCode, errorInfo);
            throw new CfcaException(errMsg);
        }
        return resCode;
    }
}

